/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker.util.logging;

import java.io.InputStream;
import java.util.Properties;
import org.apache.ojb.broker.util.ClassHelper;
import org.apache.ojb.broker.util.configuration.impl.ConfigurationAbstractImpl;
import org.apache.ojb.broker.util.logging.Logger;
import org.apache.ojb.broker.util.logging.LoggerFactory;

public class LoggingConfiguration
extends ConfigurationAbstractImpl {
    public static final String PROPERTY_COMMONS_LOGGING_LOG = "org.apache.commons.logging.Log";
    public static final String PROPERTY_COMMONS_LOGGING_LOGFACTORY = "org.apache.commons.logging.LogFactory";
    public static final String PROPERTY_OJB_LOGGERCLASS = "org.apache.ojb.broker.util.logging.Logger.class";
    public static final String PROPERTY_OJB_LOGGERCONFIGFILE = "org.apache.ojb.broker.util.logging.Logger.configFile";
    public static final String OJB_LOGGING_PROPERTIES_FILE = "OJB-logging.properties";
    public static final String OJB_DEFAULT_LOG_LEVEL = "WARN";
    private Class _loggerClass;
    private String _loggerConfigFile;
    static /* synthetic */ Class class$org$apache$ojb$broker$util$logging$PoorMansLoggerImpl;
    static /* synthetic */ Class class$org$apache$ojb$broker$util$logging$CommonsLoggerImpl;
    static /* synthetic */ Class class$org$apache$ojb$broker$util$logging$Log4jLoggerImpl;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void load() {
        InputStream inputStream;
        String string;
        Logger logger = LoggerFactory.getBootLogger();
        ClassLoader classLoader = ClassHelper.getClassLoader();
        String string2 = null;
        this._loggerClass = null;
        this.properties = new Properties();
        string2 = this.getLoggerClass(System.getProperties());
        this._loggerConfigFile = this.getLoggerConfigFile(System.getProperties());
        if (string2 == null) {
            string = System.getProperty(OJB_LOGGING_PROPERTIES_FILE, OJB_LOGGING_PROPERTIES_FILE);
            try {
                inputStream = classLoader.getResourceAsStream(OJB_LOGGING_PROPERTIES_FILE);
                if (inputStream != null) {
                    logger.debug("Found logging properties file OJB-logging.properties");
                    this.properties.load(inputStream);
                    string2 = this.getLoggerClass(this.properties);
                    this._loggerConfigFile = this.getLoggerConfigFile(this.properties);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (string2 == null) {
            string = System.getProperty("OJB.properties", "OJB.properties");
            try {
                inputStream = classLoader.getResourceAsStream(string);
                if (inputStream != null) {
                    this.properties.load(inputStream);
                    string2 = this.getLoggerClass(this.properties);
                    this._loggerConfigFile = this.getLoggerConfigFile(this.properties);
                    if (string2 == null) {
                        // empty if block
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (string2 != null) {
            try {
                this._loggerClass = Class.forName(string2);
                return;
            }
            catch (ClassNotFoundException classNotFoundException) {
                this._loggerClass = class$org$apache$ojb$broker$util$logging$PoorMansLoggerImpl == null ? (class$org$apache$ojb$broker$util$logging$PoorMansLoggerImpl = LoggingConfiguration.class$("org.apache.ojb.broker.util.logging.PoorMansLoggerImpl")) : class$org$apache$ojb$broker$util$logging$PoorMansLoggerImpl;
                logger.warn("Could not load logger class " + string2 + ", defaulting to " + this._loggerClass.getName(), classNotFoundException);
                return;
            }
        }
        if (System.getProperty(PROPERTY_COMMONS_LOGGING_LOG) != null || System.getProperty(PROPERTY_COMMONS_LOGGING_LOGFACTORY) != null) {
            this._loggerClass = class$org$apache$ojb$broker$util$logging$CommonsLoggerImpl == null ? (class$org$apache$ojb$broker$util$logging$CommonsLoggerImpl = LoggingConfiguration.class$("org.apache.ojb.broker.util.logging.CommonsLoggerImpl")) : class$org$apache$ojb$broker$util$logging$CommonsLoggerImpl;
            return;
        }
        try {
            if (classLoader.getResourceAsStream("log4j.properties") != null) {
                this._loggerClass = class$org$apache$ojb$broker$util$logging$Log4jLoggerImpl == null ? (class$org$apache$ojb$broker$util$logging$Log4jLoggerImpl = LoggingConfiguration.class$("org.apache.ojb.broker.util.logging.Log4jLoggerImpl")) : class$org$apache$ojb$broker$util$logging$Log4jLoggerImpl;
                this._loggerConfigFile = "log4j.properties";
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this._loggerClass != null) return;
        try {
            if (classLoader.getResourceAsStream("commons-logging.properties") != null) {
                this._loggerClass = class$org$apache$ojb$broker$util$logging$CommonsLoggerImpl == null ? (class$org$apache$ojb$broker$util$logging$CommonsLoggerImpl = LoggingConfiguration.class$("org.apache.ojb.broker.util.logging.CommonsLoggerImpl")) : class$org$apache$ojb$broker$util$logging$CommonsLoggerImpl;
                this._loggerConfigFile = "commons-logging.properties";
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this._loggerClass = class$org$apache$ojb$broker$util$logging$PoorMansLoggerImpl == null ? (class$org$apache$ojb$broker$util$logging$PoorMansLoggerImpl = LoggingConfiguration.class$("org.apache.ojb.broker.util.logging.PoorMansLoggerImpl")) : class$org$apache$ojb$broker$util$logging$PoorMansLoggerImpl;
    }

    private String getLoggerClass(Properties properties) {
        String string = properties.getProperty(PROPERTY_OJB_LOGGERCLASS);
        if (string == null) {
            string = properties.getProperty("LoggerClass");
        }
        return string;
    }

    private String getLoggerConfigFile(Properties properties) {
        String string = properties.getProperty(PROPERTY_OJB_LOGGERCONFIGFILE);
        if (string == null) {
            string = properties.getProperty("LoggerConfigFile");
        }
        return string;
    }

    public String getLogLevel(String string) {
        return this.getString(string + ".LogLevel", this.getString("ROOT.LogLevel", OJB_DEFAULT_LOG_LEVEL));
    }

    public void setLogger(Logger logger) {
    }

    public Class getLoggerClass() {
        return this._loggerClass;
    }

    public String getLoggerConfigFile() {
        return this._loggerConfigFile;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

