/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker.util.logging;

import org.apache.ojb.broker.util.configuration.Configuration;
import org.apache.ojb.broker.util.configuration.ConfigurationException;
import org.apache.ojb.broker.util.logging.Logger;
import org.apache.ojb.broker.util.logging.LoggingConfiguration;

public class PoorMansLoggerImpl
implements Logger {
    private String name;
    private int level = 0;

    public PoorMansLoggerImpl(String string) {
        this.name = string;
    }

    protected int getLevel() {
        return this.level;
    }

    void setLevel(int n) {
        this.level = n;
    }

    public String getName() {
        return this.name;
    }

    public void debug(Object object) {
        this.debug(object, null);
    }

    public void debug(Object object, Throwable throwable) {
        if (1 >= this.getLevel()) {
            this.log("DEBUG: ", object, throwable);
        }
    }

    public void safeDebug(String string, Object object) {
        this.safeDebug(string, object, null);
    }

    public void safeDebug(String string, Object object, Throwable throwable) {
        if (1 >= this.getLevel()) {
            String string2 = null;
            if (object != null) {
                try {
                    string2 = object.toString();
                }
                catch (Throwable throwable2) {
                    string2 = "BAD toString() impl for " + object.getClass().getName();
                }
            }
            this.log("DEBUG: ", string + " : " + string2, throwable);
        }
    }

    public void info(Object object) {
        this.info(object, null);
    }

    public void info(Object object, Throwable throwable) {
        if (2 >= this.getLevel()) {
            this.log("INFO: ", object, throwable);
        }
    }

    public void safeInfo(String string, Object object) {
        this.safeInfo(string, object, null);
    }

    public void safeInfo(String string, Object object, Throwable throwable) {
        if (2 >= this.getLevel()) {
            String string2 = null;
            if (object != null) {
                try {
                    string2 = object.toString();
                }
                catch (Throwable throwable2) {
                    string2 = "BAD toString() impl for " + object.getClass().getName();
                }
            }
            this.log("INFO: ", string + " : " + string2, throwable);
        }
    }

    public void warn(Object object) {
        this.warn(object, null);
    }

    public void warn(Object object, Throwable throwable) {
        if (3 >= this.getLevel()) {
            this.log("WARN: ", object, throwable);
        }
    }

    public void safeWarn(String string, Object object) {
        this.safeWarn(string, object, null);
    }

    public void safeWarn(String string, Object object, Throwable throwable) {
        if (3 >= this.getLevel()) {
            String string2 = null;
            if (object != null) {
                try {
                    string2 = object.toString();
                }
                catch (Throwable throwable2) {
                    string2 = "BAD toString() impl for " + object.getClass().getName();
                }
            }
            this.log("WARN: ", string + " : " + string2, throwable);
        }
    }

    public void error(Object object) {
        this.error(object, null);
    }

    public void error(Object object, Throwable throwable) {
        if (4 >= this.getLevel()) {
            this.log("ERROR: ", object, throwable);
        }
    }

    public void safeError(String string, Object object) {
        this.safeError(string, object, null);
    }

    public void safeError(String string, Object object, Throwable throwable) {
        if (4 >= this.getLevel()) {
            String string2 = null;
            if (object != null) {
                try {
                    string2 = object.toString();
                }
                catch (Throwable throwable2) {
                    string2 = "BAD toString() impl for " + object.getClass().getName();
                }
            }
            this.log("ERROR: ", string + " : " + string2, throwable);
        }
    }

    public void fatal(Object object) {
        this.fatal(object, null);
    }

    public void fatal(Object object, Throwable throwable) {
        if (5 >= this.getLevel()) {
            this.log("FATAL: ", object, throwable);
        }
    }

    public void safeFatal(String string, Object object) {
        this.safeFatal(string, object, null);
    }

    public void safeFatal(String string, Object object, Throwable throwable) {
        if (5 >= this.getLevel()) {
            String string2 = null;
            if (object != null) {
                try {
                    string2 = object.toString();
                }
                catch (Throwable throwable2) {
                    string2 = "BAD toString() impl for " + object.getClass().getName();
                }
            }
            this.log("FATAL: ", string + " : " + string2, throwable);
        }
    }

    public boolean isDebugEnabled() {
        return this.isEnabledFor(1);
    }

    public boolean isEnabledFor(int n) {
        return n >= this.getLevel();
    }

    protected void log(String string, Object object, Throwable throwable) {
        System.out.print("[" + this.name + "] " + string);
        if (object != null && object instanceof Throwable) {
            try {
                System.out.println(((Throwable)object).getMessage());
                ((Throwable)object).printStackTrace();
            }
            catch (Throwable throwable2) {}
        } else {
            System.out.println(object);
        }
        if (throwable != null) {
            try {
                System.out.println(throwable.getMessage());
                throwable.printStackTrace();
            }
            catch (Throwable throwable3) {
                // empty catch block
            }
        }
    }

    public void configure(Configuration configuration) throws ConfigurationException {
        LoggingConfiguration loggingConfiguration = (LoggingConfiguration)configuration;
        String string = loggingConfiguration.getLogLevel(this.name);
        this.setLevel(string);
    }

    public void setLevel(String string) {
        this.level = string.equalsIgnoreCase("DEBUG") ? 1 : (string.equalsIgnoreCase("INFO") ? 2 : (string.equalsIgnoreCase("WARN") ? 3 : (string.equalsIgnoreCase("ERROR") ? 4 : (string.equalsIgnoreCase("FATAL") ? 5 : 3))));
    }
}

