/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.odmg.collections;

import java.io.Serializable;
import java.util.AbstractMap;
import java.util.Iterator;
import java.util.Set;
import org.apache.ojb.broker.PBKey;
import org.apache.ojb.broker.PersistenceBroker;
import org.apache.ojb.broker.PersistenceBrokerException;
import org.apache.ojb.broker.metadata.FieldDescriptor;
import org.apache.ojb.broker.metadata.fieldaccess.PersistentFieldFactory;
import org.apache.ojb.broker.util.collections.ManageableHashSet;
import org.apache.ojb.broker.util.logging.LoggerFactory;
import org.apache.ojb.odmg.PBCapsule;
import org.apache.ojb.odmg.TransactionImpl;
import org.apache.ojb.odmg.TxManagerFactory;
import org.apache.ojb.odmg.collections.DMapEntry;
import org.odmg.DMap;

public class DMapImpl
extends AbstractMap
implements DMap,
Serializable {
    private static final long serialVersionUID = 7048246616243056480L;
    private int id = -1;
    private ManageableHashSet entries;
    private int size = 0;
    private PBKey pbKey;

    public DMapImpl() {
        this.entries = new ManageableHashSet();
        if (!PersistentFieldFactory.usesAccessorsAndMutators()) {
            this.id = this.generateNewId();
        }
    }

    public DMapImpl(PBKey pBKey) {
        this.entries = new ManageableHashSet();
        this.pbKey = pBKey;
        if (!PersistentFieldFactory.usesAccessorsAndMutators()) {
            this.id = this.generateNewId();
        }
    }

    public DMapImpl(int n, int n2) {
        this.id = n;
        this.size = n2;
    }

    public PBKey getPBKey() {
        return this.pbKey;
    }

    public void setPBKey(PBKey pBKey) {
        this.pbKey = pBKey;
    }

    public Set entrySet() {
        return this.entries;
    }

    protected int generateNewId() {
        PBCapsule pBCapsule = new PBCapsule(null, TxManagerFactory.instance().getTransaction());
        try {
            int n;
            PersistenceBroker persistenceBroker = pBCapsule.getBroker();
            FieldDescriptor fieldDescriptor = persistenceBroker.getClassDescriptor(this.getClass()).getAutoIncrementFields()[0];
            Integer n2 = (Integer)persistenceBroker.serviceSequenceManager().getUniqueValue(fieldDescriptor);
            int n3 = n = n2.intValue();
            return n3;
        }
        catch (Exception exception) {
            LoggerFactory.getDefaultLogger().error("DMapImpl: Generation of new id failed", exception);
            throw new PersistenceBrokerException(exception);
        }
        finally {
            pBCapsule.destroy();
        }
    }

    public int getId() {
        if (this.id == -1) {
            this.id = this.generateNewId();
        }
        return this.id;
    }

    public Object put(Object object, Object object2) {
        DMapEntry dMapEntry = new DMapEntry(this, object, object2);
        boolean bl = this.entries.add(dMapEntry);
        if (bl) {
            TransactionImpl transactionImpl = TxManagerFactory.instance().getTransaction();
            if (transactionImpl != null && transactionImpl.isOpen()) {
                transactionImpl.lock(this, 4);
                transactionImpl.lock(dMapEntry, 4);
                transactionImpl.lock(object, 1);
                transactionImpl.lock(object2, 1);
            }
            return null;
        }
        return this.get(object);
    }

    public Object remove(Object object) {
        Object object2;
        Iterator iterator = this.entrySet().iterator();
        Object object3 = null;
        if (object == null) {
            while (object3 == null && iterator.hasNext()) {
                object2 = (DMapEntry)iterator.next();
                if (((DMapEntry)object2).getKey() != null) continue;
                object3 = object2;
            }
        } else {
            while (object3 == null && iterator.hasNext()) {
                object2 = (DMapEntry)iterator.next();
                if (!object.equals(((DMapEntry)object2).getKey())) continue;
                object3 = object2;
            }
        }
        object2 = null;
        if (object3 != null) {
            object2 = ((DMapEntry)object3).getValue();
            iterator.remove();
            TransactionImpl transactionImpl = TxManagerFactory.instance().getTransaction();
            if (transactionImpl != null && transactionImpl.isOpen()) {
                transactionImpl.markDelete(object3);
            }
        }
        return object2;
    }

    public ManageableHashSet getEntries() {
        return this.entries;
    }

    public void setEntries(ManageableHashSet manageableHashSet) {
        this.entries = manageableHashSet;
    }

    public void setId(int n) {
        this.id = n;
    }

    public int getSize() {
        return this.size;
    }

    public void setSize(int n) {
        this.size = n;
    }
}

