/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.odmg.collections;

import java.io.Serializable;
import java.util.AbstractSet;
import java.util.Iterator;
import java.util.Vector;
import org.apache.ojb.broker.PBKey;
import org.apache.ojb.broker.PersistenceBroker;
import org.apache.ojb.broker.PersistenceBrokerException;
import org.apache.ojb.broker.core.ValueContainer;
import org.apache.ojb.broker.metadata.ClassDescriptor;
import org.apache.ojb.broker.metadata.FieldDescriptor;
import org.apache.ojb.broker.query.Criteria;
import org.apache.ojb.broker.query.Query;
import org.apache.ojb.broker.query.QueryByCriteria;
import org.apache.ojb.broker.util.logging.Logger;
import org.apache.ojb.broker.util.logging.LoggerFactory;
import org.apache.ojb.odmg.PBCapsule;
import org.apache.ojb.odmg.TransactionImpl;
import org.apache.ojb.odmg.TxManagerFactory;
import org.apache.ojb.odmg.collections.DListEntry;
import org.apache.ojb.odmg.collections.DSetEntry;
import org.apache.ojb.odmg.collections.DSetIterator;
import org.apache.ojb.odmg.oql.OQLQueryImpl;
import org.odmg.DCollection;
import org.odmg.DList;
import org.odmg.DSet;
import org.odmg.ODMGRuntimeException;
import org.odmg.QueryInvalidException;

public class DSetImpl
extends AbstractSet
implements DSet,
Serializable {
    private static final long serialVersionUID = -4459673364598652639L;
    private Logger log = LoggerFactory.getLogger(class$org$apache$ojb$odmg$collections$DSetImpl == null ? (class$org$apache$ojb$odmg$collections$DSetImpl = DSetImpl.class$("org.apache.ojb.odmg.collections.DSetImpl")) : class$org$apache$ojb$odmg$collections$DSetImpl);
    private int id = -1;
    private Vector elements = new Vector();
    private int size;
    private PBKey pbKey;
    static /* synthetic */ Class class$org$apache$ojb$odmg$collections$DSetImpl;

    public DSetImpl() {
        this.size = 0;
    }

    public DSetImpl(PBKey pBKey) {
        this.size = 0;
        this.pbKey = pBKey;
    }

    public DSetImpl(int n, int n2) {
        this.id = n;
        this.size = n2;
    }

    private TransactionImpl getTransaction() {
        return TxManagerFactory.instance().getTransaction();
    }

    public boolean add(Object object) {
        if (!this.contains(object)) {
            ++this.size;
            DSetEntry dSetEntry = new DSetEntry(this, object);
            this.elements.add(dSetEntry);
            TransactionImpl transactionImpl = this.getTransaction();
            if (transactionImpl != null && transactionImpl.isOpen()) {
                transactionImpl.lock(this, 4);
                transactionImpl.lock(dSetEntry, 4);
                transactionImpl.lock(object, 1);
            }
            return true;
        }
        return false;
    }

    public DSet difference(DSet dSet) {
        DSetImpl dSetImpl = new DSetImpl(this.pbKey);
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (dSet.contains(e)) continue;
            dSetImpl.add(e);
        }
        return dSetImpl;
    }

    public boolean existsElement(String string) throws QueryInvalidException {
        DList dList = (DList)this.query(string);
        return dList != null && dList.size() != 0;
    }

    protected int generateNewId() {
        PBCapsule pBCapsule = new PBCapsule(null, TxManagerFactory.instance().getTransaction());
        try {
            int n;
            ClassDescriptor classDescriptor = pBCapsule.getBroker().getClassDescriptor(this.getClass());
            FieldDescriptor fieldDescriptor = classDescriptor.getFieldDescriptorByName("id");
            Integer n2 = (Integer)pBCapsule.getBroker().serviceSequenceManager().getUniqueValue(fieldDescriptor);
            int n3 = n = n2.intValue();
            return n3;
        }
        catch (Exception exception) {
            this.log.error("Generation of new id failed", exception);
            throw new PersistenceBrokerException(exception);
        }
        finally {
            pBCapsule.destroy();
        }
    }

    public Vector getElements() {
        return this.elements;
    }

    public int getId() {
        if (this.id == -1) {
            this.id = this.generateNewId();
        }
        return this.id;
    }

    public DSet intersection(DSet dSet) {
        DSet dSet2 = this.union(dSet);
        DSetImpl dSetImpl = new DSetImpl(this.pbKey);
        Iterator iterator = dSet2.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (!this.contains(e) || !dSet.contains(e)) continue;
            dSetImpl.add(e);
        }
        return dSetImpl;
    }

    public Iterator iterator() {
        return new DSetIterator(this);
    }

    public boolean properSubsetOf(DSet dSet) {
        return this.size() > 0 && this.size() < dSet.size() && this.subsetOf(dSet);
    }

    public boolean properSupersetOf(DSet dSet) {
        return dSet.size() > 0 && dSet.size() < this.size() && this.supersetOf(dSet);
    }

    public DCollection query(String string) throws QueryInvalidException {
        String string2 = "select all from java.lang.Object where " + string;
        OQLQueryImpl oQLQueryImpl = new OQLQueryImpl(this.pbKey);
        TransactionImpl transactionImpl = this.getTransaction();
        PBCapsule pBCapsule = new PBCapsule(this.pbKey, transactionImpl);
        PersistenceBroker persistenceBroker = pBCapsule.getBroker();
        try {
            oQLQueryImpl.create(string2);
            Query query = oQLQueryImpl.getQuery();
            Criteria criteria = query.getCriteria();
            Criteria criteria2 = this.getPkCriteriaForAllElements(persistenceBroker);
            criteria.addAndCriteria(criteria2);
            Class clazz = this.getElementsExtentClass(persistenceBroker);
            QueryByCriteria queryByCriteria = new QueryByCriteria(clazz, criteria);
            if (this.log.isDebugEnabled()) {
                this.log.debug(((Object)queryByCriteria).toString());
            }
            DSetImpl dSetImpl = (DSetImpl)((Object)persistenceBroker.getCollectionByQuery(class$org$apache$ojb$odmg$collections$DSetImpl == null ? (class$org$apache$ojb$odmg$collections$DSetImpl = DSetImpl.class$("org.apache.ojb.odmg.collections.DSetImpl")) : class$org$apache$ojb$odmg$collections$DSetImpl, queryByCriteria));
            return dSetImpl;
        }
        catch (PersistenceBrokerException persistenceBrokerException) {
            throw new ODMGRuntimeException(persistenceBrokerException.getMessage());
        }
        finally {
            pBCapsule.destroy();
        }
    }

    private Criteria getPkCriteriaForAllElements(PersistenceBroker persistenceBroker) {
        try {
            Criteria criteria = null;
            for (int i = 0; i < this.elements.size(); ++i) {
                DListEntry dListEntry = (DListEntry)this.elements.get(i);
                Object object = dListEntry.getRealSubject();
                ClassDescriptor classDescriptor = persistenceBroker.getClassDescriptor(object.getClass());
                FieldDescriptor[] fieldDescriptorArray = classDescriptor.getPkFields();
                ValueContainer[] valueContainerArray = persistenceBroker.serviceBrokerHelper().getKeyValues(classDescriptor, object);
                Criteria criteria2 = new Criteria();
                for (int j = 0; j < fieldDescriptorArray.length; ++j) {
                    FieldDescriptor fieldDescriptor = fieldDescriptorArray[j];
                    criteria2.addEqualTo(fieldDescriptor.getPersistentField().getName(), valueContainerArray[j].getValue());
                }
                if (criteria == null) {
                    criteria = criteria2;
                    continue;
                }
                criteria.addOrCriteria(criteria2);
            }
            return criteria;
        }
        catch (PersistenceBrokerException persistenceBrokerException) {
            this.log.error((Object)persistenceBrokerException);
            return null;
        }
    }

    private Class getElementsExtentClass(PersistenceBroker persistenceBroker) throws PersistenceBrokerException {
        DListEntry dListEntry = (DListEntry)this.elements.get(0);
        Class<?> clazz = dListEntry.getRealSubject().getClass();
        Class clazz2 = persistenceBroker.getTopLevelClass(clazz);
        return clazz2;
    }

    public Iterator select(String string) throws QueryInvalidException {
        return this.query(string).iterator();
    }

    public Object selectElement(String string) throws QueryInvalidException {
        return ((DList)this.query(string)).get(0);
    }

    public void setElements(Vector vector) {
        this.elements = vector;
    }

    public void setId(int n) {
        this.id = n;
    }

    public int size() {
        return this.elements.size();
    }

    public boolean subsetOf(DSet dSet) {
        return dSet.containsAll(this);
    }

    public boolean supersetOf(DSet dSet) {
        return this.containsAll(dSet);
    }

    public DSet union(DSet dSet) {
        DSetImpl dSetImpl = new DSetImpl(this.pbKey);
        dSetImpl.addAll(this);
        dSetImpl.addAll(dSet);
        return dSetImpl;
    }

    public int getSize() {
        return this.size;
    }

    public void setSize(int n) {
        this.size = n;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

