/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.odmg.locking;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.ojb.broker.Identity;
import org.apache.ojb.broker.PersistenceBrokerException;
import org.apache.ojb.odmg.locking.InMemoryLockMapImpl;
import org.apache.ojb.odmg.locking.LockEntry;

public class LockServerServlet
extends HttpServlet {
    private static int numRequests;
    private static InMemoryLockMapImpl lockmap;
    private static Throwable lastError;

    protected void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        httpServletResponse.setContentType("text/html");
        httpServletResponse.setHeader("Pragma", "no-cache");
        PrintWriter printWriter = httpServletResponse.getWriter();
        printWriter.println("<html><head><title>OJB Distributed Locking Servlet Status Page</title>");
        printWriter.println("</head><body><h1>OJB Distributed Locking Servlet</h1>");
        printWriter.println("The servlet is running.<p>");
        if (lastError == null) {
            printWriter.println("The LockServer is running.<p>");
            printWriter.println("Persistent Locks: " + lockmap.getSize() + "<p>");
            printWriter.println("Processed Lock Request: " + numRequests + "<p>");
        } else {
            printWriter.println("<h2>The LockServer has a problem!</h2>");
            printWriter.println("The error message is:<p>");
            printWriter.println(lastError.getMessage() + "<p>");
            lastError.printStackTrace(printWriter);
            lastError = null;
        }
        printWriter.println("</body></html>");
    }

    protected void doPost(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        ++numRequests;
        try {
            byte[] byArray = this.getRequestByteArray(httpServletRequest);
            byte by = byArray[0];
            byte[] byArray2 = new byte[byArray.length - 1];
            System.arraycopy(byArray, 1, byArray2, 0, byArray2.length);
            Object object = null;
            switch (by) {
                case 119: {
                    object = this.getWriter(byArray2);
                    break;
                }
                case 114: {
                    object = this.getAllReaders(byArray2);
                    break;
                }
                case 97: {
                    try {
                        object = this.addReader(byArray2);
                    }
                    catch (Throwable throwable) {
                        object = Boolean.FALSE;
                    }
                    break;
                }
                case 101: {
                    try {
                        object = this.removeReader(byArray2);
                    }
                    catch (Throwable throwable) {
                        object = Boolean.FALSE;
                    }
                    break;
                }
                case 109: {
                    try {
                        object = this.removeWriter(byArray2);
                    }
                    catch (Throwable throwable) {
                        object = Boolean.FALSE;
                    }
                    break;
                }
                case 117: {
                    try {
                        object = this.upgradeLock(byArray2);
                    }
                    catch (Throwable throwable) {
                        object = Boolean.FALSE;
                    }
                }
                case 115: {
                    try {
                        object = this.setWriter(byArray2);
                    }
                    catch (Throwable throwable) {
                        object = Boolean.FALSE;
                    }
                    break;
                }
                case 104: {
                    try {
                        object = this.hasReadLock(byArray2);
                    }
                    catch (Throwable throwable) {
                        object = Boolean.FALSE;
                    }
                    break;
                }
                default: {
                    object = new PersistenceBrokerException("unknown command:" + by);
                }
            }
            ObjectOutputStream objectOutputStream = new ObjectOutputStream((OutputStream)httpServletResponse.getOutputStream());
            objectOutputStream.writeObject(object);
            objectOutputStream.flush();
            objectOutputStream.close();
        }
        catch (Throwable throwable) {
            lastError = throwable;
            System.err.println(throwable.getMessage());
            throwable.printStackTrace(System.err);
        }
    }

    private LockEntry getWriter(byte[] byArray) throws IOException, ClassNotFoundException {
        Identity identity = (Identity)this.deserialize(byArray);
        LockEntry lockEntry = lockmap.getWriter(identity);
        return lockEntry;
    }

    private Collection getAllReaders(byte[] byArray) throws IOException, ClassNotFoundException {
        Identity identity = (Identity)this.deserialize(byArray);
        Collection collection = lockmap.getReaders(identity);
        return new ArrayList(collection);
    }

    private Boolean addReader(byte[] byArray) throws IOException, ClassNotFoundException {
        Boolean bl = Boolean.TRUE;
        LockEntry lockEntry = (LockEntry)this.deserialize(byArray);
        try {
            lockmap.addReaderInternal(lockEntry);
        }
        catch (Throwable throwable) {
            bl = Boolean.FALSE;
        }
        return bl;
    }

    private Boolean removeReader(byte[] byArray) throws IOException, ClassNotFoundException {
        Boolean bl = Boolean.TRUE;
        LockEntry lockEntry = (LockEntry)this.deserialize(byArray);
        try {
            lockmap.removeReaderByLock(lockEntry);
        }
        catch (Throwable throwable) {
            bl = Boolean.FALSE;
        }
        return bl;
    }

    private Boolean removeWriter(byte[] byArray) throws IOException, ClassNotFoundException {
        Boolean bl = Boolean.TRUE;
        LockEntry lockEntry = (LockEntry)this.deserialize(byArray);
        try {
            lockmap.removeWriter(lockEntry);
        }
        catch (Throwable throwable) {
            bl = Boolean.FALSE;
        }
        return bl;
    }

    private Boolean upgradeLock(byte[] byArray) throws IOException, ClassNotFoundException {
        Boolean bl = Boolean.TRUE;
        LockEntry lockEntry = (LockEntry)this.deserialize(byArray);
        try {
            lockmap.upgradeLock(lockEntry);
        }
        catch (Throwable throwable) {
            bl = Boolean.FALSE;
        }
        return bl;
    }

    private Boolean setWriter(byte[] byArray) throws IOException, ClassNotFoundException {
        Boolean bl = Boolean.TRUE;
        LockEntry lockEntry = (LockEntry)this.deserialize(byArray);
        try {
            lockmap.setWriterByLock(lockEntry);
        }
        catch (Throwable throwable) {
            bl = Boolean.FALSE;
        }
        return bl;
    }

    private Boolean hasReadLock(byte[] byArray) throws IOException, ClassNotFoundException {
        Boolean bl = Boolean.TRUE;
        LockEntry lockEntry = (LockEntry)this.deserialize(byArray);
        try {
            lockmap.hasReadLock(lockEntry);
        }
        catch (Throwable throwable) {
            bl = Boolean.FALSE;
        }
        return bl;
    }

    private Object deserialize(byte[] byArray) throws IOException, ClassNotFoundException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);
        Object object = objectInputStream.readObject();
        objectInputStream.close();
        byteArrayInputStream.close();
        return object;
    }

    private byte[] getRequestByteArray(HttpServletRequest httpServletRequest) throws IOException {
        ServletInputStream servletInputStream = httpServletRequest.getInputStream();
        byte[] byArray = new byte[4096];
        byte[] byArray2 = null;
        int n = 0;
        n = servletInputStream.read(byArray, 0, byArray.length);
        if (n <= 0) {
            return null;
        }
        byArray2 = new byte[n];
        System.arraycopy(byArray, 0, byArray2, 0, n);
        while (n > 0 && (n = servletInputStream.read(byArray, 0, byArray.length)) > 0) {
            byte[] byArray3 = new byte[byArray2.length + n];
            System.arraycopy(byArray2, 0, byArray3, 0, byArray2.length);
            System.arraycopy(byArray, 0, byArray3, byArray2.length, n);
            byArray2 = byArray3;
        }
        return byArray2;
    }

    static {
        lockmap = new InMemoryLockMapImpl();
        lastError = null;
    }
}

