/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.odmg.locking;

import org.apache.ojb.broker.PersistenceBrokerException;
import org.apache.ojb.broker.core.proxy.ProxyHelper;
import org.apache.ojb.broker.metadata.ClassDescriptor;
import org.apache.ojb.odmg.TxManagerFactory;
import org.apache.ojb.odmg.locking.LockStrategy;
import org.apache.ojb.odmg.locking.ReadCommittedStrategy;
import org.apache.ojb.odmg.locking.ReadUncommittedStrategy;
import org.apache.ojb.odmg.locking.RepeatableReadStrategy;
import org.apache.ojb.odmg.locking.SerializableStrategy;

public class LockStrategyFactory {
    private static LockStrategy readUncommitedStrategy = new ReadUncommittedStrategy();
    private static LockStrategy readCommitedStrategy = new ReadCommittedStrategy();
    private static LockStrategy readRepeatableStrategy = new RepeatableReadStrategy();
    private static LockStrategy serializableStrategy = new SerializableStrategy();

    private LockStrategyFactory() {
    }

    public static LockStrategy getStrategyFor(Object object) {
        int n = LockStrategyFactory.getIsolationLevel(object);
        switch (n) {
            case 0: {
                return readUncommitedStrategy;
            }
            case 1: {
                return readCommitedStrategy;
            }
            case 2: {
                return readRepeatableStrategy;
            }
            case 3: {
                return serializableStrategy;
            }
        }
        return readUncommitedStrategy;
    }

    public static int getIsolationLevel(Object object) {
        Class clazz = ProxyHelper.getRealClass(object);
        int n = 0;
        try {
            ClassDescriptor classDescriptor = TxManagerFactory.instance().getCurrentTransaction().getBroker().getClassDescriptor(clazz);
            n = classDescriptor.getIsolationLevel();
        }
        catch (PersistenceBrokerException persistenceBrokerException) {
            // empty catch block
        }
        return n;
    }
}

