/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.odmg.locking;

import org.apache.ojb.odmg.TransactionImpl;
import org.apache.ojb.odmg.locking.AbstractLockStrategy;
import org.apache.ojb.odmg.locking.LockEntry;

public class ReadUncommittedStrategy
extends AbstractLockStrategy {
    public boolean readLock(TransactionImpl transactionImpl, Object object) {
        return true;
    }

    public boolean writeLock(TransactionImpl transactionImpl, Object object) {
        LockEntry lockEntry = this.getWriter(object);
        if (lockEntry == null) {
            if (this.setWriter(transactionImpl, object)) {
                return true;
            }
            return this.writeLock(transactionImpl, object);
        }
        return lockEntry.isOwnedBy(transactionImpl);
    }

    public boolean upgradeLock(TransactionImpl transactionImpl, Object object) {
        LockEntry lockEntry = this.getWriter(object);
        if (lockEntry == null) {
            if (this.setWriter(transactionImpl, object)) {
                return true;
            }
            return this.upgradeLock(transactionImpl, object);
        }
        return lockEntry.isOwnedBy(transactionImpl);
    }

    public boolean releaseLock(TransactionImpl transactionImpl, Object object) {
        LockEntry lockEntry = this.getWriter(object);
        if (lockEntry != null && lockEntry.isOwnedBy(transactionImpl)) {
            this.removeWriter(lockEntry);
            return true;
        }
        return true;
    }

    public boolean checkRead(TransactionImpl transactionImpl, Object object) {
        return true;
    }

    public boolean checkWrite(TransactionImpl transactionImpl, Object object) {
        LockEntry lockEntry = this.getWriter(object);
        return lockEntry != null && lockEntry.isOwnedBy(transactionImpl);
    }
}

