/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.odmg.oql;

import antlr.RecognitionException;
import antlr.TokenStreamException;
import java.io.Serializable;
import java.io.StringReader;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.Vector;
import org.apache.ojb.broker.ManageableCollection;
import org.apache.ojb.broker.PBKey;
import org.apache.ojb.broker.PersistenceBroker;
import org.apache.ojb.broker.PersistenceBrokerFactory;
import org.apache.ojb.broker.accesslayer.OJBIterator;
import org.apache.ojb.broker.query.BetweenCriteria;
import org.apache.ojb.broker.query.Criteria;
import org.apache.ojb.broker.query.Query;
import org.apache.ojb.broker.query.ReportQuery;
import org.apache.ojb.broker.query.SelectionCriteria;
import org.apache.ojb.broker.util.collections.ManageableArrayList;
import org.apache.ojb.broker.util.configuration.Configurable;
import org.apache.ojb.broker.util.configuration.Configuration;
import org.apache.ojb.broker.util.configuration.ConfigurationException;
import org.apache.ojb.broker.util.logging.Logger;
import org.apache.ojb.broker.util.logging.LoggerFactory;
import org.apache.ojb.odmg.OdmgConfiguration;
import org.apache.ojb.odmg.PBCapsule;
import org.apache.ojb.odmg.TransactionImpl;
import org.apache.ojb.odmg.TxManagerFactory;
import org.apache.ojb.odmg.oql.EnhancedOQLQuery;
import org.apache.ojb.odmg.oql.OQLLexer;
import org.apache.ojb.odmg.oql.OQLParser;
import org.odmg.QueryException;
import org.odmg.QueryInvalidException;
import org.odmg.QueryParameterCountInvalidException;
import org.odmg.QueryParameterTypeInvalidException;
import org.odmg.Transaction;

public class OQLQueryImpl
implements EnhancedOQLQuery,
Configurable {
    private Logger log = LoggerFactory.getLogger(class$org$apache$ojb$odmg$oql$OQLQueryImpl == null ? (class$org$apache$ojb$odmg$oql$OQLQueryImpl = OQLQueryImpl.class$("org.apache.ojb.odmg.oql.OQLQueryImpl")) : class$org$apache$ojb$odmg$oql$OQLQueryImpl);
    private Class collectionClass;
    private Query query = null;
    private ListIterator bindIterator = null;
    private PBKey pbKey;
    static /* synthetic */ Class class$org$apache$ojb$odmg$oql$OQLQueryImpl;

    public OQLQueryImpl(PBKey pBKey) {
        this.pbKey = pBKey;
    }

    public Query getQuery() {
        return this.query;
    }

    protected Class getCollectionClass() {
        return this.collectionClass;
    }

    public void bind(Object object) throws QueryParameterCountInvalidException, QueryParameterTypeInvalidException {
        try {
            SelectionCriteria selectionCriteria = (SelectionCriteria)this.getBindIterator().next();
            selectionCriteria.bind(object);
            if (selectionCriteria instanceof BetweenCriteria && !selectionCriteria.isBound()) {
                this.getBindIterator().previous();
            }
        }
        catch (Exception exception) {
            throw new QueryParameterCountInvalidException(exception.getMessage());
        }
    }

    private Vector flatten(Criteria criteria, Vector vector) {
        Enumeration enumeration = criteria.getElements();
        while (enumeration.hasMoreElements()) {
            Serializable serializable;
            Object e = enumeration.nextElement();
            if (e instanceof Criteria) {
                serializable = (Criteria)e;
                this.flatten((Criteria)serializable, vector);
                continue;
            }
            serializable = (SelectionCriteria)e;
            if (((SelectionCriteria)serializable).isBound()) continue;
            vector.add(serializable);
        }
        return vector;
    }

    public void create(String string) throws QueryInvalidException {
        this.create(string, 0, 0);
    }

    public void create(String string, int n, int n2) throws QueryInvalidException {
        if (this.log.isDebugEnabled()) {
            this.log.debug("create query for query-string: " + string);
        }
        if (n2 != 0 && n2 < n) {
            throw new QueryInvalidException("endAtIndex must be greater than startAtIndex");
        }
        if (n2 != 0 && n != 0 && n2 == n) {
            throw new QueryInvalidException("endAtIndex cannot be set equal to startAtIndex");
        }
        try {
            StringReader stringReader = new StringReader(string);
            OQLLexer oQLLexer = new OQLLexer(stringReader);
            OQLParser oQLParser = new OQLParser(oQLLexer);
            Query query = oQLParser.buildQuery();
            this.setBindIterator(this.flatten(query.getCriteria(), new Vector()).listIterator());
            query.setStartAtIndex(n);
            query.setEndAtIndex(n2);
            this.setQuery(query);
        }
        catch (RecognitionException recognitionException) {
            throw new QueryInvalidException(recognitionException.getMessage());
        }
        catch (TokenStreamException tokenStreamException) {
            throw new QueryInvalidException(tokenStreamException.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object execute() throws QueryException {
        if (this.log.isDebugEnabled()) {
            this.log.debug("Start execute query");
        }
        TransactionImpl transactionImpl = TxManagerFactory.instance().getTransaction();
        PBCapsule pBCapsule = null;
        ManageableCollection manageableCollection = null;
        try {
            Iterator iterator;
            pBCapsule = new PBCapsule(this.pbKey, transactionImpl);
            PersistenceBroker persistenceBroker = pBCapsule.getBroker();
            if (!(this.query instanceof ReportQuery)) {
                manageableCollection = persistenceBroker.getCollectionByQuery(this.getCollectionClass(), this.query);
                this.performLockingIfRequired(transactionImpl, persistenceBroker, manageableCollection);
            } else {
                iterator = null;
                manageableCollection = new ManageableArrayList();
                iterator = persistenceBroker.getReportQueryIteratorByQuery(this.query);
                try {
                    block6: while (iterator.hasNext()) {
                        Object[] objectArray = (Object[])iterator.next();
                        if (objectArray.length == 1) {
                            if (objectArray[0] == null) continue;
                            manageableCollection.ojbAdd(objectArray[0]);
                            continue;
                        }
                        for (int i = 0; i < objectArray.length; ++i) {
                            if (objectArray[i] == null) continue;
                            manageableCollection.ojbAdd(objectArray);
                            continue block6;
                        }
                    }
                }
                finally {
                    if (iterator instanceof OJBIterator) {
                        ((OJBIterator)iterator).releaseDbResources();
                    }
                }
            }
            iterator = this.getBindIterator();
            while (iterator.hasPrevious()) {
                iterator.previous();
            }
        }
        finally {
            if (pBCapsule != null) {
                pBCapsule.destroy();
            }
        }
        return manageableCollection;
    }

    protected void performLockingIfRequired(Transaction transaction, PersistenceBroker persistenceBroker, ManageableCollection manageableCollection) {
        OdmgConfiguration odmgConfiguration = this.getConfiguration();
        if (transaction != null && odmgConfiguration.useImplicitLocking()) {
            Iterator iterator = manageableCollection.ojbIterator();
            Object object = null;
            Class<?> clazz = null;
            boolean bl = false;
            while (iterator.hasNext()) {
                object = iterator.next();
                Class<?> clazz2 = object.getClass();
                if (clazz2.equals(clazz) && bl || persistenceBroker.hasClassDescriptor(object.getClass())) {
                    transaction.lock(object, 1);
                    clazz = clazz2;
                    bl = true;
                    continue;
                }
                clazz = clazz2;
                bl = false;
            }
        }
    }

    protected OdmgConfiguration getConfiguration() {
        OdmgConfiguration odmgConfiguration = (OdmgConfiguration)((Object)PersistenceBrokerFactory.getConfigurator().getConfigurationFor(null));
        return odmgConfiguration;
    }

    private void setQuery(Query query) {
        this.query = query;
    }

    protected ListIterator getBindIterator() {
        return this.bindIterator;
    }

    private void setBindIterator(ListIterator listIterator) {
        this.bindIterator = listIterator;
    }

    public void configure(Configuration configuration) throws ConfigurationException {
        this.collectionClass = ((OdmgConfiguration)((Object)configuration)).getOqlCollectionClass();
    }

    public int fullSize() {
        return this.query.fullSize();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

