/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.soda;

import java.util.Collection;
import java.util.Iterator;
import java.util.Vector;
import org.apache.ojb.broker.PersistenceBroker;
import org.apache.ojb.broker.accesslayer.RsIterator;
import org.apache.ojb.broker.query.Query;
import org.odbms.ObjectSet;

public class ObjectSetImpl
implements ObjectSet {
    protected Iterator ojbIterator;
    protected int length;
    protected Vector elements;
    protected int position = 0;
    protected int scrolled = 0;
    protected boolean resultSetClosed;

    public ObjectSetImpl(PersistenceBroker persistenceBroker, Query query, int n) {
        Collection collection = persistenceBroker.getCollectionByQuery(query);
        this.ojbIterator = collection.iterator();
        this.length = collection.size();
        if (n >= 0) {
            this.length = Math.min(this.length, n);
        }
        this.elements = new Vector(this.length);
        this.setResultSetClosed(false);
    }

    public synchronized boolean hasNext() {
        if (this.position < this.length) {
            if (this.position < this.scrolled) {
                return true;
            }
            boolean bl = this.ojbIterator.hasNext();
            return bl;
        }
        this.releaseJdbcResources();
        return false;
    }

    protected void releaseJdbcResources() {
        if (!this.isResultSetClosed()) {
            if (this.ojbIterator instanceof RsIterator) {
                ((RsIterator)this.ojbIterator).releaseDbResources();
            }
            this.setResultSetClosed(true);
        }
    }

    public synchronized Object next() {
        if (this.position < this.scrolled) {
            ++this.position;
            return this.elements.get(this.position - 1);
        }
        Object e = this.ojbIterator.next();
        this.elements.add(e);
        ++this.position;
        ++this.scrolled;
        return e;
    }

    public synchronized void reset() {
        this.position = 0;
    }

    public int size() {
        return this.length;
    }

    public boolean isResultSetClosed() {
        return this.resultSetClosed;
    }

    public void setResultSetClosed(boolean bl) {
        this.resultSetClosed = bl;
    }
}

