/*
 * Decompiled with CFR 0.152.
 */
package org.apache.altrmi.server.impl;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.altrmi.common.ConnectionException;
import org.apache.altrmi.common.Reply;
import org.apache.altrmi.common.Request;
import org.apache.altrmi.common.ThreadPool;
import org.apache.altrmi.common.ThreadPoolAware;
import org.apache.altrmi.server.ServerMonitor;

public abstract class AbstractServerStreamReadWriter
implements ThreadPoolAware {
    private InputStream m_inputStream;
    private OutputStream m_outputStream;
    protected ServerMonitor m_serverMonitor;
    private ThreadPool m_threadPool;
    private Object m_connectionDetails;

    public final void setServerMonitor(ServerMonitor serverMonitor) {
        this.m_serverMonitor = serverMonitor;
    }

    public void setThreadPool(ThreadPool threadPool) {
        this.m_threadPool = threadPool;
    }

    public ThreadPool getThreadPool() {
        return this.m_threadPool;
    }

    public final void setStreams(InputStream inputStream, OutputStream outputStream, Object connectionDetails) {
        this.m_inputStream = inputStream;
        this.m_outputStream = outputStream;
        this.m_connectionDetails = connectionDetails;
    }

    public Object getConnectionDetails() {
        return this.m_connectionDetails;
    }

    protected abstract void initialize() throws IOException;

    protected abstract Request writeReplyAndGetRequest(Reply var1) throws IOException, ConnectionException, ClassNotFoundException;

    protected void close() {
        try {
            this.m_inputStream.close();
        }
        catch (IOException e) {
            this.m_serverMonitor.closeError(this.getClass(), "AbstractServerStreamReadWriter.close(): Failed closing an AltRMI connection input stream: ", e);
        }
        try {
            this.m_outputStream.close();
        }
        catch (IOException e) {
            this.m_serverMonitor.closeError(this.getClass(), "AbstractServerStreamReadWriter.close(): Failed closing an AltRMI connection output stream: ", e);
        }
    }

    protected InputStream getInputStream() {
        return this.m_inputStream;
    }

    protected OutputStream getOutputStream() {
        return this.m_outputStream;
    }
}

