/*
 * Decompiled with CFR 0.152.
 */
package org.apache.altrmi.server.impl.adapters;

import java.rmi.server.UID;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import org.apache.altrmi.common.AuthenticationException;
import org.apache.altrmi.common.ClassReply;
import org.apache.altrmi.common.ClassRequest;
import org.apache.altrmi.common.ClassRetrievalFailedReply;
import org.apache.altrmi.common.ExceptionReply;
import org.apache.altrmi.common.GarbageCollectionReply;
import org.apache.altrmi.common.GarbageCollectionRequest;
import org.apache.altrmi.common.InvocationExceptionReply;
import org.apache.altrmi.common.ListMethodsReply;
import org.apache.altrmi.common.ListMethodsRequest;
import org.apache.altrmi.common.ListReply;
import org.apache.altrmi.common.LookupReply;
import org.apache.altrmi.common.LookupRequest;
import org.apache.altrmi.common.MethodAsyncRequest;
import org.apache.altrmi.common.MethodFacadeArrayReply;
import org.apache.altrmi.common.MethodFacadeReply;
import org.apache.altrmi.common.MethodFacadeRequest;
import org.apache.altrmi.common.MethodNameHelper;
import org.apache.altrmi.common.MethodReply;
import org.apache.altrmi.common.MethodRequest;
import org.apache.altrmi.common.NoSuchSessionReply;
import org.apache.altrmi.common.NotPublishedReply;
import org.apache.altrmi.common.OpenConnectionReply;
import org.apache.altrmi.common.OpenConnectionRequest;
import org.apache.altrmi.common.PingReply;
import org.apache.altrmi.common.RawRequest;
import org.apache.altrmi.common.Reply;
import org.apache.altrmi.common.Request;
import org.apache.altrmi.common.RequestFailedReply;
import org.apache.altrmi.common.SameVMReply;
import org.apache.altrmi.common.SuspendedReply;
import org.apache.altrmi.server.Authenticator;
import org.apache.altrmi.server.ClassRetrievalException;
import org.apache.altrmi.server.ClassRetriever;
import org.apache.altrmi.server.MethodInvocationHandler;
import org.apache.altrmi.server.ServerInvocationHandler;
import org.apache.altrmi.server.impl.DefaultAuthenticator;
import org.apache.altrmi.server.impl.DefaultMethodInvocationHandler;
import org.apache.altrmi.server.impl.Session;
import org.apache.altrmi.server.impl.adapters.PublicationAdapter;
import org.apache.altrmi.server.impl.classretrievers.NoClassRetriever;

public class InvocationHandlerAdapter
extends PublicationAdapter
implements ServerInvocationHandler {
    private static long c_session = 0L;
    private static final UID U_ID = new UID(20729);
    private Long m_lastSession = new Long(0L);
    private HashMap m_sessions = new HashMap();
    private boolean m_suspend = false;
    private ClassRetriever m_classRetriever = new NoClassRetriever();
    private Authenticator m_altrmiAuthenticator = new DefaultAuthenticator();

    public final void setClassRetriever(ClassRetriever classRetriever) {
        this.m_classRetriever = classRetriever;
    }

    public final void setAuthenticator(Authenticator altrmiAuthenticator) {
        this.m_altrmiAuthenticator = altrmiAuthenticator;
    }

    public Reply handleInvocation(Request request, Object connectionDetails) {
        try {
            if (this.m_suspend) {
                return new SuspendedReply();
            }
            if (request.getRequestCode() == 302) {
                return this.doMethodRequest(request, connectionDetails);
            }
            if (request.getRequestCode() == 303) {
                return this.doMethodFacadeRequest(request, connectionDetails);
            }
            if (request.getRequestCode() == 310) {
                return this.doMethodAsyncRequest((MethodAsyncRequest)request, connectionDetails);
            }
            if (request.getRequestCode() == 308) {
                return this.doGarbageCollectionRequest(request);
            }
            if (request.getRequestCode() == 304) {
                return this.doLookupRequest(request);
            }
            if (request.getRequestCode() == 301) {
                return this.doClassRequest(request);
            }
            if (request.getRequestCode() == 305) {
                OpenConnectionRequest openConnectionRequest = (OpenConnectionRequest)request;
                return this.doOpenConnectionRequest(openConnectionRequest.getMachineID());
            }
            if (request.getRequestCode() == 306) {
                return new PingReply();
            }
            if (request.getRequestCode() == 307) {
                return this.doListRequest();
            }
            if (request.getRequestCode() == 309) {
                return this.doListMethodsRequest(request);
            }
            return new RequestFailedReply("Unknown request :" + request.getClass().getName());
        }
        catch (NullPointerException npe) {
            if (request instanceof MethodRequest) {
                throw new NullPointerException("Null pointer exception, processing method" + ((MethodRequest)request).getMethodSignature());
            }
            throw npe;
        }
    }

    private Reply doMethodFacadeRequest(Request request, Object connectionDetails) {
        MethodFacadeRequest facadeRequest = (MethodFacadeRequest)request;
        if (!this.sessionExists(facadeRequest.getSession())) {
            return new NoSuchSessionReply(facadeRequest.getSession());
        }
        String publishedThing = facadeRequest.getPublishedServiceName() + "_" + facadeRequest.getObjectName();
        if (!this.isPublished(publishedThing)) {
            return new NotPublishedReply();
        }
        MethodInvocationHandler methodInvocationHandler = this.getMethodInvocationHandler(publishedThing);
        Reply ar = methodInvocationHandler.handleMethodInvocation((MethodRequest)facadeRequest, connectionDetails);
        if (ar.getReplyCode() == 3) {
            return ar;
        }
        if (ar.getReplyCode() >= 100) {
            return ar;
        }
        if (ar.getReplyCode() == 2) {
            Object methodReply = ((MethodReply)ar).getReplyObject();
            if (methodReply == null) {
                return new MethodFacadeReply(null, null);
            }
            if (!methodReply.getClass().isArray()) {
                return this.doMethodFacadeRequestNonArray(methodReply, facadeRequest);
            }
            return this.doMethodFacadeRequestArray(methodReply, facadeRequest);
        }
        return new RequestFailedReply("TODO");
    }

    private Reply doMethodFacadeRequestArray(Object methodReply, MethodFacadeRequest methodFacadeRequest) {
        Object[] beanImpls = (Object[])methodReply;
        Long[] refs = new Long[beanImpls.length];
        String[] objectNames = new String[beanImpls.length];
        if (!this.sessionExists(methodFacadeRequest.getSession())) {
            return new NoSuchSessionReply(methodFacadeRequest.getSession());
        }
        int i = 0;
        while (i < beanImpls.length) {
            Object impl = beanImpls[i];
            MethodInvocationHandler mainMethodInvocationHandler = this.getMethodInvocationHandler(methodFacadeRequest.getPublishedServiceName() + "_Main");
            objectNames[i] = MethodNameHelper.encodeClassName((String)mainMethodInvocationHandler.getMostDerivedType(beanImpls[i]).getName());
            MethodInvocationHandler methodInvocationHandler2 = this.getMethodInvocationHandler(methodFacadeRequest.getPublishedServiceName() + "_" + objectNames[i]);
            if (methodInvocationHandler2 == null) {
                return new NotPublishedReply();
            }
            if (beanImpls[i] == null) {
                refs[i] = null;
            } else {
                refs[i] = methodInvocationHandler2.getOrMakeReferenceIDForBean(beanImpls[i]);
                Session sess = (Session)this.m_sessions.get(methodFacadeRequest.getSession());
                sess.addBeanInUse(refs[i], beanImpls[i]);
            }
            ++i;
        }
        return new MethodFacadeArrayReply(refs, objectNames);
    }

    private Reply doMethodFacadeRequestNonArray(Object beanImpl, MethodFacadeRequest methodFacadeRequest) {
        if (!this.sessionExists(methodFacadeRequest.getSession())) {
            return new NoSuchSessionReply(methodFacadeRequest.getSession());
        }
        MethodInvocationHandler mainMethodInvocationHandler = this.getMethodInvocationHandler(methodFacadeRequest.getPublishedServiceName() + "_Main");
        String objectName = MethodNameHelper.encodeClassName((String)mainMethodInvocationHandler.getMostDerivedType(beanImpl).getName());
        MethodInvocationHandler methodInvocationHandler = this.getMethodInvocationHandler(methodFacadeRequest.getPublishedServiceName() + "_" + objectName);
        if (methodInvocationHandler == null) {
            return new NotPublishedReply();
        }
        Long newRef = methodInvocationHandler.getOrMakeReferenceIDForBean(beanImpl);
        Session sess = (Session)this.m_sessions.get(methodFacadeRequest.getSession());
        sess.addBeanInUse(newRef, beanImpl);
        return new MethodFacadeReply(newRef, objectName);
    }

    private Reply doMethodRequest(Request request, Object connectionDetails) {
        MethodRequest methodRequest = (MethodRequest)request;
        if (!this.sessionExists(methodRequest.getSession())) {
            return new NoSuchSessionReply(methodRequest.getSession());
        }
        String publishedThing = methodRequest.getPublishedServiceName() + "_" + methodRequest.getObjectName();
        if (!this.isPublished(publishedThing)) {
            return new NotPublishedReply();
        }
        MethodInvocationHandler methodInvocationHandler = this.getMethodInvocationHandler(publishedThing);
        return methodInvocationHandler.handleMethodInvocation(methodRequest, connectionDetails);
    }

    private Reply doMethodAsyncRequest(MethodAsyncRequest methodRequest, Object connectionDetails) {
        if (!this.sessionExists(methodRequest.getSession())) {
            return new NoSuchSessionReply(methodRequest.getSession());
        }
        String publishedThing = methodRequest.getPublishedServiceName() + "_" + methodRequest.getObjectName();
        if (!this.isPublished(publishedThing)) {
            return new NotPublishedReply();
        }
        MethodInvocationHandler methodInvocationHandler = this.getMethodInvocationHandler(publishedThing);
        RawRequest[] requests = methodRequest.getRawRequests();
        int i = 0;
        while (i < requests.length) {
            RawRequest rawRequest = requests[i];
            methodInvocationHandler.handleMethodInvocation(new MethodRequest(methodRequest.getPublishedServiceName(), methodRequest.getObjectName(), rawRequest.getMethodSignature(), rawRequest.getArgs(), methodRequest.getReferenceID(), methodRequest.getSession()), connectionDetails);
            ++i;
        }
        return new MethodReply();
    }

    private Reply doLookupRequest(Request request) {
        LookupRequest lr = (LookupRequest)request;
        try {
            this.m_altrmiAuthenticator.checkAuthority(lr.getAuthentication(), lr.getPublishedServiceName());
        }
        catch (AuthenticationException aae) {
            return new ExceptionReply((Throwable)aae);
        }
        return new LookupReply(new Long(0L));
    }

    private Reply doClassRequest(Request request) {
        ClassRequest cr = (ClassRequest)request;
        String publishedThing = cr.getPublishedServiceName() + "_" + cr.getObjectName();
        try {
            return new ClassReply(this.m_classRetriever.getProxyClassBytes(publishedThing));
        }
        catch (ClassRetrievalException e) {
            return new ClassRetrievalFailedReply(e.getMessage());
        }
    }

    private Reply doOpenConnectionRequest(UID machineID) {
        if (machineID != null && machineID.equals(U_ID)) {
            return new SameVMReply();
        }
        Long session = this.getNewSession();
        this.m_sessions.put(session, new Session(session));
        return new OpenConnectionReply(this.m_altrmiAuthenticator.getTextToSign(), session);
    }

    private Reply doListRequest() {
        Iterator iterator = this.getIteratorOfPublishedObjects();
        Vector<String> vecOfPublishedObjectNames = new Vector<String>();
        while (iterator.hasNext()) {
            String item = (String)iterator.next();
            if (!item.endsWith("_Main")) continue;
            vecOfPublishedObjectNames.add(item.substring(0, item.lastIndexOf("_Main")));
        }
        String[] listOfPublishedObjectNames = new String[vecOfPublishedObjectNames.size()];
        System.arraycopy(vecOfPublishedObjectNames.toArray(), 0, listOfPublishedObjectNames, 0, vecOfPublishedObjectNames.size());
        return new ListReply(listOfPublishedObjectNames);
    }

    private Reply doGarbageCollectionRequest(Request request) {
        GarbageCollectionRequest gcr = (GarbageCollectionRequest)request;
        String publishedThing = gcr.getPublishedServiceName() + "_" + gcr.getObjectName();
        if (!this.isPublished(publishedThing)) {
            return new NotPublishedReply();
        }
        Long session = gcr.getSession();
        if (!this.sessionExists(session)) {
            return new InvocationExceptionReply("TODO - you dirty rat/hacker");
        }
        Session sess = (Session)this.m_sessions.get(session);
        if (sess == null) {
            System.err.println("DEBUG- GC on missing session - " + session);
        } else if (gcr.getReferenceID() == null) {
            System.err.println("DEBUG- GC on missing referenceID -" + gcr.getReferenceID());
        } else {
            sess.removeBeanInUse(gcr.getReferenceID());
        }
        MethodInvocationHandler methodInvocationHandler = this.getMethodInvocationHandler(publishedThing);
        return new GarbageCollectionReply();
    }

    private Reply doListMethodsRequest(Request request) {
        ListMethodsRequest lReq = (ListMethodsRequest)request;
        String publishedThing = lReq.getPublishedName() + "_Main";
        if (!this.isPublished(publishedThing)) {
            return new ListMethodsReply(new String[0]);
        }
        DefaultMethodInvocationHandler methodInvocationHandler = (DefaultMethodInvocationHandler)this.getMethodInvocationHandler(publishedThing);
        return new ListMethodsReply(methodInvocationHandler.getListOfMethods());
    }

    private boolean sessionExists(Long session) {
        if (this.m_lastSession.equals(session)) {
            return true;
        }
        if (this.m_sessions.containsKey(session)) {
            this.m_lastSession = session;
            return true;
        }
        return false;
    }

    private Long getNewSession() {
        return new Long((++c_session << 16) + (long)(Math.random() * 65536.0));
    }

    public void suspend() {
        this.m_suspend = true;
    }

    public void resume() {
        this.m_suspend = false;
    }
}

