/*
 * Decompiled with CFR 0.152.
 */
package org.apache.altrmi.server.impl.classretrievers;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import org.apache.altrmi.server.ClassRetrievalException;
import org.apache.altrmi.server.ClassRetriever;
import org.apache.altrmi.server.ProxyGenerationEnvironmentException;
import org.apache.altrmi.server.ProxyGenerator;
import org.apache.altrmi.server.PublicationDescription;
import org.apache.altrmi.server.PublicationDescriptionItem;
import org.apache.altrmi.server.PublicationException;

public class AbstractDynamicGeneratorClassRetriever
implements ProxyGenerator,
ClassRetriever {
    private String m_altrmiClasspath;
    private String m_classGenDir = ".";
    private String m_srcGenDir;
    private Class m_generatorClass;

    public AbstractDynamicGeneratorClassRetriever(ClassLoader classLoader, String generatorClassName) {
        try {
            this.m_generatorClass = classLoader.loadClass(generatorClassName);
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(generatorClassName);
        }
    }

    public void generate(String asName, Class interfaceToExpose, ClassLoader classLoader) throws PublicationException {
        this.generateProxy(asName, new PublicationDescription(interfaceToExpose), classLoader, false);
    }

    public void generate(String asName, PublicationDescription publicationDescription, ClassLoader classLoader) throws PublicationException {
        this.generateProxy(asName, publicationDescription, classLoader, false);
    }

    public void deferredGenerate(String asName, PublicationDescription publicationDescription, ClassLoader classLoader) throws PublicationException {
        this.generateProxy(asName, publicationDescription, classLoader, true);
    }

    public void setClasspath(String altrmiClasspath) {
        this.m_altrmiClasspath = altrmiClasspath;
    }

    public void addToClasspath(String classpathElement) {
        this.m_altrmiClasspath = this.m_altrmiClasspath + File.pathSeparator + classpathElement;
    }

    public void setClassGenDir(String classGenDir) {
        this.m_classGenDir = classGenDir;
    }

    public final byte[] getProxyClassBytes(String publishedName) throws ClassRetrievalException {
        return this.getThingBytes("AltrmiGenerated" + publishedName);
    }

    protected byte[] getThingBytes(String thingName) throws ClassRetrievalException {
        FileInputStream fis;
        thingName = thingName.replace('.', '\\') + ".class";
        try {
            fis = new FileInputStream(new File(this.m_classGenDir, thingName));
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ClassRetrievalException("Generated class not found in classloader specified : " + e.getMessage());
        }
        if (fis == null) {
            throw new ClassRetrievalException("Generated class not found in classloader specified.");
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        int i = 0;
        try {
            while (-1 != (i = fis.read())) {
                baos.write(i);
            }
            fis.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new ClassRetrievalException("Error retrieving generated class bytes : " + e.getMessage());
        }
        byte[] bytes = baos.toByteArray();
        return bytes;
    }

    public void setSrcGenDir(String srcGenDir) {
        this.m_srcGenDir = srcGenDir;
    }

    /*
     * Unable to fully structure code
     */
    private void generateProxy(String asName, PublicationDescription publicationDescription, ClassLoader classLoader, boolean deferred) throws PublicationException {
        block12: {
            block11: {
                if (classLoader == null) {
                    classLoader = this.getClass().getClassLoader();
                }
                interfacesToExpose = new PublicationDescriptionItem[]{};
                addInfs = new PublicationDescriptionItem[]{};
                interfacesToExpose = publicationDescription.getInterfacesToExpose();
                addInfs = publicationDescription.getAdditionalFacades();
                try {
                    proxyGenerator = (org.apache.altrmi.common.ProxyGenerator)this.m_generatorClass.newInstance();
                }
                catch (InstantiationException e) {
                    throw new RuntimeException("ProxyGenerator cannot be instantiated.");
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException("ProxyGenerator was illegally accessed");
                }
                proxyGenerator.setSrcGenDir(this.m_srcGenDir);
                proxyGenerator.setClassGenDir(this.m_classGenDir);
                proxyGenerator.setGenName(asName);
                proxyGenerator.setClasspath(this.m_altrmiClasspath);
                proxyGenerator.setInterfacesToExpose(interfacesToExpose);
                proxyGenerator.setAdditionalFacades(addInfs);
                try {
                    proxyGenerator.generateSrc(classLoader);
                    break block11;
                }
                catch (Throwable t) {
                    System.err.println("******");
                    System.err.println("** Exception while making source : ");
                    System.err.flush();
                    t.printStackTrace();
                    System.err.println("** Name=" + asName);
                    System.err.println("** Classes/Interfaces to Expose..");
                    i = 0;
                    ** while (i < interfacesToExpose.length)
                }
lbl-1000:
                // 1 sources

                {
                    aString = interfacesToExpose[i].getFacadeClass().getName();
                    System.err.println("** .." + aString);
                    ++i;
                    continue;
                }
lbl36:
                // 1 sources

                System.err.println("******");
                System.err.flush();
            }
            if (deferred) break block12;
            try {
                proxyGenerator.generateClass(classLoader);
                break block12;
            }
            catch (Throwable t) {
                if (t instanceof NoClassDefFoundError && t.getMessage().equals("sun/tools/javac/Main")) {
                    System.err.println("***************************************");
                    System.err.println("*                                     *");
                    System.err.println("* AltRMI problem......                *");
                    System.err.println("* Please copy JAVA_HOME/lib/tools.jar *");
                    System.err.println("* to your applications m_classpath so   *");
                    System.err.println("* that proxys can be compiled.        *");
                    System.err.println("*                                     *");
                    System.err.println("***************************************");
                    throw new ProxyGenerationEnvironmentException("tools.jar not found in m_classpath.");
                }
                System.err.println("******");
                System.err.println("** Exception while making String : ");
                System.err.flush();
                t.printStackTrace();
                System.err.println("** SrcDir=" + this.m_srcGenDir);
                System.err.println("** ClassDir=" + this.m_classGenDir);
                System.err.println("** Name=" + asName);
                System.err.println("** CLasspath=" + this.m_altrmiClasspath);
                System.err.println("** Classes/Interfaces to Expose..");
                i = 0;
                ** while (i < interfacesToExpose.length)
            }
lbl-1000:
            // 1 sources

            {
                aString = interfacesToExpose[i].getFacadeClass().getName();
                System.err.println("** .." + aString);
                ++i;
                continue;
            }
lbl69:
            // 1 sources

            System.err.println("******");
            System.err.flush();
        }
    }

    public void generateDeferred(ClassLoader classLoader) {
        org.apache.altrmi.common.ProxyGenerator proxyGenerator;
        try {
            proxyGenerator = (org.apache.altrmi.common.ProxyGenerator)this.m_generatorClass.newInstance();
        }
        catch (InstantiationException e) {
            throw new RuntimeException("ProxyGenerator cannot be instantiated.");
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("ProxyGenerator was illegally accessed");
        }
        proxyGenerator.generateDeferredClasses();
    }
}

