/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.asm.util;

import java.util.HashMap;
import org.objectweb.asm.Attribute;
import org.objectweb.asm.CodeAdapter;
import org.objectweb.asm.CodeVisitor;
import org.objectweb.asm.Label;
import org.objectweb.asm.Type;

public class CheckCodeAdapter
extends CodeAdapter {
    private boolean end;
    private HashMap labels = new HashMap();
    private static final int[] TYPE = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 7, -1, -1, 2, 2, 2, 2, 2, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 0, 0, 0, 0, 0, 0, 0, 0, 2, 2, 2, 2, 2, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 8, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 2, 9, 10, 0, 0, 0, 0, 0, 0, 4, 4, 4, 4, 5, 5, 5, 5, -1, 3, 1, 3, 0, 0, 3, 3, 0, 0, -1, 11, 6, 6, -1, -1};

    public CheckCodeAdapter(CodeVisitor codeVisitor) {
        super(codeVisitor);
    }

    public void visitInsn(int n) {
        this.checkEnd();
        CheckCodeAdapter.checkOpcode(n, 0);
        this.cv.visitInsn(n);
    }

    public void visitIntInsn(int n, int n2) {
        this.checkEnd();
        CheckCodeAdapter.checkOpcode(n, 1);
        switch (n) {
            case 16: {
                CheckCodeAdapter.checkSignedByte(n2, "Invalid operand");
                break;
            }
            case 17: {
                CheckCodeAdapter.checkSignedShort(n2, "Invalid operand");
                break;
            }
            default: {
                if (n2 >= 4 && n2 <= 11) break;
                throw new IllegalArgumentException("Invalid operand (must be an array type code T_...): " + n2);
            }
        }
        this.cv.visitIntInsn(n, n2);
    }

    public void visitVarInsn(int n, int n2) {
        this.checkEnd();
        CheckCodeAdapter.checkOpcode(n, 2);
        CheckCodeAdapter.checkUnsignedShort(n2, "Invalid variable index");
        this.cv.visitVarInsn(n, n2);
    }

    public void visitTypeInsn(int n, String string) {
        this.checkEnd();
        CheckCodeAdapter.checkOpcode(n, 3);
        if (string != null && string.length() > 0 && string.charAt(0) == '[') {
            CheckCodeAdapter.checkDesc(string, false);
        } else {
            CheckCodeAdapter.checkInternalName(string, "type");
        }
        if (n == 187 && string.charAt(0) == '[') {
            throw new IllegalArgumentException("NEW cannot be used to create arrays: " + string);
        }
        this.cv.visitTypeInsn(n, string);
    }

    public void visitFieldInsn(int n, String string, String string2, String string3) {
        this.checkEnd();
        CheckCodeAdapter.checkOpcode(n, 4);
        CheckCodeAdapter.checkInternalName(string, "owner");
        CheckCodeAdapter.checkIdentifier(string2, "name");
        CheckCodeAdapter.checkDesc(string3, false);
        this.cv.visitFieldInsn(n, string, string2, string3);
    }

    public void visitMethodInsn(int n, String string, String string2, String string3) {
        this.checkEnd();
        CheckCodeAdapter.checkOpcode(n, 5);
        CheckCodeAdapter.checkInternalName(string, "owner");
        CheckCodeAdapter.checkMethodIdentifier(string2, "name");
        CheckCodeAdapter.checkMethodDesc(string3);
        this.cv.visitMethodInsn(n, string, string2, string3);
    }

    public void visitJumpInsn(int n, Label label) {
        this.checkEnd();
        CheckCodeAdapter.checkOpcode(n, 6);
        this.checkLabel(label, false, "label");
        this.cv.visitJumpInsn(n, label);
    }

    public void visitLabel(Label label) {
        this.checkEnd();
        this.checkLabel(label, false, "label");
        if (this.labels.get(label) != null) {
            throw new IllegalArgumentException("Already visited label");
        }
        this.labels.put(label, new Integer(this.labels.size()));
        this.cv.visitLabel(label);
    }

    public void visitLdcInsn(Object object) {
        this.checkEnd();
        if (!(object instanceof Type)) {
            CheckCodeAdapter.checkConstant(object);
        }
        this.cv.visitLdcInsn(object);
    }

    public void visitIincInsn(int n, int n2) {
        this.checkEnd();
        CheckCodeAdapter.checkUnsignedShort(n, "Invalid variable index");
        CheckCodeAdapter.checkSignedShort(n2, "Invalid increment");
        this.cv.visitIincInsn(n, n2);
    }

    public void visitTableSwitchInsn(int n, int n2, Label label, Label[] labelArray) {
        this.checkEnd();
        if (n2 < n) {
            throw new IllegalArgumentException("Max = " + n2 + " must be greater than or equal to min = " + n);
        }
        this.checkLabel(label, false, "default label");
        if (labelArray == null || labelArray.length != n2 - n + 1) {
            throw new IllegalArgumentException("There must be max - min + 1 labels");
        }
        for (int i = 0; i < labelArray.length; ++i) {
            this.checkLabel(labelArray[i], false, "label at index " + i);
        }
        this.cv.visitTableSwitchInsn(n, n2, label, labelArray);
    }

    public void visitLookupSwitchInsn(Label label, int[] nArray, Label[] labelArray) {
        this.checkEnd();
        this.checkLabel(label, false, "default label");
        if (nArray == null || labelArray == null || nArray.length != labelArray.length) {
            throw new IllegalArgumentException("There must be the same number of keys and labels");
        }
        for (int i = 0; i < labelArray.length; ++i) {
            this.checkLabel(labelArray[i], false, "label at index " + i);
        }
        this.cv.visitLookupSwitchInsn(label, nArray, labelArray);
    }

    public void visitMultiANewArrayInsn(String string, int n) {
        this.checkEnd();
        CheckCodeAdapter.checkDesc(string, false);
        if (string.charAt(0) != '[') {
            throw new IllegalArgumentException("Invalid descriptor (must be an array type descriptor): " + string);
        }
        if (n < 1) {
            throw new IllegalArgumentException("Invalid dimensions (must be greater than 0): " + n);
        }
        if (n > string.lastIndexOf(91) + 1) {
            throw new IllegalArgumentException("Invalid dimensions (must not be greater than dims(desc)): " + n);
        }
        this.cv.visitMultiANewArrayInsn(string, n);
    }

    public void visitTryCatchBlock(Label label, Label label2, Label label3, String string) {
        this.checkLabel(label, true, "start label");
        this.checkLabel(label2, true, "end label");
        this.checkLabel(label3, true, "handler label");
        if (string != null) {
            CheckCodeAdapter.checkInternalName(string, "type");
        }
        int n = (Integer)this.labels.get(label);
        int n2 = (Integer)this.labels.get(label2);
        if (n2 <= n) {
            throw new IllegalArgumentException("Invalid start and end labels (end must be greater than start)");
        }
        this.cv.visitTryCatchBlock(label, label2, label3, string);
    }

    public void visitMaxs(int n, int n2) {
        this.checkEnd();
        this.end = true;
        CheckCodeAdapter.checkUnsignedShort(n, "Invalid max stack");
        CheckCodeAdapter.checkUnsignedShort(n2, "Invalid max locals");
        this.cv.visitMaxs(n, n2);
    }

    public void visitLocalVariable(String string, String string2, Label label, Label label2, int n) {
        CheckCodeAdapter.checkIdentifier(string, "name");
        CheckCodeAdapter.checkDesc(string2, false);
        this.checkLabel(label, true, "start label");
        this.checkLabel(label2, true, "end label");
        CheckCodeAdapter.checkUnsignedShort(n, "Invalid variable index");
        int n2 = (Integer)this.labels.get(label);
        int n3 = (Integer)this.labels.get(label2);
        if (n3 <= n2) {
            throw new IllegalArgumentException("Invalid start and end labels (end must be greater than start)");
        }
        this.cv.visitLocalVariable(string, string2, label, label2, n);
    }

    public void visitLineNumber(int n, Label label) {
        CheckCodeAdapter.checkUnsignedShort(n, "Invalid line number");
        this.checkLabel(label, true, "start label");
        this.cv.visitLineNumber(n, label);
    }

    public void visitAttribute(Attribute attribute) {
        if (attribute == null) {
            throw new IllegalArgumentException("Invalid attribute (must not be null)");
        }
    }

    void checkEnd() {
        if (this.end) {
            throw new IllegalStateException("Cannot visit instructions after visitMaxs has been called.");
        }
    }

    static void checkOpcode(int n, int n2) {
        if (n < 0 || n > 199 || TYPE[n] != n2) {
            throw new IllegalArgumentException("Invalid opcode: " + n);
        }
    }

    static void checkSignedByte(int n, String string) {
        if (n < -128 || n > 127) {
            throw new IllegalArgumentException(string + " (must be a signed byte): " + n);
        }
    }

    static void checkSignedShort(int n, String string) {
        if (n < Short.MIN_VALUE || n > Short.MAX_VALUE) {
            throw new IllegalArgumentException(string + " (must be a signed short): " + n);
        }
    }

    static void checkUnsignedShort(int n, String string) {
        if (n < 0 || n > 65535) {
            throw new IllegalArgumentException(string + " (must be an unsigned short): " + n);
        }
    }

    static void checkConstant(Object object) {
        if (!(object instanceof Integer || object instanceof Float || object instanceof Long || object instanceof Double || object instanceof String)) {
            throw new IllegalArgumentException("Invalid constant: " + object);
        }
    }

    static void checkIdentifier(String string, String string2) {
        CheckCodeAdapter.checkIdentifier(string, 0, -1, string2);
    }

    static void checkIdentifier(String string, int n, int n2, String string2) {
        if (string == null || (n2 == -1 ? string.length() <= n : n2 <= n)) {
            throw new IllegalArgumentException("Invalid " + string2 + " (must not be null or empty)");
        }
        if (!Character.isJavaIdentifierStart(string.charAt(n))) {
            throw new IllegalArgumentException("Invalid " + string2 + " (must be a valid Java identifier): " + string);
        }
        int n3 = n2 == -1 ? string.length() : n2;
        for (int i = n + 1; i < n3; ++i) {
            if (Character.isJavaIdentifierPart(string.charAt(i))) continue;
            throw new IllegalArgumentException("Invalid " + string2 + " (must be a valid Java identifier): " + string);
        }
    }

    static void checkMethodIdentifier(String string, String string2) {
        if (string == null || string.length() == 0) {
            throw new IllegalArgumentException("Invalid " + string2 + " (must not be null or empty)");
        }
        if (string.equals("<init>") || string.equals("<clinit>")) {
            return;
        }
        if (!Character.isJavaIdentifierStart(string.charAt(0))) {
            throw new IllegalArgumentException("Invalid " + string2 + " (must be a '<init>', '<clinit>' or a valid Java identifier): " + string);
        }
        for (int i = 1; i < string.length(); ++i) {
            if (Character.isJavaIdentifierPart(string.charAt(i))) continue;
            throw new IllegalArgumentException("Invalid " + string2 + " (must be '<init>' or '<clinit>' or a valid Java identifier): " + string);
        }
    }

    static void checkInternalName(String string, String string2) {
        CheckCodeAdapter.checkInternalName(string, 0, -1, string2);
    }

    static void checkInternalName(String string, int n, int n2, String string2) {
        if (string == null || string.length() == 0) {
            throw new IllegalArgumentException("Invalid " + string2 + " (must not be null or empty)");
        }
        int n3 = n2 == -1 ? string.length() : n2;
        try {
            int n4;
            int n5 = n;
            do {
                if ((n4 = string.indexOf(47, n5 + 1)) == -1 || n4 > n3) {
                    n4 = n3;
                }
                CheckCodeAdapter.checkIdentifier(string, n5, n4, null);
                n5 = n4 + 1;
            } while (n4 != n3);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new IllegalArgumentException("Invalid " + string2 + " (must be a fully qualified class name in internal form): " + string);
        }
    }

    static void checkDesc(String string, boolean bl) {
        int n = CheckCodeAdapter.checkDesc(string, 0, bl);
        if (n != string.length()) {
            throw new IllegalArgumentException("Invalid descriptor: " + string);
        }
    }

    static int checkDesc(String string, int n, boolean bl) {
        if (string == null || n >= string.length()) {
            throw new IllegalArgumentException("Invalid type descriptor (must not be null or empty)");
        }
        switch (string.charAt(n)) {
            case 'V': {
                if (bl) {
                    return n + 1;
                }
                throw new IllegalArgumentException("Invalid descriptor: " + string);
            }
            case 'B': 
            case 'C': 
            case 'D': 
            case 'F': 
            case 'I': 
            case 'J': 
            case 'S': 
            case 'Z': {
                return n + 1;
            }
            case '[': {
                int n2;
                for (n2 = n + 1; n2 < string.length() && string.charAt(n2) == '['; ++n2) {
                }
                if (n2 < string.length()) {
                    return CheckCodeAdapter.checkDesc(string, n2, false);
                }
                throw new IllegalArgumentException("Invalid descriptor: " + string);
            }
            case 'L': {
                int n3 = string.indexOf(59, n);
                if (n3 == -1 || n3 - n < 2) {
                    throw new IllegalArgumentException("Invalid descriptor: " + string);
                }
                try {
                    CheckCodeAdapter.checkInternalName(string, n + 1, n3, null);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw new IllegalArgumentException("Invalid descriptor: " + string);
                }
                return n3 + 1;
            }
        }
        throw new IllegalArgumentException("Invalid descriptor: " + string);
    }

    static void checkMethodDesc(String string) {
        if (string == null || string.length() == 0) {
            throw new IllegalArgumentException("Invalid method descriptor (must not be null or empty)");
        }
        if (string.charAt(0) != '(' || string.length() < 3) {
            throw new IllegalArgumentException("Invalid descriptor: " + string);
        }
        int n = 1;
        if (string.charAt(n) != ')') {
            do {
                if (string.charAt(n) != 'V') continue;
                throw new IllegalArgumentException("Invalid descriptor: " + string);
            } while ((n = CheckCodeAdapter.checkDesc(string, n, false)) < string.length() && string.charAt(n) != ')');
        }
        if ((n = CheckCodeAdapter.checkDesc(string, n + 1, true)) != string.length()) {
            throw new IllegalArgumentException("Invalid descriptor: " + string);
        }
    }

    void checkLabel(Label label, boolean bl, String string) {
        if (label == null) {
            throw new IllegalArgumentException("Invalid " + string + " (must not be null)");
        }
        if (bl && this.labels.get(label) == null) {
            throw new IllegalArgumentException("Invalid " + string + " (must be visited first)");
        }
    }
}

