/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.search;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.avalon.framework.thread.ThreadSafe;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.components.search.LuceneIndexContentHandler;
import org.apache.cocoon.components.search.LuceneXMLIndexer;
import org.apache.commons.lang.StringUtils;
import org.apache.excalibur.xml.sax.SAXParser;
import org.apache.lucene.document.DateField;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class SimpleLuceneXMLIndexerImpl
extends AbstractLogEnabled
implements LuceneXMLIndexer,
Configurable,
Serviceable,
ThreadSafe {
    protected ServiceManager manager = null;
    public static final String CONTENT_VIEW_QUERY_CONFIG = "content-view-query";
    static final String CONTENT_VIEW_QUERY_DEFAULT = "cocoon-view=content";
    public static final String FIELDTAGS_CONFIG = "store-fields";
    final HashSet allowedContentType = new HashSet();
    private String contentViewQuery = "cocoon-view=content";
    private HashSet fieldTags;

    public SimpleLuceneXMLIndexerImpl() {
        this.allowedContentType.add("text/xml");
        this.allowedContentType.add("text/xhtml");
        this.fieldTags = new HashSet();
    }

    public void configure(Configuration configuration) throws ConfigurationException {
        Configuration[] children = configuration.getChildren(FIELDTAGS_CONFIG);
        if (children != null && children.length > 0) {
            this.fieldTags = new HashSet();
            for (int i = 0; i < children.length; ++i) {
                String pattern = children[i].getValue();
                String[] params = StringUtils.split((String)pattern, (String)", ");
                for (int index = 0; index < params.length; ++index) {
                    String tokenized_pattern = params[index];
                    if (tokenized_pattern.equals("")) continue;
                    this.fieldTags.add(tokenized_pattern);
                    if (!this.getLogger().isDebugEnabled()) continue;
                    this.getLogger().debug("add field: " + tokenized_pattern);
                }
            }
        } else if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Do not add any fields");
        }
        this.contentViewQuery = configuration.getChild(CONTENT_VIEW_QUERY_CONFIG, true).getValue(CONTENT_VIEW_QUERY_DEFAULT);
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("content view: " + this.contentViewQuery);
        }
    }

    public void service(ServiceManager manager) throws ServiceException {
        this.manager = manager;
    }

    public List build(URL url) throws ProcessingException {
        try {
            URL contentURL = new URL(url, url.getFile() + (url.getFile().indexOf("?") == -1 ? "?" : "&") + this.contentViewQuery);
            URLConnection contentURLConnection = contentURL.openConnection();
            if (contentURLConnection == null) {
                throw new ProcessingException("Can not open connection to URL " + contentURL + " (null connection)");
            }
            String contentType = contentURLConnection.getContentType();
            if (contentType == null) {
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug("Ignoring " + contentURL + " (no content type)");
                }
                return Collections.EMPTY_LIST;
            }
            int index = contentType.indexOf(59);
            if (index != -1) {
                contentType = contentType.substring(0, index);
            }
            if (this.allowedContentType.contains(contentType)) {
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug("Indexing " + contentURL + " (" + contentType + ")");
                }
                LuceneIndexContentHandler luceneIndexContentHandler = new LuceneIndexContentHandler();
                luceneIndexContentHandler.setFieldTags(this.fieldTags);
                this.indexDocument(contentURLConnection, luceneIndexContentHandler);
                Iterator it = luceneIndexContentHandler.iterator();
                while (it.hasNext()) {
                    Document d = (Document)it.next();
                    d.add(Field.UnIndexed((String)"url", (String)url.toString()));
                    d.add(new Field("uid", this.uid(contentURLConnection), false, true, false));
                }
                return luceneIndexContentHandler.allDocuments();
            }
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("Ignoring " + contentURL + " (" + contentType + ")");
            }
            return Collections.EMPTY_LIST;
        }
        catch (IOException ioe) {
            throw new ProcessingException("Cannot read URL " + url, (Throwable)ioe);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void indexDocument(URLConnection contentURLConnection, LuceneIndexContentHandler luceneIndexContentHandler) throws ProcessingException {
        InputStream is = null;
        InputSource in = null;
        SAXParser parser = null;
        try {
            try {
                is = contentURLConnection.getInputStream();
                in = new InputSource(is);
                parser = (SAXParser)this.manager.lookup(SAXParser.ROLE);
                parser.parse(in, (ContentHandler)luceneIndexContentHandler);
            }
            catch (IOException ioe) {
                throw new ProcessingException("Cannot read!", (Throwable)ioe);
            }
            catch (SAXException saxe) {
                throw new ProcessingException("Cannot parse!", (Throwable)saxe);
            }
            catch (ServiceException se) {
                throw new ProcessingException("Cannot lookup xml parser!", (Throwable)se);
            }
            Object var8_6 = null;
            if (parser == null) return;
        }
        catch (Throwable throwable) {
            Object var8_7 = null;
            if (parser == null) throw throwable;
            this.manager.release(parser);
            throw throwable;
        }
        this.manager.release((Object)parser);
    }

    private String uid(URLConnection urlConnection) {
        return urlConnection.toString().replace('/', '\u0000') + "\u0000" + DateField.timeToString((long)urlConnection.getLastModified());
    }
}

