/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.forms.flow.java;

import java.util.Locale;
import java.util.Map;
import org.apache.avalon.framework.CascadingRuntimeException;
import org.apache.cocoon.components.flow.FlowHelper;
import org.apache.cocoon.components.flow.java.AbstractContinuable;
import org.apache.cocoon.components.flow.java.VarMap;
import org.apache.cocoon.forms.FormContext;
import org.apache.cocoon.forms.FormManager;
import org.apache.cocoon.forms.binding.Binding;
import org.apache.cocoon.forms.binding.BindingManager;
import org.apache.cocoon.forms.formmodel.Form;
import org.apache.cocoon.forms.formmodel.Widget;
import org.apache.excalibur.source.Source;
import org.apache.excalibur.source.SourceResolver;
import org.w3c.dom.Element;

public class FormInstance
extends AbstractContinuable {
    private Form form;
    private Binding binding;
    private Locale locale;
    private boolean isValid;
    private Object validator;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public FormInstance(String uri) {
        FormManager formMgr = null;
        SourceResolver resolver = null;
        Source src = null;
        try {
            try {
                formMgr = (FormManager)this.getComponent(FormManager.ROLE);
                resolver = (SourceResolver)this.getComponent(SourceResolver.ROLE);
                src = resolver.resolveURI(uri);
                this.form = formMgr.createForm(src);
                this.binding = null;
            }
            catch (Exception e) {
                throw new CascadingRuntimeException("Could not create form instance", (Throwable)e);
            }
            Object var7_5 = null;
        }
        catch (Throwable throwable) {
            Object var7_6 = null;
            this.releaseComponent(formMgr);
            if (src != null) {
                resolver.release(src);
            }
            this.releaseComponent(resolver);
            throw throwable;
        }
        this.releaseComponent(formMgr);
        if (src != null) {
            resolver.release(src);
        }
        this.releaseComponent(resolver);
    }

    public FormInstance(String definitionFile, String bindingFile) {
        this(definitionFile);
        this.createBinding(bindingFile);
    }

    public FormInstance(Element formDefinition) {
        FormManager formMgr = null;
        try {
            formMgr = (FormManager)this.getComponent(FormManager.ROLE);
            this.form = formMgr.createForm(formDefinition);
            this.binding = null;
        }
        catch (Exception e) {
            throw new CascadingRuntimeException("Could not create form instance", (Throwable)e);
        }
        finally {
            this.releaseComponent(formMgr);
        }
    }

    public Widget getModel() {
        return this.form;
    }

    public Widget getChild(String name) {
        if (name == null) {
            return this.form;
        }
        return this.form.getChild(name);
    }

    public String getSubmitId() {
        Widget widget = this.form.getSubmitWidget();
        return widget == null ? null : widget.getId();
    }

    public void show(String uri) {
        this.show(uri, new VarMap());
    }

    public void show(String uri, Object bizData) {
        if (bizData == null) {
            bizData = new VarMap();
        }
        ((VarMap)bizData).add("CocoonFormsInstance", this.form);
        if (this.locale == null) {
            this.locale = Locale.getDefault();
        }
        ((VarMap)bizData).add("locale", this.locale);
        boolean finished = false;
        this.isValid = false;
        do {
            this.sendPageAndWait(uri, bizData);
            FormContext formContext = new FormContext(this.getRequest(), this.locale);
            FlowHelper.setContextObject((Map)this.getObjectModel(), (Object)bizData);
            finished = this.form.process(formContext);
            if (!finished) continue;
            this.isValid = this.validator == null ? this.form.isValid() : this.form.isValid();
            finished = this.isValid;
        } while (!finished);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void createBinding(String bindingURI) {
        SourceResolver resolver;
        BindingManager bindingManager;
        block6: {
            bindingManager = null;
            Source source = null;
            resolver = null;
            try {
                try {
                    bindingManager = (BindingManager)this.getComponent(BindingManager.ROLE);
                    resolver = (SourceResolver)this.getComponent(SourceResolver.ROLE);
                    source = resolver.resolveURI(bindingURI);
                    this.binding = bindingManager.createBinding(source);
                }
                catch (Exception e) {
                    throw new CascadingRuntimeException("Could not create bindinh", (Throwable)e);
                }
                Object var7_5 = null;
                if (source == null) break block6;
            }
            catch (Throwable throwable) {
                Object var7_6 = null;
                if (source != null) {
                    resolver.release(source);
                }
                this.releaseComponent(bindingManager);
                this.releaseComponent(resolver);
                throw throwable;
            }
            resolver.release(source);
        }
        this.releaseComponent(bindingManager);
        this.releaseComponent(resolver);
    }

    public void load(Object object) {
        if (this.binding == null) {
            throw new Error("Binding not configured for this form.");
        }
        try {
            this.binding.loadFormFromModel((Widget)this.form, object);
        }
        catch (Exception e) {
            throw new CascadingRuntimeException("Could not load form from model", (Throwable)e);
        }
    }

    public void save(Object object) {
        if (this.binding == null) {
            throw new Error("Binding not configured for this form.");
        }
        try {
            this.binding.saveFormToModel((Widget)this.form, object);
        }
        catch (Exception e) {
            throw new CascadingRuntimeException("Could not save form into model", (Throwable)e);
        }
    }

    public void setAttribute(String name, Object value) {
        this.form.setAttribute(name, value);
    }

    public Object getAttribute(String name) {
        return this.form.getAttribute(name);
    }

    public void removeAttribute(String name) {
        this.form.removeAttribute(name);
    }
}

