/*
 * Decompiled with CFR 0.152.
 */
package org.outerj.daisy.htmlcleaner;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.outerj.daisy.htmlcleaner.ElementDescriptor;
import org.outerj.daisy.htmlcleaner.HtmlCleaner;
import org.outerj.daisy.htmlcleaner.OutputElementDescriptor;
import org.outerj.daisy.htmlcleaner.XhtmlDescriptorBuilder;

public class HtmlCleanerTemplate {
    int maxLineWidth = 80;
    Map outputElementDescriptors = new HashMap();
    Set allowedSpanClasses = new HashSet();
    Set allowedDivClasses = new HashSet();
    Set allowedParaClasses = new HashSet();
    Set allowedPreClasses = new HashSet();
    Map descriptors = new HashMap();
    String imgAlternateSrcAttr;
    private boolean initialised = false;

    HtmlCleanerTemplate() {
    }

    void addOutputElement(String tagName, int beforeOpen, int afterOpen, int beforeClose, int afterClose, boolean inline) {
        if (this.initialised) {
            throw new IllegalStateException();
        }
        if (tagName == null) {
            throw new NullPointerException();
        }
        OutputElementDescriptor descriptor = new OutputElementDescriptor(beforeOpen, afterOpen, beforeClose, afterClose, inline);
        this.outputElementDescriptors.put(tagName, descriptor);
    }

    void setMaxLineWidth(int lineWidth) {
        if (this.initialised) {
            throw new IllegalStateException();
        }
        this.maxLineWidth = lineWidth;
    }

    void addAllowedSpanClass(String clazz) {
        if (this.initialised) {
            throw new IllegalStateException();
        }
        if (clazz == null) {
            throw new NullPointerException();
        }
        this.allowedSpanClasses.add(clazz);
    }

    void addAllowedDivClass(String clazz) {
        if (this.initialised) {
            throw new IllegalStateException();
        }
        if (clazz == null) {
            throw new NullPointerException();
        }
        this.allowedDivClasses.add(clazz);
    }

    void addAllowedParaClass(String clazz) {
        if (this.initialised) {
            throw new IllegalStateException();
        }
        if (clazz == null) {
            throw new NullPointerException();
        }
        this.allowedParaClasses.add(clazz);
    }

    void addAllowedPreClass(String clazz) {
        if (this.initialised) {
            throw new IllegalStateException();
        }
        if (clazz == null) {
            throw new NullPointerException();
        }
        this.allowedPreClasses.add(clazz);
    }

    void addAllowedElement(String tagName, String[] attributes) {
        if (this.initialised) {
            throw new IllegalStateException();
        }
        if (tagName == null) {
            throw new NullPointerException();
        }
        ElementDescriptor descriptor = new ElementDescriptor(tagName);
        for (int i = 0; i < attributes.length; ++i) {
            descriptor.addAttribute(attributes[i]);
        }
        this.descriptors.put(tagName, descriptor);
    }

    void initialize() throws Exception {
        if (this.initialised) {
            throw new IllegalStateException();
        }
        Map full = new XhtmlDescriptorBuilder().build();
        this.relax(full);
        this.narrow(full, this.descriptors);
        this.descriptors = full;
        this.initialised = true;
    }

    private void narrow(Map full, Map subset) {
        String[] fullKeys = full.keySet().toArray(new String[full.size()]);
        for (int i = 0; i < fullKeys.length; ++i) {
            if (subset.containsKey(fullKeys[i])) continue;
            full.remove(fullKeys[i]);
        }
        Iterator descriptorIt = full.values().iterator();
        while (descriptorIt.hasNext()) {
            ElementDescriptor elementDescriptor = (ElementDescriptor)descriptorIt.next();
            String[] childNames = elementDescriptor.getChildren().toArray(new String[0]);
            HashSet<String> newChilds = new HashSet<String>();
            for (int i = 0; i < childNames.length; ++i) {
                if (!subset.containsKey(childNames[i])) continue;
                newChilds.add(childNames[i]);
            }
            elementDescriptor.setChildren(newChilds);
            elementDescriptor.setAttributes(((ElementDescriptor)subset.get(elementDescriptor.getName())).getAttributes());
        }
    }

    private void relax(Map descriptors) {
        ElementDescriptor olDescriptor;
        ElementDescriptor ulDescriptor = (ElementDescriptor)descriptors.get("ul");
        if (ulDescriptor != null) {
            ulDescriptor.getChildren().add("ul");
            ulDescriptor.getChildren().add("ol");
        }
        if ((olDescriptor = (ElementDescriptor)descriptors.get("ol")) != null) {
            olDescriptor.getChildren().add("ul");
            olDescriptor.getChildren().add("ol");
        }
    }

    public HtmlCleaner newHtmlCleaner() {
        return new HtmlCleaner(this);
    }

    void setImgAlternateSrcAttr(String name) {
        this.imgAlternateSrcAttr = name;
    }
}

