/*
 * Decompiled with CFR 0.152.
 */
package org.outerj.daisy.htmlcleaner;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import java.util.StringTokenizer;
import org.outerj.daisy.htmlcleaner.ElementDescriptor;
import org.outerj.daisy.htmlcleaner.HtmlCleanerTemplate;
import org.outerj.daisy.xmlutil.SaxBuffer;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

class HtmlRepairer {
    private HtmlCleanerTemplate template;
    private static Set wipeableInlineElements = new HashSet();
    private static final char[] NEWLINE;
    private static Set contentBlockElements;

    public HtmlRepairer(HtmlCleanerTemplate template) {
        this.template = template;
    }

    public void clean(SaxBuffer buffer, ContentHandler contentHandler) throws SAXException {
        Cleaner cleaner = new Cleaner(buffer, contentHandler);
        cleaner.clean();
    }

    static {
        wipeableInlineElements.add("strong");
        wipeableInlineElements.add("em");
        wipeableInlineElements.add("sub");
        wipeableInlineElements.add("sup");
        wipeableInlineElements.add("a");
        NEWLINE = new char[]{'\n'};
        contentBlockElements = new HashSet();
        contentBlockElements.add("p");
        contentBlockElements.add("h1");
        contentBlockElements.add("h2");
        contentBlockElements.add("h3");
        contentBlockElements.add("h4");
        contentBlockElements.add("h5");
    }

    class IntStack {
        private Stack stack = new Stack();

        IntStack() {
        }

        public void push(int value) {
            this.stack.push(new Integer(value));
        }

        public int pop() {
            return (Integer)this.stack.pop();
        }

        public boolean empty() {
            return this.stack.empty();
        }

        public int peek() {
            return (Integer)this.stack.peek();
        }
    }

    static interface XMLizable {
        public void toSAX(ContentHandler var1) throws SAXException;
    }

    private class Cleaner {
        private ContentHandler finalContentHandler;
        private SaxBuffer input;
        private ContentHandler contentHandler;
        private ArrayList openElements;

        public Cleaner(SaxBuffer input, ContentHandler contentHandler) {
            this.input = input;
            this.finalContentHandler = contentHandler;
        }

        private void clean() throws SAXException {
            this.contentHandler = new SaxBuffer();
            this.openElements = new ArrayList();
            this.elementCleanup(this.input.getBits());
            SaxBuffer elementCleanupOutput = (SaxBuffer)this.contentHandler;
            this.contentHandler = new SaxBuffer();
            this.openElements = new ArrayList();
            this.introduceParas(elementCleanupOutput.getBits());
            SaxBuffer introduceParasOutput = (SaxBuffer)this.contentHandler;
            this.contentHandler = new SaxBuffer();
            this.openElements = new ArrayList();
            this.structuralCleanup(introduceParasOutput.getBits());
            SaxBuffer structuralCleanupOutput = (SaxBuffer)this.contentHandler;
            this.contentHandler = new SaxBuffer();
            this.openElements = new ArrayList();
            this.cleanupBrsAndEmptyContentBlocks(structuralCleanupOutput.getBits());
            SaxBuffer contentBlockCleanupOutput = (SaxBuffer)this.contentHandler;
            this.contentHandler = new SaxBuffer();
            this.openElements = new ArrayList();
            this.cleanupEmptyInlineElements(contentBlockCleanupOutput.getBits());
            SaxBuffer inlineCleanupOutput = (SaxBuffer)this.contentHandler;
            this.contentHandler = new SaxBuffer();
            this.openElements = new ArrayList();
            this.cleanupBrsAndEmptyContentBlocks(inlineCleanupOutput.getBits());
            SaxBuffer secondContentBlockCleanupOutput = (SaxBuffer)this.contentHandler;
            this.contentHandler = this.finalContentHandler;
            this.openElements = new ArrayList();
            this.translateBeeaarsInPees(secondContentBlockCleanupOutput.getBits());
        }

        private void elementCleanup(List bits) throws SAXException {
            Stack<XMLizable> endElements = new Stack<XMLizable>();
            boolean preSupported = ((HtmlRepairer)HtmlRepairer.this).template.descriptors.containsKey("pre");
            for (int i = 0; i < bits.size(); ++i) {
                Object bit = bits.get(i);
                if (bit instanceof SaxBuffer.StartElement) {
                    AttributesImpl attrs;
                    AttributesImpl attrs2;
                    String classAttr;
                    SaxBuffer.StartElement startElement = (SaxBuffer.StartElement)bit;
                    if (!startElement.namespaceURI.equals("")) {
                        endElements.add(new EndElementInfo());
                        continue;
                    }
                    if (startElement.localName.equals("span")) {
                        classAttr = startElement.attrs.getValue("class");
                        if (classAttr != null) {
                            if (((HtmlRepairer)HtmlRepairer.this).template.allowedSpanClasses.contains(classAttr)) {
                                attrs2 = new AttributesImpl();
                                attrs2.addAttribute("", "class", "class", "CDATA", classAttr);
                                this.startElement("span", attrs2);
                                endElements.push(new EndElementInfo("span"));
                                continue;
                            }
                            endElements.push(new EndElementInfo());
                            continue;
                        }
                        String styleAttr = startElement.attrs.getValue("style");
                        if (styleAttr != null) {
                            StringTokenizer styleAttrTokenizer = new StringTokenizer(styleAttr, ";");
                            boolean hasBold = false;
                            boolean hasItalic = false;
                            while (styleAttrTokenizer.hasMoreTokens()) {
                                String styleToken = styleAttrTokenizer.nextToken();
                                int colonPos = styleToken.indexOf(58);
                                if (colonPos == -1) continue;
                                String name = styleToken.substring(0, colonPos).trim().toLowerCase();
                                String value = styleToken.substring(colonPos + 1).trim().toLowerCase();
                                if (name.equals("font-weight") && value.equals("bold")) {
                                    hasBold = true;
                                    continue;
                                }
                                if (!name.equals("font-style") || !value.equals("italic")) continue;
                                hasItalic = true;
                            }
                            MultiEndElementInfo endElement = new MultiEndElementInfo();
                            if (hasBold) {
                                this.startElement("strong", new AttributesImpl());
                                endElement.add(new EndElementInfo("strong"));
                            }
                            if (hasItalic) {
                                this.startElement("em", new AttributesImpl());
                                endElement.add(new EndElementInfo("em"));
                            }
                            endElements.push(endElement);
                            continue;
                        }
                        endElements.push(new EndElementInfo());
                        continue;
                    }
                    if (startElement.localName.equals("div")) {
                        classAttr = startElement.attrs.getValue("class");
                        if (classAttr != null && ((HtmlRepairer)HtmlRepairer.this).template.allowedDivClasses.contains(classAttr)) {
                            attrs2 = new AttributesImpl();
                            attrs2.addAttribute("", "class", "class", "CDATA", classAttr);
                            this.startElement("div", attrs2);
                            endElements.push(new EndElementInfo("div"));
                            continue;
                        }
                        endElements.push(new EndElementInfo());
                        continue;
                    }
                    if (startElement.localName.equals("p")) {
                        classAttr = startElement.attrs.getValue("class");
                        if (classAttr != null && ((HtmlRepairer)HtmlRepairer.this).template.allowedParaClasses.contains(classAttr)) {
                            this.startElement("p", this.getAllowedAttributes(startElement));
                            endElements.push(new EndElementInfo("p"));
                            continue;
                        }
                        attrs2 = this.getAllowedAttributes(startElement);
                        int classPos = attrs2.getIndex("class");
                        if (classPos != -1) {
                            attrs2.removeAttribute(classPos);
                        }
                        this.startElement("p", attrs2);
                        endElements.push(new EndElementInfo("p"));
                        continue;
                    }
                    if (startElement.localName.equals("pre") && preSupported) {
                        classAttr = startElement.attrs.getValue("class");
                        if (classAttr != null && ((HtmlRepairer)HtmlRepairer.this).template.allowedPreClasses.contains(classAttr)) {
                            this.startElement("pre", this.getAllowedAttributes(startElement));
                            endElements.push(new EndElementInfo("pre"));
                            continue;
                        }
                        attrs2 = this.getAllowedAttributes(startElement);
                        int classPos = attrs2.getIndex("class");
                        if (classPos != -1) {
                            attrs2.removeAttribute(classPos);
                        }
                        this.startElement("pre", attrs2);
                        endElements.push(new EndElementInfo("pre"));
                        continue;
                    }
                    if (startElement.localName.equals("b")) {
                        this.startElement("strong", new AttributesImpl());
                        endElements.push(new EndElementInfo("strong"));
                        continue;
                    }
                    if (startElement.localName.equals("i")) {
                        this.startElement("em", new AttributesImpl());
                        endElements.push(new EndElementInfo("em"));
                        continue;
                    }
                    if (startElement.localName.equals("html")) {
                        Object nextBit;
                        if (this.openElements.size() != 0) {
                            throw new SAXException("html element can only appear as root element.");
                        }
                        this.startElement(startElement.localName, startElement.attrs);
                        endElements.push(new EndElementInfo(startElement.localName));
                        do {
                            if (++i < bits.size()) continue;
                            throw new SAXException("Reached end of input without encountering opening body tag.");
                        } while (!((nextBit = bits.get(i)) instanceof SaxBuffer.StartElement) || !((SaxBuffer.StartElement)nextBit).localName.equals("body") || !((SaxBuffer.StartElement)nextBit).namespaceURI.equals(""));
                        --i;
                        continue;
                    }
                    if (startElement.localName.equals("body")) {
                        if (this.openElements.size() != 1) {
                            throw new SAXException("body element can only appear as child of html element");
                        }
                        if (!((StartElementInfo)this.openElements.get(0)).getName().equals("html")) {
                            throw new SAXException("body element can only appear as child of html element");
                        }
                        this.startElement("body", new AttributesImpl());
                        endElements.push(new EndElementInfo("body"));
                        continue;
                    }
                    if (startElement.localName.equals("img") && ((HtmlRepairer)HtmlRepairer.this).template.descriptors.containsKey("img")) {
                        String altSrc;
                        attrs = this.getAllowedAttributes(startElement);
                        if (((HtmlRepairer)HtmlRepairer.this).template.imgAlternateSrcAttr != null && (altSrc = startElement.attrs.getValue(((HtmlRepairer)HtmlRepairer.this).template.imgAlternateSrcAttr)) != null && !altSrc.equals("")) {
                            int hrefIndex = attrs.getIndex("src");
                            if (hrefIndex != -1) {
                                attrs.setValue(hrefIndex, altSrc);
                            } else {
                                attrs.addAttribute("", "src", "src", "CDATA", altSrc);
                            }
                        }
                        this.startElement(startElement.localName, attrs);
                        endElements.push(new EndElementInfo(startElement.localName));
                        continue;
                    }
                    if (startElement.localName.equals("td") || startElement.localName.equals("th")) {
                        String colspan;
                        attrs = this.getAllowedAttributes(startElement);
                        String rowspan = attrs.getValue("rowspan");
                        if (rowspan != null && rowspan.equals("1")) {
                            attrs.removeAttribute(attrs.getIndex("rowspan"));
                        }
                        if ((colspan = attrs.getValue("colspan")) != null && colspan.equals("1")) {
                            attrs.removeAttribute(attrs.getIndex("colspan"));
                        }
                        this.startElement(startElement.localName, attrs);
                        endElements.push(new EndElementInfo(startElement.localName));
                        continue;
                    }
                    if (((HtmlRepairer)HtmlRepairer.this).template.descriptors.containsKey(startElement.localName)) {
                        this.startElement(startElement.localName, this.getAllowedAttributes(startElement));
                        endElements.push(new EndElementInfo(startElement.localName));
                        continue;
                    }
                    endElements.push(new EndElementInfo());
                    continue;
                }
                if (bit instanceof SaxBuffer.EndElement) {
                    XMLizable endElement = (XMLizable)endElements.pop();
                    endElement.toSAX(this.contentHandler);
                    continue;
                }
                if (bit instanceof SaxBuffer.Characters) {
                    ((SaxBuffer.Characters)bit).send(this.contentHandler);
                    continue;
                }
                if (bit instanceof SaxBuffer.StartDocument) {
                    this.contentHandler.startDocument();
                    continue;
                }
                if (!(bit instanceof SaxBuffer.EndDocument)) continue;
                this.contentHandler.endDocument();
                return;
            }
        }

        private AttributesImpl getAllowedAttributes(SaxBuffer.StartElement startElement) {
            String[] allowedAttributes = ((ElementDescriptor)((HtmlRepairer)HtmlRepairer.this).template.descriptors.get(startElement.localName)).getAttributeNames();
            AttributesImpl attrs = new AttributesImpl();
            for (int k = 0; k < allowedAttributes.length; ++k) {
                String value = startElement.attrs.getValue(allowedAttributes[k]);
                if (value == null) continue;
                attrs.addAttribute("", allowedAttributes[k], allowedAttributes[k], "CDATA", value);
            }
            return attrs;
        }

        private void introduceParas(List bits) throws SAXException {
            Stack<EndElementInfo> endElements = new Stack<EndElementInfo>();
            IntStack introducedParas = new IntStack();
            ElementDescriptor bodyDescriptor = (ElementDescriptor)((HtmlRepairer)HtmlRepairer.this).template.descriptors.get("body");
            ElementDescriptor tdDescriptor = (ElementDescriptor)((HtmlRepairer)HtmlRepairer.this).template.descriptors.get("td");
            ElementDescriptor thDescriptor = (ElementDescriptor)((HtmlRepairer)HtmlRepairer.this).template.descriptors.get("th");
            ElementDescriptor paraDescriptor = (ElementDescriptor)((HtmlRepairer)HtmlRepairer.this).template.descriptors.get("p");
            int i = -1;
            while (i < bits.size()) {
                Object bit;
                if ((bit = bits.get(++i)) instanceof SaxBuffer.StartElement) {
                    SaxBuffer.StartElement startElement = (SaxBuffer.StartElement)bit;
                    if (!introducedParas.empty() && introducedParas.peek() == 0 && !paraDescriptor.childAllowed(startElement.localName)) {
                        this.endElement("p");
                        introducedParas.pop();
                    } else if (this.openElements.size() > 1) {
                        boolean startPara;
                        StartElementInfo parentInfo = (StartElementInfo)this.openElements.get(this.openElements.size() - 1);
                        String parentName = parentInfo.getName();
                        boolean bl = startPara = parentName.equals("body") && !bodyDescriptor.childAllowed(startElement.localName) && paraDescriptor.childAllowed(startElement.localName) || parentName.equals("td") && !tdDescriptor.childAllowed(startElement.localName) && paraDescriptor.childAllowed(startElement.localName) || parentName.equals("th") && !thDescriptor.childAllowed(startElement.localName) && paraDescriptor.childAllowed(startElement.localName);
                        if (startPara) {
                            this.startElement("p", new AttributesImpl());
                            introducedParas.push(0);
                        }
                    }
                    if (!introducedParas.empty()) {
                        introducedParas.push(introducedParas.pop() + 1);
                    }
                    this.startElement(startElement.localName, startElement.attrs);
                    endElements.push(new EndElementInfo(startElement.localName));
                    continue;
                }
                if (bit instanceof SaxBuffer.EndElement) {
                    if (!introducedParas.empty() && introducedParas.peek() == 0) {
                        this.endElement("p");
                        introducedParas.pop();
                    }
                    XMLizable endElement = (XMLizable)endElements.pop();
                    endElement.toSAX(this.contentHandler);
                    if (introducedParas.empty()) continue;
                    introducedParas.push(introducedParas.pop() - 1);
                    continue;
                }
                if (bit instanceof SaxBuffer.Characters) {
                    if (this.openElements.size() > 1) {
                        boolean startPara;
                        StartElementInfo parentInfo = (StartElementInfo)this.openElements.get(this.openElements.size() - 1);
                        String parentName = parentInfo.getName();
                        boolean bl = startPara = parentName.equals("body") || parentName.equals("td") || parentName.equals("th");
                        if (startPara) {
                            this.startElement("p", new AttributesImpl());
                            introducedParas.push(0);
                        }
                    }
                    ((SaxBuffer.Characters)bit).send(this.contentHandler);
                    continue;
                }
                if (bit instanceof SaxBuffer.StartDocument) {
                    this.contentHandler.startDocument();
                    continue;
                }
                if (!(bit instanceof SaxBuffer.EndDocument)) continue;
                this.contentHandler.endDocument();
                return;
            }
        }

        private void structuralCleanup(List bits) throws SAXException {
            Stack<XMLizable> endElements = new Stack<XMLizable>();
            int i = -1;
            while (i < bits.size()) {
                Object bit;
                if ((bit = bits.get(++i)) instanceof SaxBuffer.StartElement) {
                    SaxBuffer.StartElement startElement = (SaxBuffer.StartElement)bit;
                    ElementDescriptor descriptor = (ElementDescriptor)((HtmlRepairer)HtmlRepairer.this).template.descriptors.get(startElement.localName);
                    if (descriptor == null) {
                        throw new SAXException("Missing ElementDescriptor for tagname " + startElement.localName);
                    }
                    if (this.openElements.size() > 0) {
                        int k;
                        String parentElementName = ((StartElementInfo)this.openElements.get(this.openElements.size() - 1)).getName();
                        ElementDescriptor parentDescriptor = (ElementDescriptor)((HtmlRepairer)HtmlRepairer.this).template.descriptors.get(parentElementName);
                        boolean allowed = parentDescriptor.childAllowed(startElement.localName);
                        if (allowed) {
                            this.startElement(startElement.localName, startElement.attrs);
                            endElements.push(new EndElementInfo(startElement.localName));
                            continue;
                        }
                        int firstGoodAncestor = -1;
                        for (int k2 = this.openElements.size() - 2; k2 >= 0; --k2) {
                            String ancestorElementName = ((StartElementInfo)this.openElements.get(k2)).getName();
                            ElementDescriptor ancestorDescriptor = (ElementDescriptor)((HtmlRepairer)HtmlRepairer.this).template.descriptors.get(ancestorElementName);
                            if (!ancestorDescriptor.childAllowed(startElement.localName)) continue;
                            firstGoodAncestor = k2;
                            break;
                        }
                        if (firstGoodAncestor == -1) {
                            throw new SAXException("Element \"" + startElement.localName + "\" is disallowed at its current location, and could not automatically fix this.");
                        }
                        MultiEndElementInfo endElementInfo = new MultiEndElementInfo();
                        for (k = this.openElements.size() - 1; k > firstGoodAncestor; --k) {
                            endElementInfo.add((StartElementInfo)this.openElements.get(k));
                        }
                        endElementInfo.add(new EndElementInfo(startElement.localName));
                        for (k = this.openElements.size() - 1; k > firstGoodAncestor; --k) {
                            this.endElement(((StartElementInfo)this.openElements.get(k)).getName());
                        }
                        this.startElement(startElement.localName, startElement.attrs);
                        endElements.push(endElementInfo);
                        continue;
                    }
                    this.startElement(startElement.localName, startElement.attrs);
                    endElements.push(new EndElementInfo(startElement.localName));
                    continue;
                }
                if (bit instanceof SaxBuffer.EndElement) {
                    XMLizable endElement = (XMLizable)endElements.pop();
                    endElement.toSAX(this.contentHandler);
                    continue;
                }
                if (bit instanceof SaxBuffer.Characters) {
                    ((SaxBuffer.Characters)bit).send(this.contentHandler);
                    continue;
                }
                if (bit instanceof SaxBuffer.StartDocument) {
                    this.contentHandler.startDocument();
                    continue;
                }
                if (!(bit instanceof SaxBuffer.EndDocument)) continue;
                this.contentHandler.endDocument();
                return;
            }
        }

        private void cleanupBrsAndEmptyContentBlocks(List bits) throws SAXException {
            Stack<EndElementInfo> endElements = new Stack<EndElementInfo>();
            int i = -1;
            while (i < bits.size()) {
                Object bit;
                if ((bit = bits.get(++i)) instanceof SaxBuffer.StartElement) {
                    int z;
                    SaxBuffer.StartElement startElement = (SaxBuffer.StartElement)bit;
                    boolean contentBlockElement = contentBlockElements.contains(startElement.localName);
                    if (contentBlockElement || startElement.localName.equals("td") || startElement.localName.equals("th")) {
                        Object bit2;
                        int elementNesting = 0;
                        z = i;
                        boolean reachedEndElement = false;
                        while (true) {
                            if ((bit2 = bits.get(++z)) instanceof SaxBuffer.Characters && this.isWhitespace((SaxBuffer.Characters)bit2)) {
                                continue;
                            }
                            if (bit2 instanceof SaxBuffer.StartElement && ((SaxBuffer.StartElement)bit2).localName.equals("br")) {
                                ++elementNesting;
                                continue;
                            }
                            if (!(bit2 instanceof SaxBuffer.EndElement) || !((SaxBuffer.EndElement)bit2).localName.equals("br")) break;
                            --elementNesting;
                        }
                        if (bit2 instanceof SaxBuffer.EndElement && elementNesting == 0) {
                            reachedEndElement = true;
                        }
                        if (reachedEndElement) {
                            if (contentBlockElement) {
                                i = z;
                                continue;
                            }
                            this.startElement(startElement.localName, startElement.attrs);
                            endElements.push(new EndElementInfo(startElement.localName));
                            i = z - 1;
                            continue;
                        }
                        if (contentBlockElement) {
                            i = z - 1;
                        }
                    } else if (startElement.localName.equals("br")) {
                        int firstContentBlockAncestor = -1;
                        for (int k = this.openElements.size() - 1; k >= 0; --k) {
                            StartElementInfo startElementInfo = (StartElementInfo)this.openElements.get(k);
                            if (!contentBlockElements.contains(startElementInfo.getName())) continue;
                            firstContentBlockAncestor = k;
                            break;
                        }
                        if (firstContentBlockAncestor != -1) {
                            z = i;
                            int brCount = 1;
                            boolean continueSearch = true;
                            while (continueSearch) {
                                Object bit2;
                                if ((bit2 = bits.get(++z)) instanceof SaxBuffer.EndElement) {
                                    String name = ((SaxBuffer.EndElement)bit2).localName;
                                    if (name.equals("br")) continue;
                                    continueSearch = false;
                                    continue;
                                }
                                if (bit2 instanceof SaxBuffer.StartElement && ((SaxBuffer.StartElement)bit2).localName.equals("br")) {
                                    ++brCount;
                                    continueSearch = true;
                                    continue;
                                }
                                if (bit2 instanceof SaxBuffer.Characters && this.isWhitespace((SaxBuffer.Characters)bit2)) {
                                    continueSearch = true;
                                    continue;
                                }
                                continueSearch = false;
                            }
                            boolean beforeEndContentBlock = false;
                            for (int t = z; t < bits.size(); ++t) {
                                if (bits.get(t) instanceof SaxBuffer.EndElement) {
                                    SaxBuffer.EndElement endEl = (SaxBuffer.EndElement)bits.get(t);
                                    if (!contentBlockElements.contains(endEl.localName)) continue;
                                    beforeEndContentBlock = true;
                                    break;
                                }
                                if (!(bits.get(t) instanceof SaxBuffer.Characters) || !this.isWhitespace((SaxBuffer.Characters)bits.get(t))) break;
                            }
                            if (beforeEndContentBlock) {
                                i = z - 1;
                                continue;
                            }
                            if (brCount >= 2) {
                                int k;
                                i = z - 1;
                                ArrayList elementsToRestart = new ArrayList();
                                for (k = this.openElements.size() - 1; k >= firstContentBlockAncestor; --k) {
                                    elementsToRestart.add(this.openElements.get(k));
                                }
                                for (k = this.openElements.size() - 1; k >= firstContentBlockAncestor; --k) {
                                    this.endElement(((StartElementInfo)this.openElements.get(k)).getName());
                                }
                                for (k = elementsToRestart.size() - 1; k >= 0; --k) {
                                    StartElementInfo startElementInfo = (StartElementInfo)elementsToRestart.get(k);
                                    this.startElement(startElementInfo.getName(), startElementInfo.getAttrs());
                                }
                                continue;
                            }
                        } else if (startElement.localName.equals("br") && this.openElements.size() > 1 && ((StartElementInfo)this.openElements.get(this.openElements.size() - 1)).getName().equals("td")) {
                            int r;
                            boolean nextIsEndOfCell = false;
                            for (r = i + 1; r < bits.size(); ++r) {
                                Object nextBit = bits.get(r);
                                if (nextBit instanceof SaxBuffer.EndElement) {
                                    SaxBuffer.EndElement endEl = (SaxBuffer.EndElement)nextBit;
                                    if (endEl.localName.equals("br")) continue;
                                    if (!endEl.localName.equals("td")) break;
                                    nextIsEndOfCell = true;
                                    break;
                                }
                                if (!(nextBit instanceof SaxBuffer.Characters) || !this.isWhitespace((SaxBuffer.Characters)nextBit)) break;
                            }
                            if (nextIsEndOfCell) {
                                i = r - 1;
                                continue;
                            }
                        }
                    }
                    this.startElement(startElement.localName, startElement.attrs);
                    endElements.push(new EndElementInfo(startElement.localName));
                    continue;
                }
                if (bit instanceof SaxBuffer.EndElement) {
                    XMLizable endElement = (XMLizable)endElements.pop();
                    endElement.toSAX(this.contentHandler);
                    continue;
                }
                if (bit instanceof SaxBuffer.Characters) {
                    ((SaxBuffer.Characters)bit).send(this.contentHandler);
                    continue;
                }
                if (bit instanceof SaxBuffer.StartDocument) {
                    this.contentHandler.startDocument();
                    continue;
                }
                if (!(bit instanceof SaxBuffer.EndDocument)) continue;
                this.contentHandler.endDocument();
                return;
            }
        }

        private void cleanupEmptyInlineElements(List bits) throws SAXException {
            Stack<EndElementInfo> endElements = new Stack<EndElementInfo>();
            int i = -1;
            while (i < bits.size()) {
                Object bit;
                if ((bit = bits.get(++i)) instanceof SaxBuffer.StartElement) {
                    SaxBuffer.StartElement startElement = (SaxBuffer.StartElement)bit;
                    if (wipeableInlineElements.contains(startElement.localName)) {
                        Object nextBit;
                        boolean hasWhitespace = false;
                        boolean reachedEndElement = false;
                        int elementNesting = 0;
                        int k = i;
                        while (true) {
                            if ((nextBit = bits.get(++k)) instanceof SaxBuffer.StartElement && wipeableInlineElements.contains(((SaxBuffer.StartElement)nextBit).localName)) {
                                ++elementNesting;
                                continue;
                            }
                            if (nextBit instanceof SaxBuffer.Characters && this.isWhitespace((SaxBuffer.Characters)nextBit)) {
                                hasWhitespace = true;
                                continue;
                            }
                            if (!(nextBit instanceof SaxBuffer.EndElement) || elementNesting <= 0) break;
                            --elementNesting;
                        }
                        if (nextBit instanceof SaxBuffer.EndElement && elementNesting == 0) {
                            reachedEndElement = true;
                        }
                        if (reachedEndElement) {
                            i = k;
                            if (!hasWhitespace) continue;
                            this.contentHandler.characters(new char[]{' '}, 0, 1);
                            continue;
                        }
                    }
                    this.startElement(startElement.localName, startElement.attrs);
                    endElements.push(new EndElementInfo(startElement.localName));
                    continue;
                }
                if (bit instanceof SaxBuffer.EndElement) {
                    XMLizable endElement = (XMLizable)endElements.pop();
                    endElement.toSAX(this.contentHandler);
                    continue;
                }
                if (bit instanceof SaxBuffer.Characters) {
                    ((SaxBuffer.Characters)bit).send(this.contentHandler);
                    continue;
                }
                if (bit instanceof SaxBuffer.StartDocument) {
                    this.contentHandler.startDocument();
                    continue;
                }
                if (!(bit instanceof SaxBuffer.EndDocument)) continue;
                this.contentHandler.endDocument();
                return;
            }
        }

        private void translateBeeaarsInPees(List bits) throws SAXException {
            int preLevel = 0;
            int i = -1;
            while (i < bits.size()) {
                Object bit;
                if ((bit = bits.get(++i)) instanceof SaxBuffer.StartElement) {
                    Object nextBit;
                    SaxBuffer.StartElement startElement = (SaxBuffer.StartElement)bit;
                    if (startElement.localName.equals("pre")) {
                        ++preLevel;
                    } else if (preLevel > 0 && startElement.localName.equals("br") && (nextBit = bits.get(i + 1)) instanceof SaxBuffer.EndElement && ((SaxBuffer.EndElement)nextBit).localName.equals("br")) {
                        this.contentHandler.characters(NEWLINE, 0, 1);
                        ++i;
                        continue;
                    }
                    this.startElement(startElement.localName, startElement.attrs);
                    continue;
                }
                if (bit instanceof SaxBuffer.EndElement) {
                    SaxBuffer.EndElement endElement = (SaxBuffer.EndElement)bit;
                    this.contentHandler.endElement(endElement.namespaceURI, endElement.localName, endElement.qName);
                    continue;
                }
                if (bit instanceof SaxBuffer.Characters) {
                    ((SaxBuffer.Characters)bit).send(this.contentHandler);
                    continue;
                }
                if (bit instanceof SaxBuffer.StartDocument) {
                    this.contentHandler.startDocument();
                    continue;
                }
                if (!(bit instanceof SaxBuffer.EndDocument)) continue;
                this.contentHandler.endDocument();
                return;
            }
        }

        private boolean isWhitespace(SaxBuffer.Characters characters) {
            for (int i = 0; i < characters.ch.length; ++i) {
                if (Character.isWhitespace(characters.ch[i]) || characters.ch[i] == '\u00a0') continue;
                return false;
            }
            return true;
        }

        private void startElement(String name, Attributes attrs) throws SAXException {
            this.contentHandler.startElement("", name, name, attrs);
            this.openElements.add(new StartElementInfo(name, attrs));
        }

        private void endElement(String name) throws SAXException {
            this.contentHandler.endElement("", name, name);
            String removed = ((StartElementInfo)this.openElements.remove(this.openElements.size() - 1)).getName();
            if (!removed.equals(name)) {
                throw new SAXException("The close tag \"" + name + "\" did not match the open tag \"" + removed + "\".");
            }
        }

        private final class MultiEndElementInfo
        implements XMLizable {
            private ArrayList tags = new ArrayList(2);

            private MultiEndElementInfo() {
            }

            public void add(EndElementInfo endElement) {
                this.tags.add(endElement);
            }

            public void add(StartElementInfo endElement) {
                this.tags.add(endElement);
            }

            public void toSAX(ContentHandler contentHandler) throws SAXException {
                for (int i = this.tags.size() - 1; i >= 0; --i) {
                    XMLizable tag = (XMLizable)this.tags.get(i);
                    tag.toSAX(contentHandler);
                }
            }
        }

        private class EndElementInfo
        implements XMLizable {
            private final boolean skip;
            private final String localName;

            public EndElementInfo() {
                this.skip = true;
                this.localName = null;
            }

            public EndElementInfo(String localName) {
                this.skip = false;
                this.localName = localName;
            }

            public void toSAX(ContentHandler contentHandler) throws SAXException {
                if (!this.skip) {
                    Cleaner.this.endElement(this.localName);
                }
            }
        }

        private class StartElementInfo
        implements XMLizable {
            private final String name;
            private final Attributes attrs;

            public StartElementInfo(String name, Attributes attrs) {
                this.name = name;
                this.attrs = attrs;
            }

            public String getName() {
                return this.name;
            }

            public Attributes getAttrs() {
                return this.attrs;
            }

            public void toSAX(ContentHandler contentHandler) throws SAXException {
                Cleaner.this.startElement(this.name, this.attrs);
            }
        }
    }
}

