/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xindice.core.indexer;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.WeakHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xindice.Stopwatch;
import org.apache.xindice.core.Collection;
import org.apache.xindice.core.DBException;
import org.apache.xindice.core.data.Key;
import org.apache.xindice.core.data.RecordSet;
import org.apache.xindice.core.indexer.CannotCreateException;
import org.apache.xindice.core.indexer.DuplicateIndexException;
import org.apache.xindice.core.indexer.IndexPattern;
import org.apache.xindice.core.indexer.Indexer;
import org.apache.xindice.util.Configuration;
import org.apache.xindice.util.ConfigurationCallback;
import org.apache.xindice.util.ObjectStack;
import org.apache.xindice.util.SimpleConfigurable;
import org.apache.xindice.util.XindiceException;
import org.apache.xindice.xml.SymbolTable;
import org.apache.xindice.xml.sax.CompressionHandler;
import org.apache.xindice.xml.sax.SAXEventGenerator;
import org.w3c.dom.Document;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;

public final class IndexManager
extends SimpleConfigurable {
    private static final Log log = LogFactory.getLog((Class)(class$org$apache$xindice$core$indexer$IndexManager == null ? (class$org$apache$xindice$core$indexer$IndexManager = IndexManager.class$("org.apache.xindice.core.indexer.IndexManager")) : class$org$apache$xindice$core$indexer$IndexManager));
    private static final String[] EMPTY_STRINGS = new String[0];
    private static final IndexerInfo[] EMPTY_INDEXERS = new IndexerInfo[0];
    private static final String INDEX = "index";
    private static final String NAME = "name";
    private static final String CLASS = "class";
    private static final int STATUS_READY = 0;
    private static final int STATUS_BUSY = 1;
    private static final int ACTION_CREATE = 0;
    private static final int ACTION_UPDATE = 1;
    private static final int ACTION_DELETE = 2;
    private static final Timer timer = new Timer(true);
    private Map patternMap = new HashMap();
    private Map indexes = new HashMap();
    private Map bestIndexers = new HashMap();
    private IndexerInfo[] idxList = EMPTY_INDEXERS;
    private Collection collection;
    private SymbolTable symbols;
    private List newIndexers = new ArrayList();
    static /* synthetic */ Class class$org$apache$xindice$core$indexer$IndexManager;

    public IndexManager(Collection collection) throws DBException {
        this.collection = collection;
        this.symbols = collection.getSymbols();
    }

    public void setConfig(Configuration config) throws XindiceException {
        super.setConfig(config);
        config.processChildren(INDEX, new ConfigurationCallback(){

            public void process(Configuration cfg) {
                block2: {
                    String className = cfg.getAttribute(IndexManager.CLASS);
                    try {
                        IndexManager.this.register(Class.forName(className), cfg);
                    }
                    catch (Exception e) {
                        if (!log.isWarnEnabled()) break block2;
                        log.warn((Object)("Failed to register index with class '" + className + "' for collection '" + IndexManager.this.collection.getCanonicalName() + "'"), (Throwable)e);
                    }
                }
            }
        });
    }

    public synchronized String[] list() {
        return this.indexes.keySet().toArray(EMPTY_STRINGS);
    }

    public synchronized boolean drop(final String name) {
        boolean res;
        block2: {
            Indexer idx = this.get(name);
            this.unregister(name);
            this.config.processChildren(INDEX, new ConfigurationCallback(){

                public void process(Configuration cfg) {
                    block3: {
                        try {
                            if (cfg.getAttribute(IndexManager.NAME).equals(name)) {
                                cfg.delete();
                            }
                        }
                        catch (Exception e) {
                            if (!log.isWarnEnabled()) break block3;
                            log.warn((Object)"ignored exception", (Throwable)e);
                        }
                    }
                }
            });
            res = false;
            try {
                res = idx.drop();
            }
            catch (Exception e) {
                if (!log.isWarnEnabled()) break block2;
                log.warn((Object)"ignored exception", (Throwable)e);
            }
        }
        return res;
    }

    public synchronized void drop() {
        IndexerInfo[] idx = this.idxList;
        int i = 0;
        while (i < idx.length) {
            this.drop(idx[i].name);
            ++i;
        }
    }

    public synchronized Indexer create(Configuration cfg) throws DBException {
        String name = cfg.getAttribute(NAME);
        try {
            Configuration[] cfgs = this.config.getChildren();
            int i = 0;
            while (i < cfgs.length) {
                if (cfgs[i].getAttribute(NAME).equals(name)) {
                    throw new DuplicateIndexException("Duplicate Index '" + name + "' in collection '" + this.collection.getCanonicalName() + "'");
                }
                ++i;
            }
            String className = cfg.getAttribute(CLASS);
            Indexer idx = this.register(Class.forName(className), cfg);
            this.config.add(cfg);
            return idx;
        }
        catch (DBException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CannotCreateException("Cannot create index '" + name + "' in " + this.collection.getCanonicalName(), e);
        }
    }

    public synchronized void close() {
        int i = 0;
        while (i < this.idxList.length) {
            block3: {
                try {
                    this.idxList[i].indexer.close();
                }
                catch (DBException e) {
                    if (!log.isWarnEnabled()) break block3;
                    log.warn((Object)("Failed to close indexer " + this.idxList[i].name + " on collection " + this.collection.getCanonicalName()), (Throwable)e);
                }
            }
            ++i;
        }
    }

    public synchronized Indexer register(Class c, Configuration cfg) throws DBException {
        String name = null;
        try {
            Indexer idx = (Indexer)c.newInstance();
            this.initialize(idx, cfg);
            name = idx.getName();
            if (name == null || name.trim().equals("")) {
                throw new CannotCreateException("No name specified");
            }
            IndexPattern pattern = new IndexPattern(this.symbols, idx.getPattern(), null);
            String style = idx.getIndexStyle();
            IndexerInfo info = new IndexerInfo(name, style, pattern, idx);
            if (!idx.exists()) {
                info.status = 1;
                List list = this.newIndexers;
                synchronized (list) {
                    this.newIndexers.add(info);
                }
                timer.schedule((TimerTask)new PopulateIndexersTimerTask(this), 0L);
            } else {
                info.status = 0;
                idx.open();
            }
            this.indexes.put(name, info);
            this.patternMap.put(pattern, info);
            Map tbl = (Map)this.bestIndexers.get(style);
            if (tbl != null) {
                tbl.clear();
            }
            this.idxList = this.indexes.values().toArray(EMPTY_INDEXERS);
            return idx;
        }
        catch (DBException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CannotCreateException("Cannot create Index '" + name + "' in " + this.collection.getCanonicalName(), e);
        }
    }

    public synchronized void unregister(String name) {
        IndexerInfo idx = (IndexerInfo)this.indexes.remove(name);
        String style = idx.style;
        this.patternMap.remove(idx.pattern);
        Map tbl = (Map)this.bestIndexers.get(style);
        if (tbl != null) {
            tbl.clear();
        }
        this.idxList = this.indexes.values().toArray(EMPTY_INDEXERS);
    }

    private void initialize(Indexer idx, Configuration cfg) throws XindiceException {
        idx.setCollection(this.collection);
        idx.setConfig(cfg);
    }

    private void populateNewIndexers() throws DBException {
        IndexerInfo[] list = null;
        List list2 = this.newIndexers;
        synchronized (list2) {
            list = this.newIndexers.toArray(EMPTY_INDEXERS);
            this.newIndexers.clear();
        }
        if (list.length > 0) {
            if (log.isTraceEnabled()) {
                int i = 0;
                while (i < list.length) {
                    log.trace((Object)("Index Creation: " + list[i].indexer.getName()));
                    ++i;
                }
            }
            Stopwatch sw = new Stopwatch("Populated Indexes", true);
            int i = 0;
            while (i < list.length) {
                block18: {
                    try {
                        if (!list[i].indexer.exists()) {
                            list[i].indexer.create();
                        }
                        list[i].indexer.open();
                    }
                    catch (Exception e) {
                        if (!log.isWarnEnabled()) break block18;
                        log.warn((Object)("Failed to create/open indexer " + list[i]), (Throwable)e);
                    }
                }
                ++i;
            }
            RecordSet rs = this.collection.getFiler().getRecordSet();
            while (rs.hasMoreRecords()) {
                Key key = rs.getNextKey();
                Object value = this.collection.getEntry(key);
                if (!(value instanceof Document)) continue;
                try {
                    new SAXHandler(key, (Document)value, 0, list);
                }
                catch (Exception e) {
                    if (!log.isWarnEnabled()) continue;
                    log.warn((Object)("Failed to index document " + key), (Throwable)e);
                }
            }
            int i2 = 0;
            while (i2 < list.length) {
                block19: {
                    try {
                        list[i2].indexer.flush();
                    }
                    catch (Exception e) {
                        if (!log.isWarnEnabled()) break block19;
                        log.warn((Object)"ignored exception", (Throwable)e);
                    }
                }
                list[i2].status = 0;
                ++i2;
            }
            sw.stop();
            if (log.isDebugEnabled()) {
                int i3 = 0;
                while (i3 < list.length) {
                    log.debug((Object)("Index Complete: " + list[i3].indexer.getName()));
                    ++i3;
                }
                log.debug((Object)sw.toString());
            }
        }
    }

    public synchronized Indexer get(String name) {
        IndexerInfo info = (IndexerInfo)this.indexes.get(name);
        return info != null ? info.indexer : null;
    }

    public Indexer getBestIndexer(String style, IndexPattern pattern) {
        Indexer idx;
        WeakHashMap<IndexPattern, Indexer> tbl = (WeakHashMap<IndexPattern, Indexer>)this.bestIndexers.get(style);
        if (tbl == null) {
            tbl = new WeakHashMap<IndexPattern, Indexer>();
            this.bestIndexers.put(style, tbl);
        }
        if ((idx = (Indexer)tbl.get(pattern)) == null) {
            int highScore = 0;
            Iterator iterator = this.indexes.values().iterator();
            while (iterator.hasNext()) {
                int score;
                IndexerInfo info = (IndexerInfo)iterator.next();
                if (info.status != 0 || !info.indexer.getIndexStyle().equals(style) || (score = pattern.getMatchLevel(info.pattern)) <= highScore) continue;
                idx = info.indexer;
                highScore = score;
            }
            tbl.put(pattern, idx);
        }
        return idx;
    }

    public void addDocument(Key key, Document doc) {
        if (this.idxList.length > 0) {
            new SAXHandler(key, doc, 0);
            int i = 0;
            while (i < this.idxList.length) {
                block4: {
                    try {
                        this.idxList[i].indexer.flush();
                    }
                    catch (Exception e) {
                        if (!log.isWarnEnabled()) break block4;
                        log.warn((Object)"ignored exception", (Throwable)e);
                    }
                }
                ++i;
            }
        }
    }

    public void removeDocument(Key key, Document doc) {
        if (this.idxList.length > 0) {
            new SAXHandler(key, doc, 2);
            int i = 0;
            while (i < this.idxList.length) {
                block4: {
                    try {
                        this.idxList[i].indexer.flush();
                    }
                    catch (Exception e) {
                        if (!log.isWarnEnabled()) break block4;
                        log.warn((Object)"ignored exception", (Throwable)e);
                    }
                }
                ++i;
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class PopulateIndexersTimerTask
    extends TimerTask {
        private IndexManager mgr;

        public PopulateIndexersTimerTask(IndexManager mgr) {
            this.mgr = mgr;
        }

        public void run() {
            block2: {
                try {
                    this.mgr.populateNewIndexers();
                }
                catch (DBException e) {
                    if (!log.isWarnEnabled()) break block2;
                    log.warn((Object)"ignored exception", (Throwable)e);
                }
            }
        }
    }

    private class StackInfo {
        public short symbolID;
        public StringBuffer sb = null;
        public int pos = -1;
        public int len = -1;

        public StackInfo(short symbolID) {
            this.symbolID = symbolID;
        }
    }

    private class SAXHandler
    implements ContentHandler,
    CompressionHandler {
        private ObjectStack stack;
        private IndexerInfo[] list;
        public Key key;
        public Document doc;
        public int action;
        public StackInfo info;

        public SAXHandler(Key key, Document doc, int action, IndexerInfo[] list) {
            block6: {
                this.stack = new ObjectStack();
                this.list = list;
                this.key = key;
                this.doc = doc;
                this.action = action;
                try {
                    SAXEventGenerator events = new SAXEventGenerator(doc);
                    events.setContentHandler(this);
                    events.setProperty("CompressionHandler/1.0", this);
                    events.start();
                    if (action == 0 || action == 1) {
                        try {
                            IndexManager.this.collection.flushSymbolTable();
                        }
                        catch (Exception e) {
                            if (log.isWarnEnabled()) {
                                log.warn((Object)"ignored exception", (Throwable)e);
                            }
                        }
                    }
                }
                catch (Exception e) {
                    if (!log.isWarnEnabled()) break block6;
                    log.warn((Object)"ignored exception", (Throwable)e);
                }
            }
        }

        public SAXHandler(Key key, Document doc, int action) {
            this(key, doc, action, this$0.idxList);
        }

        public void setDocumentLocator(Locator locator) {
        }

        public void startDocument() {
        }

        public void endDocument() {
        }

        public void startPrefixMapping(String prefix, String uri) {
        }

        public void endPrefixMapping(String prefix) {
        }

        public void ignorableWhitespace(char[] ch, int start, int length) {
        }

        public void processingInstruction(String target, String data) {
        }

        public void skippedEntity(String name) {
        }

        public void symbols(SymbolTable symbols) {
        }

        public void dataBytes(byte[] data) {
        }

        public void processEntry(IndexPattern pattern, String value, int pos, int len) {
            int i = 0;
            while (i < this.list.length) {
                block9: {
                    if (pattern.getMatchLevel(this.list[i].pattern) > 0) {
                        try {
                            switch (this.action) {
                                case 0: 
                                case 1: {
                                    this.list[i].indexer.add(value, this.key, pos, len, pattern.getElementID(), pattern.getAttributeID());
                                    break;
                                }
                                case 2: {
                                    this.list[i].indexer.remove(value, this.key, pos, len, pattern.getElementID(), pattern.getAttributeID());
                                    break;
                                }
                                default: {
                                    if (log.isWarnEnabled()) {
                                        log.warn((Object)("invalid action : " + this.action));
                                    }
                                    break;
                                }
                            }
                        }
                        catch (Exception e) {
                            if (!log.isWarnEnabled()) break block9;
                            log.warn((Object)"ignored exception", (Throwable)e);
                        }
                    }
                }
                ++i;
            }
        }

        public void startElement(String namespaceURI, String localName, String qName, Attributes atts) {
            if (namespaceURI != null && namespaceURI.length() > 0) {
                String elemNSID = SymbolTable.getNormalizedLocalName(localName, namespaceURI);
                this.info.symbolID = IndexManager.this.symbols.getSymbol(elemNSID, namespaceURI, true);
            }
            int size = atts.getLength();
            int i = 0;
            while (i < size) {
                String nsURI = atts.getURI(i);
                if (nsURI != null && nsURI.length() > 0) {
                    String attrNSID = "ns" + Integer.toString(nsURI.hashCode()) + ":" + atts.getLocalName(i);
                    short id = IndexManager.this.symbols.getSymbol(attrNSID, nsURI, true);
                    this.processEntry(new IndexPattern(IndexManager.this.symbols, this.info.symbolID, id), atts.getValue(i), this.info.pos, this.info.len);
                } else {
                    short id = IndexManager.this.symbols.getSymbol(atts.getQName(i));
                    this.processEntry(new IndexPattern(IndexManager.this.symbols, this.info.symbolID, id), atts.getValue(i), this.info.pos, this.info.len);
                }
                ++i;
            }
        }

        public void endElement(String namespaceURI, String localName, String qName) {
            if (this.info.sb != null) {
                this.processEntry(new IndexPattern(IndexManager.this.symbols, this.info.symbolID), this.info.sb.toString(), this.info.pos, this.info.len);
            }
            this.info = (StackInfo)this.stack.pop();
        }

        public void characters(char[] ch, int start, int length) {
            String val = new String(ch).trim();
            if (this.info.sb == null) {
                this.info.sb = new StringBuffer(ch.length);
            } else if (this.info.sb.length() > 0) {
                this.info.sb.append(' ');
            }
            this.info.sb.append(val);
        }

        public void symbolID(short symbolID) {
            if (this.info != null) {
                this.stack.push(this.info);
            }
            this.info = new StackInfo(symbolID);
        }

        public void dataLocation(int pos, int len) {
            this.info.pos = pos;
            this.info.len = len;
        }
    }

    private class IndexerInfo {
        public String name;
        public String style;
        public IndexPattern pattern;
        public Indexer indexer;
        public int status;

        public IndexerInfo(String name, String style, IndexPattern pattern, Indexer indexer) {
            this.name = name;
            this.style = style;
            this.pattern = pattern;
            this.indexer = indexer;
        }
    }
}

