/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xindice.core.indexer;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xindice.core.Collection;
import org.apache.xindice.core.DBException;
import org.apache.xindice.core.data.Key;
import org.apache.xindice.core.data.Value;
import org.apache.xindice.core.filer.BTree;
import org.apache.xindice.core.filer.BTreeCallback;
import org.apache.xindice.core.filer.BTreeCorruptException;
import org.apache.xindice.core.filer.BTreeNotFoundException;
import org.apache.xindice.core.filer.Paged;
import org.apache.xindice.core.indexer.IndexMatch;
import org.apache.xindice.core.indexer.IndexPattern;
import org.apache.xindice.core.indexer.IndexQuery;
import org.apache.xindice.core.indexer.Indexer;
import org.apache.xindice.core.query.QueryEngine;
import org.apache.xindice.util.Configuration;
import org.apache.xindice.xml.SymbolTable;

public final class ValueIndexer
extends BTree
implements Indexer {
    private static final Log log = LogFactory.getLog((Class)(class$org$apache$xindice$core$indexer$ValueIndexer == null ? (class$org$apache$xindice$core$indexer$ValueIndexer = ValueIndexer.class$("org.apache.xindice.core.indexer.ValueIndexer")) : class$org$apache$xindice$core$indexer$ValueIndexer));
    private static final IndexMatch[] EmptyMatches = new IndexMatch[0];
    private static final Value EmptyValue = new Value(new byte[0]);
    private static final long MATCH_INFO = -1000L;
    private static final String NAME = "name";
    private static final String PATTERN = "pattern";
    private static final String TYPE = "type";
    private static final int STRING = 0;
    private static final int TRIMMED = 1;
    private static final int INTEGER = 2;
    private static final int FLOAT = 3;
    private static final int BYTE = 4;
    private static final int CHAR = 5;
    private static final int BOOLEAN = 6;
    private static final int[] sizes = new int[]{-1, -1, 8, 8, 1, 2, 1};
    private static final String STRING_VAL = "string";
    private static final String TRIMMED_VAL = "trimmed";
    private static final String SHORT_VAL = "short";
    private static final String INT_VAL = "int";
    private static final String LONG_VAL = "long";
    private static final String FLOAT_VAL = "float";
    private static final String DOUBLE_VAL = "double";
    private static final String BYTE_VAL = "byte";
    private static final String CHAR_VAL = "char";
    private static final String BOOLEAN_VAL = "boolean";
    private Collection collection;
    private SymbolTable symbols;
    private String name;
    private String pattern;
    private int type;
    private int typeSize = 32;
    private boolean wildcard = false;
    static /* synthetic */ Class class$org$apache$xindice$core$indexer$ValueIndexer;

    public Paged.FileHeader createFileHeader() {
        Paged.FileHeader header = super.createFileHeader();
        header.setPageSize(1024);
        return header;
    }

    public void setConfig(Configuration config) {
        block2: {
            super.setConfig(config);
            try {
                this.name = config.getAttribute(NAME);
                this.pattern = config.getAttribute(PATTERN);
                this.wildcard = this.pattern.indexOf(42) != -1;
                String tv = config.getAttribute(TYPE, STRING_VAL).toLowerCase();
                this.type = tv.equals(STRING_VAL) ? 0 : (tv.equals(TRIMMED_VAL) ? 1 : (tv.equals(SHORT_VAL) ? 2 : (tv.equals(INT_VAL) ? 2 : (tv.equals(LONG_VAL) ? 2 : (tv.equals(FLOAT_VAL) ? 3 : (tv.equals(DOUBLE_VAL) ? 3 : (tv.equals(BYTE_VAL) ? 4 : (tv.equals(CHAR_VAL) ? 5 : (tv.equals(BOOLEAN_VAL) ? 6 : (this.pattern.indexOf(64) != -1 ? 0 : 1))))))))));
                this.typeSize = sizes[this.type];
                this.setLocation(this.name);
            }
            catch (Exception e) {
                if (!log.isWarnEnabled()) break block2;
                log.warn((Object)"ignored exception", (Throwable)e);
            }
        }
    }

    public String getName() {
        return this.name;
    }

    public void setLocation(String location) {
        this.setFile(new File(this.collection.getCollectionRoot(), location + ".idx"));
    }

    public void setCollection(Collection collection) {
        block2: {
            try {
                this.collection = collection;
                this.symbols = collection.getSymbols();
            }
            catch (Exception e) {
                if (!log.isWarnEnabled()) break block2;
                log.warn((Object)"ignored exception", (Throwable)e);
            }
        }
    }

    public String getIndexStyle() {
        return "Node:Value";
    }

    public String getPattern() {
        return this.pattern;
    }

    public Value getTypedValue(String value) {
        if (this.type != 0 && this.type != 1) {
            if ((value = value.trim()).length() == 0) {
                return EmptyValue;
            }
            byte[] b = new byte[this.typeSize];
            try {
                switch (this.type) {
                    case 2: {
                        long l = Long.parseLong(value);
                        b[0] = (byte)(l >>> 56 & 0xFFL);
                        b[1] = (byte)(l >>> 48 & 0xFFL);
                        b[2] = (byte)(l >>> 40 & 0xFFL);
                        b[3] = (byte)(l >>> 32 & 0xFFL);
                        b[4] = (byte)(l >>> 24 & 0xFFL);
                        b[5] = (byte)(l >>> 16 & 0xFFL);
                        b[6] = (byte)(l >>> 8 & 0xFFL);
                        b[7] = (byte)(l >>> 0 & 0xFFL);
                        break;
                    }
                    case 3: {
                        double d = Double.parseDouble(value);
                        int i1 = (int)Math.round(d);
                        int i2 = (int)Math.round((d - (double)i1) * 1.0E9);
                        b[0] = (byte)(i1 >>> 24 & 0xFF);
                        b[1] = (byte)(i1 >>> 16 & 0xFF);
                        b[2] = (byte)(i1 >>> 8 & 0xFF);
                        b[3] = (byte)(i1 >>> 0 & 0xFF);
                        b[4] = (byte)(i2 >>> 24 & 0xFF);
                        b[5] = (byte)(i2 >>> 16 & 0xFF);
                        b[6] = (byte)(i2 >>> 8 & 0xFF);
                        b[7] = (byte)(i2 >>> 0 & 0xFF);
                        break;
                    }
                    case 4: {
                        b[0] = Byte.parseByte(value);
                        break;
                    }
                    case 5: {
                        char c = value.charAt(0);
                        b[0] = (byte)(c >>> 8 & 0xFF);
                        b[1] = (byte)(c >>> 0 & 0xFF);
                        break;
                    }
                    case 6: {
                        if ("[true][yes][1][y][on]".indexOf("[" + value.toString().toLowerCase() + "]") != -1) {
                            b[0] = 1;
                            break;
                        }
                        if ("[false][no][0][n][off]".indexOf("[" + value.toString().toLowerCase() + "]") != -1) {
                            b[0] = 0;
                            break;
                        }
                        return EmptyValue;
                    }
                    default: {
                        if (!log.isWarnEnabled()) break;
                        log.warn((Object)("invalid type : " + this.type));
                    }
                }
                return new Value(b);
            }
            catch (Exception e) {
                return EmptyValue;
            }
        }
        if (this.type == 1) {
            value = QueryEngine.normalizeString(value);
        }
        return new Value(value);
    }

    private Value getCombinedValue(Key key, int pos, int len, short elemID, short attrID) {
        Value result;
        try {
            int l = key.getLength();
            byte[] b = new byte[l + 13];
            key.copyTo(b, 0, l);
            b[l] = 0;
            b[l + 1] = (byte)(pos >>> 24 & 0xFF);
            b[l + 2] = (byte)(pos >>> 16 & 0xFF);
            b[l + 3] = (byte)(pos >>> 8 & 0xFF);
            b[l + 4] = (byte)(pos >>> 0 & 0xFF);
            b[l + 5] = (byte)(len >>> 24 & 0xFF);
            b[l + 6] = (byte)(len >>> 16 & 0xFF);
            b[l + 7] = (byte)(len >>> 8 & 0xFF);
            b[l + 8] = (byte)(len >>> 0 & 0xFF);
            b[l + 9] = (byte)(elemID >>> 8 & 0xFF);
            b[l + 10] = (byte)(elemID >>> 0 & 0xFF);
            b[l + 11] = (byte)(attrID >>> 8 & 0xFF);
            b[l + 12] = (byte)(attrID >>> 0 & 0xFF);
            result = new Value(b);
        }
        catch (Exception e) {
            result = null;
        }
        return result;
    }

    private IndexMatch getIndexMatch(Value v) {
        byte[] b = v.getData();
        int l = b.length - 13;
        Key key = new Key(b, 0, b.length - 13);
        int pos = b[l + 1] << 24 | b[l + 2] << 16 | b[l + 3] << 8 | b[l + 4];
        int len = b[l + 5] << 24 | b[l + 6] << 16 | b[l + 7] << 8 | b[l + 8];
        short elemID = (short)(b[l + 9] << 8 | b[l + 10]);
        short attrID = (short)(b[l + 11] << 8 | b[l + 12]);
        return new IndexMatch(key, pos, len, elemID, attrID);
    }

    public void remove(String value, Key key, int pos, int len, short elemID, short attrID) throws DBException {
        block4: {
            Value v = this.getTypedValue(value);
            if (this.type != 0 && this.type != 1 && v.getLength() == 0) {
                return;
            }
            try {
                BTree.BTreeRootInfo root = this.findBTreeRoot(v);
                Value cv = this.getCombinedValue(key, pos, len, elemID, attrID);
                this.removeValue(root, cv);
            }
            catch (DBException e) {
                throw e;
            }
            catch (Exception e) {
                if (!log.isWarnEnabled()) break block4;
                log.warn((Object)"ignored exception", (Throwable)e);
            }
        }
    }

    public void add(String value, Key key, int pos, int len, short elemID, short attrID) throws DBException {
        block7: {
            Value v = this.getTypedValue(value);
            if (this.type != 0 && this.type != 1 && v.getLength() == 0) {
                return;
            }
            try {
                BTree.BTreeRootInfo root;
                try {
                    root = this.findBTreeRoot(v);
                }
                catch (BTreeNotFoundException e) {
                    root = this.createBTreeRoot(v);
                }
                Value cv = this.getCombinedValue(key, pos, len, elemID, attrID);
                this.addValue(root, cv, -1000L);
            }
            catch (DBException e) {
                throw e;
            }
            catch (IOException e) {
                throw new BTreeCorruptException("Corruption detected on add", e);
            }
            catch (Exception e) {
                if (!log.isWarnEnabled()) break block7;
                log.warn((Object)"ignored exception", (Throwable)e);
            }
        }
    }

    public void flush() throws DBException {
        super.flush();
    }

    public IndexMatch[] queryMatches(final IndexQuery query) throws DBException {
        ArrayList results;
        block5: {
            if (this.type != 0) {
                Value[] vals = query.getValues();
                int i = 0;
                while (i < vals.length) {
                    vals[i] = this.getTypedValue(vals[i].toString());
                    ++i;
                }
            }
            results = new ArrayList();
            try {
                this.query(query, new BTreeCallback(){

                    public boolean indexInfo(Value value, long pos) {
                        try {
                            if (pos == -1000L) {
                                IndexMatch match = ValueIndexer.this.getIndexMatch(value);
                                if (!ValueIndexer.this.wildcard) {
                                    results.add(match);
                                } else {
                                    IndexPattern pt = new IndexPattern(ValueIndexer.this.symbols, match.getElement(), match.getAttribute());
                                    if (pt.getMatchLevel(query.getPattern()) > 0) {
                                        results.add(match);
                                    }
                                }
                            } else {
                                BTree.BTreeRootInfo root = (BTree)ValueIndexer.this.new BTree.BTreeRootInfo(value, pos);
                                ValueIndexer.this.query(root, null, this);
                            }
                            return true;
                        }
                        catch (Exception e) {
                            if (log.isWarnEnabled()) {
                                log.warn((Object)"ignored exception", (Throwable)e);
                            }
                            return true;
                        }
                    }
                });
            }
            catch (IOException e) {
                throw new BTreeCorruptException("Corruption detected on query", e);
            }
            catch (Exception e) {
                if (!log.isWarnEnabled()) break block5;
                log.warn((Object)"ignored exception", (Throwable)e);
            }
        }
        return results.toArray(EmptyMatches);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

