/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xindice.util;

import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xindice.util.ConfigurationCallback;
import org.apache.xindice.util.ReadOnlyException;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public final class Configuration {
    private static final Log log = LogFactory.getLog((Class)(class$org$apache$xindice$util$Configuration == null ? (class$org$apache$xindice$util$Configuration = Configuration.class$("org.apache.xindice.util.Configuration")) : class$org$apache$xindice$util$Configuration));
    private static final Configuration[] EMPTY = new Configuration[0];
    private Element config;
    private boolean readOnly;
    private boolean isDirty;
    private Configuration root;
    static /* synthetic */ Class class$org$apache$xindice$util$Configuration;

    public Configuration(Element config, boolean readOnly) {
        this.config = config;
        this.readOnly = readOnly;
    }

    public Configuration(Document config, boolean readOnly) {
        this(config.getDocumentElement(), readOnly);
    }

    public Configuration(Element config) {
        this(config, true);
    }

    public Configuration(Document config) {
        this(config.getDocumentElement());
    }

    private Configuration(Configuration root, Element config, boolean readOnly) {
        this.root = root;
        this.config = config;
        this.readOnly = readOnly;
    }

    private void setDirty() {
        if (this.root != null) {
            this.root.setDirty();
        } else {
            this.isDirty = true;
        }
    }

    public void resetDirty() {
        this.isDirty = false;
    }

    public boolean isDirty() {
        if (this.root != null) {
            return this.root.isDirty();
        }
        return this.isDirty;
    }

    public Element getElement() throws ReadOnlyException {
        if (this.readOnly) {
            throw new ReadOnlyException();
        }
        return this.config;
    }

    public String getName() {
        return this.config.getNodeName();
    }

    public boolean hasAttributes() {
        return this.config.getAttributes().getLength() > 0;
    }

    public String getAttribute(String name, String defValue) {
        String value = this.config.getAttribute(name);
        if (value == null || value.length() == 0) {
            value = defValue;
        }
        return value;
    }

    public String getAttribute(String name) {
        return this.getAttribute(name, "");
    }

    public boolean getBooleanAttribute(String name, boolean defValue) {
        try {
            String attr = this.getAttribute(name, defValue ? "1" : "0").toLowerCase();
            return "[true][yes][1][y][on]".indexOf("[" + attr + "]") != -1;
        }
        catch (Exception e) {
            return defValue;
        }
    }

    public boolean getBooleanAttribute(String name) {
        return this.getBooleanAttribute(name, false);
    }

    public int getIntAttribute(String name, int defValue) {
        try {
            return Integer.parseInt(this.config.getAttribute(name));
        }
        catch (Exception e) {
            return defValue;
        }
    }

    public int getIntAttribute(String name) {
        return this.getIntAttribute(name, 0);
    }

    public short getShortAttribute(String name, short defValue) {
        try {
            return Short.parseShort(this.config.getAttribute(name));
        }
        catch (Exception e) {
            return defValue;
        }
    }

    public short getShortAttribute(String name) {
        return this.getShortAttribute(name, (short)0);
    }

    public long getLongAttribute(String name, long defValue) {
        try {
            return Long.parseLong(this.config.getAttribute(name));
        }
        catch (Exception e) {
            return defValue;
        }
    }

    public long getLongAttribute(String name) {
        return this.getLongAttribute(name, 0L);
    }

    public float getFloatAttribute(String name, float defValue) {
        try {
            return Float.parseFloat(this.config.getAttribute(name));
        }
        catch (Exception e) {
            return defValue;
        }
    }

    public float getFloatAttribute(String name) {
        return this.getFloatAttribute(name, 0.0f);
    }

    public double getDoubleAttribute(String name, double defValue) {
        try {
            return Double.parseDouble(this.config.getAttribute(name));
        }
        catch (Exception e) {
            return defValue;
        }
    }

    public double getDoubleAttribute(String name) {
        return this.getDoubleAttribute(name, 0.0);
    }

    public byte getByteAttribute(String name, byte defValue) {
        try {
            return Byte.parseByte(this.config.getAttribute(name));
        }
        catch (Exception e) {
            return defValue;
        }
    }

    public byte getByteAttribute(String name) {
        return this.getByteAttribute(name, (byte)0);
    }

    public char getCharAttribute(String name, char defValue) {
        try {
            return this.config.getAttribute(name).charAt(0);
        }
        catch (Exception e) {
            return defValue;
        }
    }

    public char getCharAttribute(String name) {
        return this.getCharAttribute(name, '\u0000');
    }

    public String[] listAttributes() {
        NamedNodeMap map = this.config.getAttributes();
        String[] result = new String[map.getLength()];
        int size = map.getLength();
        int i = 0;
        while (i < size) {
            result[i] = ((Attr)map.item(i)).getName();
            ++i;
        }
        return result;
    }

    public boolean hasValue() {
        NodeList list = this.config.getChildNodes();
        return list.getLength() > 0 && list.item(0).getNodeType() == 3;
    }

    public String getValue(String defValue) {
        NodeList list = this.config.getChildNodes();
        if (list.getLength() == 1 && list.item(0).getNodeType() == 3) {
            return list.item(0).getNodeValue();
        }
        return defValue;
    }

    public String getValue() {
        return this.getValue("");
    }

    public boolean getBooleanValue(boolean defValue) {
        try {
            return "[true][yes][1][y][on]".indexOf("[" + this.getValue().toLowerCase() + "]") != -1;
        }
        catch (Exception e) {
            return defValue;
        }
    }

    public boolean getBooleanValue() {
        return this.getBooleanValue(false);
    }

    public int getIntValue(int defValue) {
        try {
            return Integer.parseInt(this.getValue());
        }
        catch (Exception e) {
            return defValue;
        }
    }

    public int getIntValue() {
        return this.getIntValue(0);
    }

    public short getShortValue(short defValue) {
        try {
            return Short.parseShort(this.getValue());
        }
        catch (Exception e) {
            return defValue;
        }
    }

    public short getShortValue() {
        return this.getShortValue((short)0);
    }

    public long getLongValue(long defValue) {
        try {
            return Long.parseLong(this.getValue());
        }
        catch (Exception e) {
            return defValue;
        }
    }

    public long getLongValue() {
        return this.getLongValue(0L);
    }

    public float getFloatValue(float defValue) {
        try {
            return Float.parseFloat(this.getValue());
        }
        catch (Exception e) {
            return defValue;
        }
    }

    public float getFloatValue() {
        return this.getFloatValue(0.0f);
    }

    public double getDoubleValue(double defValue) {
        try {
            return Double.parseDouble(this.getValue());
        }
        catch (Exception e) {
            return defValue;
        }
    }

    public double getDoubleValue() {
        return this.getDoubleValue(0.0);
    }

    public byte getByteValue(byte defValue) {
        try {
            return Byte.parseByte(this.getValue());
        }
        catch (Exception e) {
            return defValue;
        }
    }

    public byte getByteValue() {
        return this.getByteValue((byte)0);
    }

    public char getCharValue(char defValue) {
        try {
            return this.getValue().charAt(0);
        }
        catch (Exception e) {
            return defValue;
        }
    }

    public char getCharValue() {
        return this.getCharValue('\u0000');
    }

    public boolean hasChildren() {
        NodeList list = this.config.getChildNodes();
        int size = list.getLength();
        int i = 0;
        while (i < size) {
            if (list.item(i).getNodeType() == 1) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public Configuration[] getChildren() {
        NodeList list = this.config.getChildNodes();
        int size = list.getLength();
        ArrayList<Configuration> children = new ArrayList<Configuration>();
        int i = 0;
        while (i < size) {
            if (list.item(i).getNodeType() == 1) {
                children.add(new Configuration(this, (Element)list.item(i), this.readOnly));
            }
            ++i;
        }
        return children.toArray(EMPTY);
    }

    public void processChildren(ConfigurationCallback callback) {
        block4: {
            NodeList list = this.config.getChildNodes();
            int size = list.getLength();
            try {
                int i = 0;
                while (i < size) {
                    if (list.item(i).getNodeType() == 1) {
                        callback.process(new Configuration(this, (Element)list.item(i), this.readOnly));
                    }
                    ++i;
                }
            }
            catch (Exception e) {
                if (!log.isWarnEnabled()) break block4;
                log.warn((Object)"ignored exception", (Throwable)e);
            }
        }
    }

    public void processChildren(String name, ConfigurationCallback callback) {
        block5: {
            NodeList list = this.config.getChildNodes();
            Node[] nl = new Node[list.getLength()];
            int i = 0;
            while (i < nl.length) {
                nl[i] = list.item(i);
                ++i;
            }
            int size = nl.length;
            try {
                int i2 = 0;
                while (i2 < size) {
                    if (nl[i2].getNodeType() == 1 && nl[i2].getNodeName().equals(name)) {
                        callback.process(new Configuration(this, (Element)nl[i2], this.readOnly));
                    }
                    ++i2;
                }
            }
            catch (Exception e) {
                if (!log.isWarnEnabled()) break block5;
                log.warn((Object)"ignored exception", (Throwable)e);
            }
        }
    }

    public Configuration[] getChildren(String name) {
        NodeList list = this.config.getChildNodes();
        int size = list.getLength();
        ArrayList<Configuration> children = new ArrayList<Configuration>();
        int i = 0;
        while (i < size) {
            if (list.item(i).getNodeType() == 1 && list.item(i).getNodeName().equals(name)) {
                children.add(new Configuration(this, (Element)list.item(i), this.readOnly));
            }
            ++i;
        }
        return children.toArray(EMPTY);
    }

    public Configuration getChild(String name, boolean create) throws ReadOnlyException {
        NodeList list = this.config.getChildNodes();
        int size = list.getLength();
        int i = 0;
        while (i < size) {
            if (list.item(i).getNodeType() == 1 && list.item(i).getNodeName().equals(name)) {
                return new Configuration(this, (Element)list.item(i), this.readOnly);
            }
            ++i;
        }
        return create ? this.add(name) : null;
    }

    public Configuration getChild(String name) {
        try {
            return this.getChild(name, false);
        }
        catch (Exception e) {
            return null;
        }
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public Configuration add(String name) throws ReadOnlyException {
        if (this.readOnly) {
            throw new ReadOnlyException();
        }
        Element elem = this.config.getOwnerDocument().createElement(name);
        this.config.appendChild(elem);
        this.setDirty();
        return new Configuration(this, elem, this.readOnly);
    }

    public void add(Configuration newConfig) throws ReadOnlyException {
        if (this.readOnly) {
            throw new ReadOnlyException();
        }
        Node imported = this.config.getOwnerDocument().importNode(newConfig.config, true);
        this.config.appendChild(imported);
        newConfig.config = (Element)imported;
        this.setDirty();
    }

    public void delete() throws ReadOnlyException {
        if (this.readOnly) {
            throw new ReadOnlyException();
        }
        if (this.config.getParentNode() != null) {
            this.config.getParentNode().removeChild(this.config);
        }
        this.setDirty();
    }

    public void removeAttribute(String name) throws ReadOnlyException {
        if (this.readOnly) {
            throw new ReadOnlyException();
        }
        this.config.removeAttribute(name);
        this.setDirty();
    }

    public void setAttribute(String name, String value) throws ReadOnlyException {
        if (this.readOnly) {
            throw new ReadOnlyException();
        }
        this.config.setAttribute(name, value);
        this.setDirty();
    }

    public void setAttribute(String name, boolean value) throws ReadOnlyException {
        this.setAttribute(name, String.valueOf(value));
    }

    public void setAttribute(String name, int value) throws ReadOnlyException {
        this.setAttribute(name, String.valueOf(value));
    }

    public void setAttribute(String name, short value) throws ReadOnlyException {
        this.setAttribute(name, String.valueOf(value));
    }

    public void setAttribute(String name, long value) throws ReadOnlyException {
        this.setAttribute(name, String.valueOf(value));
    }

    public void setAttribute(String name, float value) throws ReadOnlyException {
        this.setAttribute(name, String.valueOf(value));
    }

    public void setAttribute(String name, double value) throws ReadOnlyException {
        this.setAttribute(name, String.valueOf(value));
    }

    public void setAttribute(String name, byte value) throws ReadOnlyException {
        this.setAttribute(name, String.valueOf(value));
    }

    public void setAttribute(String name, char value) throws ReadOnlyException {
        this.setAttribute(name, String.valueOf(value));
    }

    public void setValue(String value) throws ReadOnlyException {
        if (this.readOnly) {
            throw new ReadOnlyException();
        }
        NodeList list = this.config.getChildNodes();
        if (list.getLength() == 1 && list.item(0).getNodeType() == 3) {
            list.item(0).setNodeValue(value);
        } else {
            Text text = this.config.getOwnerDocument().createTextNode(value);
            this.config.appendChild(text);
        }
        this.setDirty();
    }

    public void setValue(boolean value) throws ReadOnlyException {
        this.setValue(String.valueOf(value));
    }

    public void setValue(int value) throws ReadOnlyException {
        this.setValue(String.valueOf(value));
    }

    public void setValue(short value) throws ReadOnlyException {
        this.setValue(String.valueOf(value));
    }

    public void setValue(long value) throws ReadOnlyException {
        this.setValue(String.valueOf(value));
    }

    public void setValue(float value) throws ReadOnlyException {
        this.setValue(String.valueOf(value));
    }

    public void setValue(double value) throws ReadOnlyException {
        this.setValue(String.valueOf(value));
    }

    public void setValue(byte value) throws ReadOnlyException {
        this.setValue(String.valueOf(value));
    }

    public void setValue(char value) throws ReadOnlyException {
        this.setValue(String.valueOf(value));
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

