/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xindice.xml;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ProcessingInstruction;

public final class TextWriter {
    private static final Log log = LogFactory.getLog((Class)(class$org$apache$xindice$xml$TextWriter == null ? (class$org$apache$xindice$xml$TextWriter = TextWriter.class$("org.apache.xindice.xml.TextWriter")) : class$org$apache$xindice$xml$TextWriter));
    private Node node = null;
    static /* synthetic */ Class class$org$apache$xindice$xml$TextWriter;

    public TextWriter(Node node) {
        this.node = node;
    }

    public void write(Writer writer) throws IOException {
        TextWriter.write(this.node, writer);
    }

    public void write(OutputStream output) throws IOException {
        TextWriter.write(this.node, output);
    }

    public String toString() {
        return TextWriter.toString(this.node);
    }

    private static void writeNode(Writer writer, Node node) throws IOException {
        short type = node.getNodeType();
        switch (type) {
            case 9: {
                writer.write("<?xml version=\"1.0\"?>\n");
                TextWriter.writeChildren(writer, node);
                break;
            }
            case 11: {
                TextWriter.writeChildren(writer, node);
                break;
            }
            case 10: {
                if (!log.isErrorEnabled()) break;
                log.error((Object)"can't serialize doctype yet");
                break;
            }
            case 1: {
                Element e = (Element)node;
                String n = e.getTagName();
                writer.write(60);
                writer.write(n);
                NamedNodeMap a = e.getAttributes();
                int size = a.getLength();
                int i = 0;
                while (i < size) {
                    Attr att = (Attr)a.item(i);
                    writer.write(32);
                    TextWriter.writeNode(writer, att);
                    ++i;
                }
                if (e.hasChildNodes()) {
                    writer.write(62);
                    TextWriter.writeChildren(writer, node);
                    writer.write("</");
                    writer.write(n);
                    writer.write(62);
                    break;
                }
                writer.write(" />");
                break;
            }
            case 2: {
                Attr att = (Attr)node;
                writer.write(att.getName());
                writer.write("=\"");
                TextWriter.writeEscapedText(writer, att.getValue());
                writer.write("\"");
                break;
            }
            case 5: {
                if (!log.isErrorEnabled()) break;
                log.error((Object)"can't serialize reference ref yet");
                break;
            }
            case 6: {
                if (!log.isErrorEnabled()) break;
                log.error((Object)"can't serialize entity yet");
                break;
            }
            case 12: {
                if (!log.isErrorEnabled()) break;
                log.error((Object)"can't serialize notation yet");
                break;
            }
            case 7: {
                ProcessingInstruction pi = (ProcessingInstruction)node;
                writer.write("<?");
                writer.write(pi.getTarget());
                writer.write(" ");
                writer.write(pi.getData());
                writer.write("?>\n");
                break;
            }
            case 3: {
                TextWriter.writeEscapedText(writer, node.getNodeValue());
                break;
            }
            case 4: {
                writer.write("<![CDATA[");
                writer.write(node.getNodeValue());
                writer.write("]]>");
                break;
            }
            case 8: {
                writer.write("<!--");
                writer.write(node.getNodeValue());
                writer.write("-->");
                break;
            }
            default: {
                if (!log.isWarnEnabled()) break;
                log.warn((Object)("invalid node type : " + node));
            }
        }
    }

    private static void writeChildren(Writer writer, Node node) throws IOException {
        NodeList l = node.getChildNodes();
        int size = l.getLength();
        int i = 0;
        while (i < size) {
            TextWriter.writeNode(writer, l.item(i));
            ++i;
        }
    }

    private static void writeEscapedText(Writer writer, String text) throws IOException {
        char[] value = text.toCharArray();
        int start = 0;
        int len = 0;
        int i = 0;
        while (i < value.length) {
            String outval = null;
            switch (value[i]) {
                case '&': {
                    outval = "&amp;";
                    break;
                }
                case '\'': {
                    outval = "&apos;";
                    break;
                }
                case '\"': {
                    outval = "&quot;";
                    break;
                }
                case '<': {
                    outval = "&lt;";
                    break;
                }
                case '>': {
                    outval = "&gt;";
                    break;
                }
                default: {
                    ++len;
                }
            }
            if (outval != null) {
                if (len > 0) {
                    writer.write(value, start, len);
                }
                writer.write(outval);
                start = i + 1;
                len = 0;
            }
            ++i;
        }
        if (len > 0) {
            writer.write(value, start, len);
        }
    }

    public static void write(Node node, Writer writer) throws IOException {
        BufferedWriter buf = new BufferedWriter(writer, 4096);
        TextWriter.writeNode(buf, node);
        buf.flush();
    }

    public static void write(Node node, OutputStream output) throws IOException {
        OutputStreamWriter o = new OutputStreamWriter(output, "utf-8");
        TextWriter.write(node, o);
    }

    public static String toString(Node node) {
        StringWriter sw = new StringWriter();
        try {
            TextWriter.write(node, sw);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return sw.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

