/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xindice.xml.dom;

import java.io.IOException;
import java.util.AbstractCollection;
import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xindice.util.ByteArrayInput;
import org.apache.xindice.xml.SymbolTable;
import org.apache.xindice.xml.XMLCompressedInput;
import org.apache.xindice.xml.dom.CDATASectionImpl;
import org.apache.xindice.xml.dom.CommentImpl;
import org.apache.xindice.xml.dom.DocumentImpl;
import org.apache.xindice.xml.dom.ElementImpl;
import org.apache.xindice.xml.dom.EntityImpl;
import org.apache.xindice.xml.dom.EntityReferenceImpl;
import org.apache.xindice.xml.dom.NodeImpl;
import org.apache.xindice.xml.dom.NodeListImpl;
import org.apache.xindice.xml.dom.NotationImpl;
import org.apache.xindice.xml.dom.ProcessingInstructionImpl;
import org.apache.xindice.xml.dom.TextImpl;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.w3c.dom.traversal.DocumentTraversal;
import org.w3c.dom.traversal.NodeFilter;
import org.w3c.dom.traversal.NodeIterator;

public abstract class ContainerNodeImpl
extends NodeImpl {
    private static final Log log = LogFactory.getLog((Class)(class$org$apache$xindice$xml$dom$ContainerNodeImpl == null ? (class$org$apache$xindice$xml$dom$ContainerNodeImpl = ContainerNodeImpl.class$("org.apache.xindice.xml.dom.ContainerNodeImpl")) : class$org$apache$xindice$xml$dom$ContainerNodeImpl));
    protected NodeListImpl childNodes = new NodeListImpl(this);
    static /* synthetic */ Class class$org$apache$xindice$xml$dom$ContainerNodeImpl;

    public ContainerNodeImpl() {
    }

    public ContainerNodeImpl(NodeImpl parentNode, byte[] data, int pos, int len) {
        super(parentNode, data, pos, len);
    }

    public ContainerNodeImpl(NodeImpl parentNode, boolean dirty) {
        super(parentNode, dirty);
    }

    protected boolean isNodeTypeValid(short type) {
        return true;
    }

    protected final Node getPreviousSibling(Node node) {
        this.checkLoaded();
        int pos = this.childNodes.indexOf(node) - 1;
        return pos >= 0 ? this.childNodes.item(pos) : null;
    }

    protected final Node getNextSibling(Node node) {
        this.checkLoaded();
        int pos = this.childNodes.indexOf(node) + 1;
        return pos < this.childNodes.getLength() ? this.childNodes.item(pos) : null;
    }

    protected void checkLoaded() {
        block4: {
            if (this.loaded) {
                return;
            }
            this.loaded = true;
            try {
                if (this.data != null) {
                    DocumentImpl doc = (DocumentImpl)this.getOwnerDocument();
                    this.loadChildren(doc.getSymbols());
                }
            }
            catch (Exception e) {
                if (!log.isWarnEnabled()) break block4;
                log.warn((Object)"ignored exception", (Throwable)e);
            }
        }
    }

    protected final void loadChildren(SymbolTable st) throws IOException {
        ByteArrayInput bis = new ByteArrayInput(this.data, this.pos, this.len);
        XMLCompressedInput in = new XMLCompressedInput(bis, st);
        if (this.getNodeType() == 1) {
            in.readSignature();
            in.readContentSize();
            in.readShort();
            int attrCount = in.readAttributeCount();
            int i = 0;
            while (i < attrCount) {
                in.readShort();
                in.skip(in.readShort());
                ++i;
            }
        } else {
            in.readInt();
        }
        while (bis.available() > 0) {
            int pos = bis.getPos();
            in.readSignature();
            int len = in.readContentSize();
            if (len == 0) {
                len = 1;
            }
            switch (in.getNodeType()) {
                case 1: {
                    this.childNodes.add(new ElementImpl(this, this.data, pos, len));
                    break;
                }
                case 3: {
                    this.childNodes.add(new TextImpl(this, this.data, pos, len));
                    break;
                }
                case 4: {
                    this.childNodes.add(new CDATASectionImpl(this, this.data, pos, len));
                    break;
                }
                case 5: {
                    this.childNodes.add(new EntityReferenceImpl(this, this.data, pos, len));
                    break;
                }
                case 6: {
                    this.childNodes.add(new EntityImpl(this, this.data, pos, len));
                    break;
                }
                case 7: {
                    this.childNodes.add(new ProcessingInstructionImpl(this, this.data, pos, len));
                    break;
                }
                case 8: {
                    this.childNodes.add(new CommentImpl(this, this.data, pos, len));
                    break;
                }
                case 12: {
                    this.childNodes.add(new NotationImpl(this, this.data, pos, len));
                    break;
                }
                default: {
                    if (!log.isWarnEnabled()) break;
                    log.warn((Object)("invalid node type : " + in.getNodeType()));
                }
            }
            bis.setPos(pos);
            bis.skip(len);
        }
    }

    public final boolean hasChildNodes() {
        this.checkLoaded();
        return this.childNodes.getLength() > 0;
    }

    public final NodeList getChildNodes() {
        this.checkLoaded();
        return this.childNodes;
    }

    public final Node getFirstChild() {
        this.checkLoaded();
        if (this.childNodes.size() > 0) {
            return this.childNodes.item(0);
        }
        return null;
    }

    public final Node getLastChild() {
        this.checkLoaded();
        if (this.childNodes.size() > 0) {
            return this.childNodes.item(this.childNodes.getLength() - 1);
        }
        return null;
    }

    public final synchronized Node replaceChild(Node newChild, Node oldChild) throws DOMException {
        this.checkLoaded();
        this.checkReadOnly();
        if (!this.isNodeTypeValid(newChild.getNodeType())) {
            throw NodeImpl.EX_HIERARCHY_REQUEST;
        }
        int idx = this.childNodes.indexOf(oldChild);
        if (idx >= 0) {
            if (newChild.getNodeType() == 11) {
                this.childNodes.remove(idx);
                NodeList nl = newChild.getChildNodes();
                int i = 0;
                while (i < nl.getLength()) {
                    NodeImpl impl = (NodeImpl)nl.item(i);
                    impl.setParentNode(this);
                    this.childNodes.add(idx + i, impl);
                    ++i;
                }
            } else {
                NodeImpl impl = (NodeImpl)newChild;
                impl.setParentNode(this);
                this.childNodes.set(idx, impl);
            }
        }
        this.setDirty();
        return oldChild;
    }

    public final synchronized Node insertBefore(Node newChild, Node refChild) throws DOMException {
        this.checkLoaded();
        this.checkReadOnly();
        int idx = this.childNodes.indexOf(refChild);
        if (idx >= 0) {
            if (!this.isNodeTypeValid(newChild.getNodeType())) {
                throw NodeImpl.EX_HIERARCHY_REQUEST;
            }
            if (newChild.getNodeType() == 11) {
                NodeList nl = newChild.getChildNodes();
                int i = 0;
                while (i < nl.getLength()) {
                    NodeImpl impl = (NodeImpl)nl.item(i);
                    impl.setParentNode(this);
                    this.childNodes.add(idx + i, impl);
                    ++i;
                }
            } else {
                NodeImpl impl = (NodeImpl)newChild;
                impl.setParentNode(this);
                this.childNodes.add(idx, impl);
            }
        }
        this.setDirty();
        return newChild;
    }

    public final synchronized Node removeChild(Node oldChild) throws DOMException {
        this.checkLoaded();
        this.checkReadOnly();
        if (!((AbstractCollection)this.childNodes).remove(oldChild)) {
            throw NodeImpl.EX_NOT_FOUND;
        }
        this.setDirty();
        return oldChild;
    }

    public final synchronized Node appendChild(Node newChild) throws DOMException {
        this.checkLoaded();
        this.checkReadOnly();
        if (!this.isNodeTypeValid(newChild.getNodeType())) {
            throw NodeImpl.EX_HIERARCHY_REQUEST;
        }
        if (newChild.getNodeType() == 11) {
            NodeList nl = newChild.getChildNodes();
            int i = 0;
            while (i < nl.getLength()) {
                NodeImpl impl = (NodeImpl)nl.item(i);
                impl.setParentNode(this);
                this.childNodes.add(impl);
                ++i;
            }
        } else {
            NodeImpl impl = (NodeImpl)newChild;
            impl.setParentNode(this);
            this.childNodes.add(impl);
        }
        this.setDirty();
        return newChild;
    }

    public final synchronized void normalize() {
        this.checkLoaded();
        this.checkReadOnly();
        ArrayList<Node> set = new ArrayList<Node>();
        NodeListImpl newList = new NodeListImpl(this);
        boolean modified = false;
        int size = this.childNodes.size();
        int i = 0;
        while (i < size) {
            Node add = null;
            Node n = (Node)this.childNodes.get(i);
            short type = n.getNodeType();
            switch (type) {
                case 3: {
                    set.add(n);
                    break;
                }
                case 1: {
                    n.normalize();
                }
                default: {
                    add = n;
                }
            }
            if (!(set.isEmpty() || type == 3 && i != size - 1)) {
                Text s = (Text)set.get(0);
                int len = set.size();
                int j = 1;
                while (j < len) {
                    modified = true;
                    Text a = (Text)set.get(j);
                    s.appendData(a.getData());
                    ++j;
                }
                newList.add(s);
                set.clear();
            }
            if (add != null) {
                newList.add(add);
            }
            ++i;
        }
        if (modified) {
            this.childNodes = newList;
            this.setDirty();
        }
    }

    public final NodeList getElementsByTagName(final String name) {
        this.checkLoaded();
        NodeListImpl list = new NodeListImpl(this);
        NodeFilter filter = new NodeFilter(){

            public short acceptNode(Node node) {
                if (node.getNodeName().equals(name)) {
                    return 1;
                }
                return 3;
            }
        };
        NodeIterator nodeIterator = ((DocumentTraversal)((Object)this.getOwnerDocument())).createNodeIterator(this, 1, filter, false);
        Node node = null;
        do {
            if ((node = nodeIterator.nextNode()) == null) continue;
            list.add(node);
        } while (node != null);
        return list;
    }

    public final NodeList getElementsByTagNameNS(final String namespaceURI, final String localName) {
        this.checkLoaded();
        NodeListImpl list = new NodeListImpl(this);
        NodeFilter filter = new NodeFilter(){

            public short acceptNode(Node node) {
                if (node.getLocalName().equals(localName) && node.getNamespaceURI().equals(namespaceURI)) {
                    return 1;
                }
                return 3;
            }
        };
        NodeIterator nodeIterator = ((DocumentTraversal)((Object)this.getOwnerDocument())).createNodeIterator(this, 1, filter, false);
        Node node = null;
        do {
            if ((node = nodeIterator.nextNode()) == null) continue;
            list.add(node);
        } while (node != null);
        return list;
    }

    public final Element getElementById(String elementId) {
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

