/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xindice.xml.dom;

import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.HashMap;
import java.util.Iterator;
import org.apache.xindice.xml.dom.NodeImpl;
import org.apache.xindice.xml.dom.NodeListImpl;
import org.w3c.dom.DOMException;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public final class NamedNodeMapImpl
extends NodeListImpl
implements NamedNodeMap {
    private HashMap map = new HashMap();

    public NamedNodeMapImpl(NodeImpl owner) {
        super(owner);
    }

    public Node getNamedItem(String name) {
        return (Node)this.map.get(name);
    }

    public Node setNamedItem(Node arg) throws DOMException {
        String name = arg.getNodeName();
        Node node = (Node)this.map.get(name);
        if (node != null) {
            int idx = this.indexOf(node);
            this.set(idx, arg);
        } else {
            this.add(arg);
        }
        this.map.put(arg.getNodeName(), arg);
        return node;
    }

    public Node removeNamedItem(String name) throws DOMException {
        Node node = (Node)this.map.get(name);
        this.map.remove(name);
        ((AbstractCollection)this).remove(node);
        return node;
    }

    public Node getNamedItemNS(String namespaceURI, String localName) {
        Iterator iterator = ((AbstractList)this).iterator();
        while (iterator.hasNext()) {
            Node node = (Node)iterator.next();
            String ns = node.getNamespaceURI();
            String ln = node.getLocalName();
            if (ns == null || ln == null || !ns.equals(namespaceURI) || !ln.equals(localName)) continue;
            return node;
        }
        return null;
    }

    public Node setNamedItemNS(Node arg) throws DOMException {
        return this.setNamedItem(arg);
    }

    public Node removeNamedItemNS(String namespaceURI, String localName) throws DOMException {
        Iterator iterator = ((AbstractList)this).iterator();
        while (iterator.hasNext()) {
            Node node = (Node)iterator.next();
            if (!localName.equals(node.getLocalName()) || (namespaceURI != null || node.getNamespaceURI() != null) && (namespaceURI == null || !namespaceURI.equals(node.getNamespaceURI()))) continue;
            return this.removeNamedItem(node.getNodeName());
        }
        return null;
    }
}

