/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xindice.xml.dom;

import java.util.HashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xindice.xml.NodeSource;
import org.apache.xindice.xml.dom.AttrImpl;
import org.apache.xindice.xml.dom.CDATASectionImpl;
import org.apache.xindice.xml.dom.CommentImpl;
import org.apache.xindice.xml.dom.CompressedNode;
import org.apache.xindice.xml.dom.DBNode;
import org.apache.xindice.xml.dom.DOMCompressor;
import org.apache.xindice.xml.dom.DOMImplementationImpl;
import org.apache.xindice.xml.dom.DocumentFragmentImpl;
import org.apache.xindice.xml.dom.DocumentImpl;
import org.apache.xindice.xml.dom.ElementImpl;
import org.apache.xindice.xml.dom.EntityReferenceImpl;
import org.apache.xindice.xml.dom.NodeListImpl;
import org.apache.xindice.xml.dom.NotationImpl;
import org.apache.xindice.xml.dom.ProcessingInstructionImpl;
import org.apache.xindice.xml.dom.TextImpl;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class NodeImpl
implements CompressedNode,
DBNode {
    private static final Log log = LogFactory.getLog((Class)(class$org$apache$xindice$xml$dom$NodeImpl == null ? (class$org$apache$xindice$xml$dom$NodeImpl = NodeImpl.class$("org.apache.xindice.xml.dom.NodeImpl")) : class$org$apache$xindice$xml$dom$NodeImpl));
    public static final String XMLNS_PREFIX = "xmlns";
    public static final String OBJECT_NS = "http://xml.apache.org/xindice/XMLObject";
    public static final String OBJECT_HREF = "href";
    public static final String OBJECT_TYPE = "type";
    public static final String TYPE_CONTENT = "content";
    public static final String TYPE_REPLACE = "replace";
    public static final String TYPE_INSERT = "insert";
    public static final String TYPE_APPEND = "append";
    public static final String XMLNS_URI = "http://www.w3.org/2000/xmlns/";
    public static final DOMException EX_NO_MODIFICATION_ALLOWED = new DOMException(7, "This Node Is Read-Only");
    public static final DOMException EX_INUSE_ATTRIBUTE = new DOMException(10, "This Attribute Belongs To Another Element");
    public static final DOMException EX_WRONG_DOCUMENT = new DOMException(4, "This Attribute Belongs To Another Document");
    public static final DOMException EX_NOT_FOUND = new DOMException(8, "This Node Does Not Belong To This Element");
    public static final DOMException EX_HIERARCHY_REQUEST = new DOMException(3, "This Node Cannot Contain This Child");
    public static final DOMException EX_NO_DATA_ALLOWED = new DOMException(6, "This Node Has No Value");
    public static final DOMException EX_INVALID_STATE = new DOMException(11, "NodeIterator Has Been Detached");
    public static final DOMException EX_DOMSTRING_SIZE = new DOMException(2, "String Too Large For Type");
    public static final DOMException EX_INDEX_SIZE = new DOMException(1, "Index Out Of Bounds");
    protected NodeSource source;
    protected byte[] data;
    protected int pos;
    protected int len;
    protected boolean loaded;
    protected boolean dirty;
    protected NodeImpl parentNode;
    protected String nodeName;
    protected String nodeValue;
    protected String nsURI;
    protected HashMap userData;
    protected Object key;
    static /* synthetic */ Class class$org$apache$xindice$xml$dom$NodeImpl;

    public NodeImpl() {
    }

    public NodeImpl(byte[] data, int pos, int len) {
        this.data = data;
        this.pos = pos;
        this.len = len;
    }

    public NodeImpl(NodeImpl parentNode, byte[] data, int pos, int len) {
        this(data, pos, len);
        this.parentNode = parentNode;
    }

    public NodeImpl(NodeImpl parentNode, boolean dirty) {
        this.parentNode = parentNode;
        if (dirty) {
            this.setDirty();
        }
    }

    public final boolean isLoaded() {
        return this.loaded;
    }

    protected void checkLoaded() {
        if (this.loaded) {
            return;
        }
        this.loaded = true;
    }

    public void load() {
        this.checkLoaded();
    }

    public void unload() {
        if (this.loaded) {
            this.loaded = false;
        }
    }

    public short getSymbolID() {
        return -1;
    }

    public final void checkReadOnly() throws DOMException {
        DocumentImpl doc = (DocumentImpl)this.getOwnerDocument();
        if (doc != null && doc.isReadOnly()) {
            throw EX_NO_MODIFICATION_ALLOWED;
        }
    }

    public final boolean isDefined() {
        return this.data != null;
    }

    public final boolean isDirty() {
        return this.dirty;
    }

    public final void setDirty() {
        this.dirty = true;
        if (this.parentNode != null) {
            this.parentNode.setDirty();
        }
    }

    public byte[] getDataBytes() {
        return this.data;
    }

    public void setDataBytes(byte[] data, int pos, int len) {
        this.data = data;
        this.pos = pos;
        this.len = len;
    }

    public void setDataBytes(byte[] data) {
        this.data = data;
    }

    public int getDataPos() {
        return this.pos;
    }

    public void setDataPos(int pos) {
        this.pos = pos;
    }

    public int getDataLen() {
        return this.len;
    }

    public void setDataLen(int len) {
        this.len = len;
    }

    public final void setNodeName(String nodeName) {
        this.checkLoaded();
        this.nodeName = nodeName;
        this.setDirty();
    }

    public final void setParentNode(NodeImpl parentNode) {
        this.parentNode = parentNode;
    }

    protected Node getPreviousSibling(Node node) {
        return null;
    }

    protected Node getNextSibling(Node node) {
        return null;
    }

    public final void setSource(NodeSource source) {
        this.source = source;
    }

    public final NodeSource getSource() {
        if (this.source == null && this.parentNode != null) {
            return this.parentNode.getSource();
        }
        return this.source;
    }

    public void expandSource() {
    }

    public abstract short getNodeType();

    public Node getLastChild() {
        return null;
    }

    public final Node getPreviousSibling() {
        return this.parentNode != null ? this.parentNode.getPreviousSibling(this) : null;
    }

    public final Node getNextSibling() {
        return this.parentNode != null ? this.parentNode.getNextSibling(this) : null;
    }

    public NamedNodeMap getAttributes() {
        return null;
    }

    public boolean hasAttributes() {
        return false;
    }

    public final Document getOwnerDocument() {
        if (this.getNodeType() == 9) {
            return (Document)((Object)this);
        }
        return this.parentNode != null ? this.parentNode.getOwnerDocument() : null;
    }

    public Node insertBefore(Node newChild, Node refChild) throws DOMException {
        throw EX_HIERARCHY_REQUEST;
    }

    public NodeList getChildNodes() {
        return new NodeListImpl(this);
    }

    public void setNodeValue(String nodeValue) throws DOMException {
        throw EX_NO_DATA_ALLOWED;
    }

    public final Node getParentNode() {
        return this.parentNode;
    }

    public Node getFirstChild() {
        return null;
    }

    public String getNodeName() {
        this.checkLoaded();
        return this.nodeName;
    }

    public String getNodeValue() throws DOMException {
        this.checkLoaded();
        return this.nodeValue;
    }

    public synchronized Node replaceChild(Node newChild, Node oldChild) throws DOMException {
        throw EX_HIERARCHY_REQUEST;
    }

    public synchronized Node removeChild(Node oldChild) throws DOMException {
        throw EX_NOT_FOUND;
    }

    public synchronized Node appendChild(Node newChild) throws DOMException {
        throw EX_HIERARCHY_REQUEST;
    }

    public boolean hasChildNodes() {
        return false;
    }

    public final synchronized Node cloneNode(boolean deep) {
        DocumentImpl doc = (DocumentImpl)this.getOwnerDocument();
        if (deep) {
            int len;
            int pos;
            byte[] data;
            block30: {
                data = this.data;
                pos = this.pos;
                len = this.len;
                if (this.dirty) {
                    try {
                        data = DOMCompressor.Compress(this, doc.getSymbols());
                        pos = 0;
                        len = data.length;
                    }
                    catch (Exception e) {
                        if (!log.isWarnEnabled()) break block30;
                        log.warn((Object)"ignored exception", (Throwable)e);
                    }
                }
            }
            NodeImpl newNode = null;
            switch (this.getNodeType()) {
                case 2: {
                    newNode = new AttrImpl(this, true);
                    newNode.setNodeName(this.getNodeName());
                    newNode.setNodeValue(this.getNodeValue());
                    break;
                }
                case 4: {
                    newNode = new CDATASectionImpl(this, data, pos, len);
                    break;
                }
                case 8: {
                    newNode = new CommentImpl(this, data, pos, len);
                    break;
                }
                case 11: {
                    DocumentFragmentImpl df = new DocumentFragmentImpl(this);
                    if (deep) {
                        NodeList nl = this.getChildNodes();
                        int i = 0;
                        while (i < nl.getLength()) {
                            df.appendChild(nl.item(i).cloneNode(deep));
                            ++i;
                        }
                    }
                    newNode = df;
                    break;
                }
                case 1: {
                    newNode = new ElementImpl(this, data, pos, len);
                    break;
                }
                case 5: {
                    newNode = new EntityReferenceImpl(this, data, pos, len);
                    break;
                }
                case 12: {
                    newNode = new NotationImpl(this, data, pos, len);
                    break;
                }
                case 7: {
                    newNode = new ProcessingInstructionImpl(this, data, pos, len);
                    break;
                }
                case 3: {
                    newNode = new TextImpl(this, data, pos, len);
                    break;
                }
                default: {
                    if (!log.isWarnEnabled()) break;
                    log.warn((Object)("invalid node type : " + this.getNodeType()));
                }
            }
            if (newNode != null) {
                return newNode;
            }
        }
        this.checkLoaded();
        switch (this.getNodeType()) {
            case 2: {
                Attr attr = doc.createAttribute(this.nodeName);
                attr.setValue(this.nodeValue);
                return attr;
            }
            case 4: {
                return doc.createCDATASection(this.nodeValue);
            }
            case 8: {
                return doc.createComment(this.nodeValue);
            }
            case 11: {
                return doc.createDocumentFragment();
            }
            case 1: {
                Element elem = doc.createElement(this.nodeName);
                NamedNodeMap attrs = this.getAttributes();
                int size = attrs.getLength();
                int i = 0;
                while (i < size) {
                    Attr a = (Attr)attrs.item(i);
                    elem.setAttribute(a.getName(), a.getValue());
                    ++i;
                }
                return elem;
            }
            case 5: {
                return doc.createEntityReference(this.nodeValue);
            }
            case 7: {
                return doc.createProcessingInstruction(this.nodeName, this.nodeValue);
            }
            case 3: {
                return doc.createTextNode(this.nodeValue);
            }
        }
        if (log.isWarnEnabled()) {
            log.warn((Object)("invalid node type : " + this.getNodeType()));
        }
        return null;
    }

    public void normalize() {
    }

    public final boolean isSupported(String feature, String version) {
        return DOMImplementationImpl.HasFeature(feature, version);
    }

    public final String getNamespaceURI() {
        short nodeType = this.getNodeType();
        if (nodeType == 2 && (this.nodeName.equals(XMLNS_PREFIX) || this.nodeName.startsWith("xmlns:"))) {
            return XMLNS_URI;
        }
        if (this.nsURI != null) {
            return this.nsURI;
        }
        if (nodeType != 1 && nodeType != 2) {
            return null;
        }
        String prefix = this.getPrefix();
        return prefix != null ? this.lookupNamespaceURI(prefix) : this.lookupDefaultNamespaceURI();
    }

    public final String getPrefix() {
        short nodeType = this.getNodeType();
        if (nodeType != 1 && nodeType != 2) {
            return null;
        }
        this.checkLoaded();
        int idx = this.nodeName.indexOf(58);
        return idx != -1 ? this.nodeName.substring(0, idx) : null;
    }

    public final void setPrefix(String prefix) {
        short nodeType = this.getNodeType();
        if (nodeType != 1 && nodeType != 2) {
            return;
        }
        this.checkReadOnly();
        String ln = this.getLocalName();
        if (prefix != null) {
            this.setNodeName(prefix + ':' + ln);
        } else {
            this.setNodeName(ln);
        }
    }

    public final String getLocalName() {
        short nodeType = this.getNodeType();
        if (nodeType != 1 && nodeType != 2) {
            return null;
        }
        String prefix = this.getPrefix();
        return prefix != null ? this.getNodeName().substring(prefix.length() + 1) : this.getNodeName();
    }

    public final String lookupDefaultNamespaceURI() {
        if (this.getNodeType() != 1) {
            return null;
        }
        String uri = ((Element)((Object)this)).getAttribute(XMLNS_PREFIX);
        if (uri != null && uri.length() > 0) {
            return uri;
        }
        return this.parentNode != null ? this.parentNode.lookupDefaultNamespaceURI() : null;
    }

    public final boolean isSameNode(Node other) {
        return this == other;
    }

    public final String lookupNamespacePrefix(String namespaceURI) {
        if (this.getNodeType() == 1) {
            NamedNodeMap map = this.getAttributes();
            int size = map.getLength();
            int i = 0;
            while (i < size) {
                Attr attr = (Attr)map.item(i);
                String name = attr.getName();
                if (name.startsWith("xmlns:") && attr.getValue().equals(namespaceURI)) {
                    return name.substring(XMLNS_PREFIX.length() + 1);
                }
                ++i;
            }
        }
        return this.parentNode != null ? this.parentNode.lookupNamespacePrefix(namespaceURI) : null;
    }

    public final String lookupNamespaceURI(String prefix) {
        String uri = null;
        if (this.getNodeType() == 1) {
            uri = ((Element)((Object)this)).getAttribute("xmlns:" + prefix);
        }
        if (uri != null && uri.length() > 0) {
            return uri;
        }
        return this.parentNode != null ? this.parentNode.lookupNamespaceURI(prefix) : null;
    }

    public void normalizeNS() throws DOMException {
    }

    public final synchronized Object setUserData(Object data, String key) {
        if (this.userData == null) {
            this.userData = new HashMap();
        }
        Object oldData = this.userData.get(key);
        this.userData.put(key, data);
        return oldData;
    }

    public final synchronized Object getUserData(String key) {
        if (this.userData == null) {
            return null;
        }
        return this.userData.get(key);
    }

    public final synchronized Object getKey() {
        if (this.key == null) {
            this.key = new Object();
        }
        return this.key;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

