/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xindice.xml.dom.traversal;

import org.apache.xindice.xml.dom.NodeImpl;
import org.w3c.dom.DOMException;
import org.w3c.dom.Node;
import org.w3c.dom.traversal.NodeFilter;
import org.w3c.dom.traversal.NodeIterator;
import org.w3c.dom.traversal.TreeWalker;

public final class TreeWalkerImpl
implements TreeWalker,
NodeIterator {
    protected boolean valid = true;
    protected Node root = null;
    protected Node next = null;
    protected int whatToShow = -1;
    protected NodeFilter filter = null;
    protected boolean expand = false;

    public TreeWalkerImpl(Node root, int whatToShow, NodeFilter filter, boolean entityReferenceExpansion) throws DOMException {
        this.next = root;
        this.whatToShow = whatToShow;
        this.filter = filter;
        this.expand = entityReferenceExpansion;
        if (this.acceptNode(root)) {
            this.next = root;
        } else {
            this.nextNode();
        }
    }

    public int getShowType(Node node) {
        switch (node.getNodeType()) {
            case 2: {
                return 2;
            }
            case 4: {
                return 8;
            }
            case 8: {
                return 128;
            }
            case 11: {
                return 1024;
            }
            case 9: {
                return 256;
            }
            case 10: {
                return 512;
            }
            case 1: {
                return 1;
            }
            case 6: {
                return 32;
            }
            case 5: {
                return 16;
            }
            case 12: {
                return 2048;
            }
            case 7: {
                return 64;
            }
            case 3: {
                return 4;
            }
        }
        return 0;
    }

    public boolean acceptNode(Node node) {
        return (this.getShowType(node) & this.whatToShow) > 0 && (this.filter == null || this.filter.acceptNode(node) == 1);
    }

    public Node getRoot() {
        return this.root;
    }

    public int getWhatToShow() {
        return this.whatToShow;
    }

    public NodeFilter getFilter() {
        return this.filter;
    }

    public boolean getExpandEntityReferences() {
        return this.expand;
    }

    public void detach() {
        this.valid = false;
    }

    public Node getCurrentNode() {
        return this.next;
    }

    public void setCurrentNode(Node currentNode) throws DOMException {
        if (!this.valid) {
            throw NodeImpl.EX_INVALID_STATE;
        }
        this.next = currentNode;
    }

    public Node parentNode() {
        Node node = this.next;
        while (node != null) {
            if (node == this.root) {
                return null;
            }
            if ((node = node.getParentNode()) == null) {
                return null;
            }
            if (!this.acceptNode(node)) continue;
            this.next = node;
            return this.next;
        }
        return null;
    }

    public Node firstChild() {
        Node node = this.next.getFirstChild();
        while (node != null) {
            if (this.acceptNode(node)) {
                this.next = node;
                return this.next;
            }
            node = node.getNextSibling();
        }
        return null;
    }

    public Node lastChild() {
        Node node = this.next.getLastChild();
        while (node != null) {
            if (this.acceptNode(node)) {
                this.next = node;
                return this.next;
            }
            node = node.getPreviousSibling();
        }
        return null;
    }

    public Node previousSibling() {
        Node node = this.next.getPreviousSibling();
        while (node != null) {
            if (this.acceptNode(node)) {
                this.next = node;
                return this.next;
            }
            node = node.getPreviousSibling();
        }
        return null;
    }

    public Node nextSibling() {
        Node node = this.next.getNextSibling();
        while (node != null) {
            if (this.acceptNode(node)) {
                this.next = node;
                return this.next;
            }
            node = node.getNextSibling();
        }
        return null;
    }

    /*
     * Unable to fully structure code
     */
    public Node previousNode() {
        node = this.next;
        do {
            block2: {
                if ((node = node.getPreviousSibling()) != null) ** GOTO lbl7
                node = node.getParentNode();
                break block2;
lbl-1000:
                // 1 sources

                {
                    node = node.getLastChild();
lbl7:
                    // 2 sources

                    ** while (node.hasChildNodes())
                }
            }
            if (node == null || !this.acceptNode(node)) continue;
            this.next = node;
            return this.next;
        } while (node != null);
        return null;
    }

    public Node nextNode() {
        Node result = null;
        if (this.next == null) {
            return null;
        }
        result = this.next;
        Node node = this.next;
        block0: do {
            if (node.hasChildNodes()) {
                node = node.getFirstChild();
                continue;
            }
            do {
                Node old = node;
                if ((node = node.getNextSibling()) != null) continue block0;
                node = old;
            } while ((node = node.getParentNode()) != null && node != this.root);
            this.next = null;
            return result;
        } while (node == null || !this.acceptNode(node));
        this.next = node;
        return result;
    }
}

