/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.sandbox.markup;

import java.io.IOException;
import java.io.Writer;

public class StreamingMarkupWriter
extends Writer {
    protected final Writer delegate;
    private final int encodingLimit = 127;
    private final Writer bodyWriter = new Writer(){

        public void close() throws IOException {
            StreamingMarkupWriter.this.close();
        }

        public void flush() throws IOException {
            StreamingMarkupWriter.this.flush();
        }

        public void write(int c) throws IOException {
            if (c > 127) {
                StreamingMarkupWriter.this.delegate.write("&#x");
                StreamingMarkupWriter.this.delegate.write(Integer.toHexString(c));
                StreamingMarkupWriter.this.delegate.write(59);
            } else if (c == 60) {
                StreamingMarkupWriter.this.delegate.write("&lt;");
            } else if (c == 62) {
                StreamingMarkupWriter.this.delegate.write("&gt;");
            } else if (c == 38) {
                StreamingMarkupWriter.this.delegate.write("&amp;");
            } else {
                StreamingMarkupWriter.this.delegate.write(c);
            }
        }

        public void write(char[] cbuf, int off, int len) throws IOException {
            while (len-- > 0) {
                this.write(cbuf[off++]);
            }
        }

        public Writer attributeValue() {
            return StreamingMarkupWriter.this.attributeWriter;
        }

        public Writer bodyText() {
            return StreamingMarkupWriter.this.bodyWriter;
        }

        public Writer unescaped() {
            return StreamingMarkupWriter.this;
        }
    };
    private final Writer attributeWriter = new Writer(){

        public void close() throws IOException {
            StreamingMarkupWriter.this.close();
        }

        public void flush() throws IOException {
            StreamingMarkupWriter.this.flush();
        }

        public void write(int c) throws IOException {
            if (c == 39) {
                StreamingMarkupWriter.this.delegate.write("&apos;");
            } else {
                StreamingMarkupWriter.this.bodyWriter.write(c);
            }
        }

        public void write(char[] cbuf, int off, int len) throws IOException {
            while (len-- > 0) {
                this.write(cbuf[off++]);
            }
        }

        public Writer attributeValue() {
            return StreamingMarkupWriter.this.attributeWriter;
        }

        public Writer bodyText() {
            return StreamingMarkupWriter.this.bodyWriter;
        }

        public Writer unescaped() {
            return StreamingMarkupWriter.this;
        }
    };

    public StreamingMarkupWriter(Writer delegate) {
        this.delegate = delegate;
    }

    public void close() throws IOException {
        this.delegate.close();
    }

    public void flush() throws IOException {
        this.delegate.flush();
    }

    public void write(char[] cbuf, int off, int len) throws IOException {
        this.delegate.write(cbuf, off, len);
    }

    public Writer attributeValue() {
        return this.attributeWriter;
    }

    public Writer bodyText() {
        return this.bodyWriter;
    }

    public Writer unescaped() {
        return this;
    }
}

