/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.syntax.parser;

import org.codehaus.groovy.syntax.Token;
import org.codehaus.groovy.syntax.Types;
import org.codehaus.groovy.syntax.parser.ParserException;

public class UnexpectedTokenException
extends ParserException {
    private Token unexpectedToken;
    private int[] expectedTypes;
    private String comment;

    public UnexpectedTokenException(Token token) {
        this(token, null, null);
    }

    public UnexpectedTokenException(Token token, int expectedType) {
        this(token, new int[]{expectedType});
    }

    public UnexpectedTokenException(Token token, int[] expectedTypes) {
        this(token, expectedTypes, null);
    }

    public UnexpectedTokenException(Token token, int[] expectedTypes, String comment) {
        super("Unexpected token", token);
        this.unexpectedToken = token;
        this.expectedTypes = expectedTypes;
        this.comment = comment;
    }

    public Token getUnexpectedToken() {
        return this.unexpectedToken;
    }

    public int[] getExpectedTypes() {
        return this.expectedTypes;
    }

    public String getUnexpectedTokenText() {
        String text = null;
        if (this.unexpectedToken != null) {
            text = this.unexpectedToken.getText();
        }
        if (text == null) {
            text = "";
        }
        return text;
    }

    public String getMessage() {
        StringBuffer message = new StringBuffer();
        if (this.expectedTypes != null) {
            message.append("expected ");
            if (this.expectedTypes.length == 1) {
                message.append(Types.getDescription(this.expectedTypes[0]));
            } else {
                message.append("one of { ");
                for (int i = 0; i < this.expectedTypes.length; ++i) {
                    message.append(Types.getDescription(this.expectedTypes[i]));
                    if (i + 1 < this.expectedTypes.length) {
                        if (this.expectedTypes.length > 2) {
                            message.append(", ");
                        } else {
                            message.append(" ");
                        }
                    }
                    if (i + 2 != this.expectedTypes.length) continue;
                    message.append("or ");
                }
                message.append(" }");
            }
            message.append("; found '");
        } else {
            message.append("could not use '");
        }
        message.append(this.getUnexpectedTokenText()).append("'");
        if (this.unexpectedToken != null) {
            message.append(" at " + this.unexpectedToken.getStartLine() + ":" + this.unexpectedToken.getStartColumn());
        } else {
            message.append(" at unknown location (probably end of file)");
        }
        if (this.comment != null) {
            message.append("; ");
            message.append(this.comment);
        }
        return message.toString();
    }
}

