/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.dbcp;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.commons.dbcp.AbandonedConfig;
import org.apache.commons.dbcp.ConnectionFactory;
import org.apache.commons.dbcp.DelegatingConnection;
import org.apache.commons.dbcp.PoolableConnection;
import org.apache.commons.dbcp.PoolingConnection;
import org.apache.commons.pool.KeyedObjectPool;
import org.apache.commons.pool.KeyedObjectPoolFactory;
import org.apache.commons.pool.KeyedPoolableObjectFactory;
import org.apache.commons.pool.ObjectPool;
import org.apache.commons.pool.PoolableObjectFactory;

public class PoolableConnectionFactory
implements PoolableObjectFactory {
    protected ConnectionFactory _connFactory = null;
    protected String _validationQuery = null;
    protected ObjectPool _pool = null;
    protected KeyedObjectPoolFactory _stmtPoolFactory = null;
    protected Boolean _defaultReadOnly = null;
    protected boolean _defaultAutoCommit = true;
    protected int _defaultTransactionIsolation = -1;
    protected String _defaultCatalog;
    protected AbandonedConfig _config = null;
    static final int UNKNOWN_TRANSACTIONISOLATION = -1;

    public PoolableConnectionFactory(ConnectionFactory connFactory, ObjectPool pool, KeyedObjectPoolFactory stmtPoolFactory, String validationQuery, boolean defaultReadOnly, boolean defaultAutoCommit) {
        this._connFactory = connFactory;
        this._pool = pool;
        this._pool.setFactory((PoolableObjectFactory)this);
        this._stmtPoolFactory = stmtPoolFactory;
        this._validationQuery = validationQuery;
        this._defaultReadOnly = defaultReadOnly ? Boolean.TRUE : Boolean.FALSE;
        this._defaultAutoCommit = defaultAutoCommit;
    }

    public PoolableConnectionFactory(ConnectionFactory connFactory, ObjectPool pool, KeyedObjectPoolFactory stmtPoolFactory, String validationQuery, boolean defaultReadOnly, boolean defaultAutoCommit, int defaultTransactionIsolation) {
        this._connFactory = connFactory;
        this._pool = pool;
        this._pool.setFactory((PoolableObjectFactory)this);
        this._stmtPoolFactory = stmtPoolFactory;
        this._validationQuery = validationQuery;
        this._defaultReadOnly = defaultReadOnly ? Boolean.TRUE : Boolean.FALSE;
        this._defaultAutoCommit = defaultAutoCommit;
        this._defaultTransactionIsolation = defaultTransactionIsolation;
    }

    public PoolableConnectionFactory(ConnectionFactory connFactory, ObjectPool pool, KeyedObjectPoolFactory stmtPoolFactory, String validationQuery, boolean defaultReadOnly, boolean defaultAutoCommit, AbandonedConfig config) {
        this._connFactory = connFactory;
        this._pool = pool;
        this._config = config;
        this._pool.setFactory((PoolableObjectFactory)this);
        this._stmtPoolFactory = stmtPoolFactory;
        this._validationQuery = validationQuery;
        this._defaultReadOnly = defaultReadOnly ? Boolean.TRUE : Boolean.FALSE;
        this._defaultAutoCommit = defaultAutoCommit;
    }

    public PoolableConnectionFactory(ConnectionFactory connFactory, ObjectPool pool, KeyedObjectPoolFactory stmtPoolFactory, String validationQuery, boolean defaultReadOnly, boolean defaultAutoCommit, int defaultTransactionIsolation, AbandonedConfig config) {
        this._connFactory = connFactory;
        this._pool = pool;
        this._config = config;
        this._pool.setFactory((PoolableObjectFactory)this);
        this._stmtPoolFactory = stmtPoolFactory;
        this._validationQuery = validationQuery;
        this._defaultReadOnly = defaultReadOnly ? Boolean.TRUE : Boolean.FALSE;
        this._defaultAutoCommit = defaultAutoCommit;
        this._defaultTransactionIsolation = defaultTransactionIsolation;
    }

    public PoolableConnectionFactory(ConnectionFactory connFactory, ObjectPool pool, KeyedObjectPoolFactory stmtPoolFactory, String validationQuery, boolean defaultReadOnly, boolean defaultAutoCommit, int defaultTransactionIsolation, String defaultCatalog, AbandonedConfig config) {
        this._connFactory = connFactory;
        this._pool = pool;
        this._config = config;
        this._pool.setFactory((PoolableObjectFactory)this);
        this._stmtPoolFactory = stmtPoolFactory;
        this._validationQuery = validationQuery;
        this._defaultReadOnly = defaultReadOnly ? Boolean.TRUE : Boolean.FALSE;
        this._defaultAutoCommit = defaultAutoCommit;
        this._defaultTransactionIsolation = defaultTransactionIsolation;
        this._defaultCatalog = defaultCatalog;
    }

    public PoolableConnectionFactory(ConnectionFactory connFactory, ObjectPool pool, KeyedObjectPoolFactory stmtPoolFactory, String validationQuery, Boolean defaultReadOnly, boolean defaultAutoCommit, int defaultTransactionIsolation, String defaultCatalog, AbandonedConfig config) {
        this._connFactory = connFactory;
        this._pool = pool;
        this._config = config;
        this._pool.setFactory((PoolableObjectFactory)this);
        this._stmtPoolFactory = stmtPoolFactory;
        this._validationQuery = validationQuery;
        this._defaultReadOnly = defaultReadOnly;
        this._defaultAutoCommit = defaultAutoCommit;
        this._defaultTransactionIsolation = defaultTransactionIsolation;
        this._defaultCatalog = defaultCatalog;
    }

    public synchronized void setConnectionFactory(ConnectionFactory connFactory) {
        this._connFactory = connFactory;
    }

    public synchronized void setValidationQuery(String validationQuery) {
        this._validationQuery = validationQuery;
    }

    public synchronized void setPool(ObjectPool pool) {
        if (null != this._pool && pool != this._pool) {
            try {
                this._pool.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this._pool = pool;
    }

    public ObjectPool getPool() {
        return this._pool;
    }

    public synchronized void setStatementPoolFactory(KeyedObjectPoolFactory stmtPoolFactory) {
        this._stmtPoolFactory = stmtPoolFactory;
    }

    public void setDefaultReadOnly(boolean defaultReadOnly) {
        this._defaultReadOnly = defaultReadOnly ? Boolean.TRUE : Boolean.FALSE;
    }

    public void setDefaultAutoCommit(boolean defaultAutoCommit) {
        this._defaultAutoCommit = defaultAutoCommit;
    }

    public void setDefaultTransactionIsolation(int defaultTransactionIsolation) {
        this._defaultTransactionIsolation = defaultTransactionIsolation;
    }

    public void setDefaultCatalog(String defaultCatalog) {
        this._defaultCatalog = defaultCatalog;
    }

    public synchronized Object makeObject() throws Exception {
        Connection conn = this._connFactory.createConnection();
        if (null != this._stmtPoolFactory) {
            KeyedObjectPool stmtpool = this._stmtPoolFactory.createPool();
            conn = new PoolingConnection(conn, stmtpool);
            stmtpool.setFactory((KeyedPoolableObjectFactory)((PoolingConnection)conn));
        }
        return new PoolableConnection(conn, this._pool, this._config);
    }

    public void destroyObject(Object obj) throws Exception {
        if (obj instanceof PoolableConnection) {
            ((PoolableConnection)obj).reallyClose();
        }
    }

    public boolean validateObject(Object obj) {
        if (obj instanceof Connection) {
            try {
                this.validateConnection((Connection)obj);
                return true;
            }
            catch (Exception e) {
                return false;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void validateConnection(Connection conn) throws SQLException {
        String query = this._validationQuery;
        if (conn.isClosed()) {
            throw new SQLException("validateConnection: connection closed");
        }
        if (null != query) {
            Statement stmt = null;
            ResultSet rset = null;
            try {
                stmt = conn.createStatement();
                rset = stmt.executeQuery(query);
                if (!rset.next()) {
                    throw new SQLException("validationQuery didn't return a row");
                }
            }
            finally {
                try {
                    rset.close();
                }
                catch (Exception t) {}
                try {
                    stmt.close();
                }
                catch (Exception t) {}
            }
        }
    }

    public void passivateObject(Object obj) throws Exception {
        if (obj instanceof Connection) {
            Connection conn = (Connection)obj;
            if (!conn.getAutoCommit() && !conn.isReadOnly()) {
                conn.rollback();
            }
            conn.clearWarnings();
            conn.setAutoCommit(true);
        }
        if (obj instanceof DelegatingConnection) {
            ((DelegatingConnection)obj).passivate();
        }
    }

    public void activateObject(Object obj) throws Exception {
        if (obj instanceof DelegatingConnection) {
            ((DelegatingConnection)obj).activate();
        }
        if (obj instanceof Connection) {
            Connection conn = (Connection)obj;
            conn.setAutoCommit(this._defaultAutoCommit);
            if (this._defaultTransactionIsolation != -1) {
                conn.setTransactionIsolation(this._defaultTransactionIsolation);
            }
            if (this._defaultReadOnly != null) {
                conn.setReadOnly(this._defaultReadOnly);
            }
            if (this._defaultCatalog != null) {
                conn.setCatalog(this._defaultCatalog);
            }
        }
    }
}

