/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.elementprocessor.impl.poi.hssf.elements;

import java.io.IOException;
import org.apache.cocoon.components.elementprocessor.types.NumericConverter;
import org.apache.cocoon.components.elementprocessor.types.Validator;

public class Anchors {
    private static final int _component_count = 4;
    private int[] _components = new int[4];
    public static final int ANCHOR_UNKNOWN = 0;
    public static final int ANCHOR_PERCENTAGE_FROM_COLROW_ST = 16;
    public static final int ANCHOR_PERCENTAGE_FROM_COLROW_END = 17;
    public static final int ANCHOR_PTS_FROM_COLROW_START = 32;
    public static final int ANCHOR_PTS_FROM_COLROW_END = 33;
    public static final int ANCHOR_PTS_ABSOLUTE = 48;
    private static final Validator _validator = new Validator(){

        public IOException validate(Number number) {
            switch (number.intValue()) {
                case 0: 
                case 16: 
                case 17: 
                case 32: 
                case 33: 
                case 48: {
                    return null;
                }
            }
            return new IOException("\"" + number + "\" is not a legal value");
        }
    };

    public Anchors(String value) throws IOException {
        if (value == null) {
            throw new IOException("cannot process a null anchors string");
        }
        char[] input = value.trim().toCharArray();
        int index = 0;
        for (int j = 0; j < 4; ++j) {
            int tailIndex;
            while (index < input.length && Character.isWhitespace(input[index])) {
                ++index;
            }
            if (index == input.length) {
                throw new IOException("insufficient anchors in string");
            }
            for (tailIndex = index; tailIndex < input.length && !Character.isWhitespace(input[tailIndex]); ++tailIndex) {
            }
            this._components[j] = NumericConverter.extractInteger(new String(input, index, tailIndex - index), _validator).intValue();
            index = tailIndex;
        }
        if (new String(input, index, input.length - index).trim().length() != 0) {
            throw new IOException("Too much data in string for 4 anchors");
        }
    }

    public int[] getComponents() {
        return this._components;
    }
}

