/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.elementprocessor.impl.poi.hssf.elements;

import java.io.IOException;
import java.util.Hashtable;
import org.apache.cocoon.components.elementprocessor.ElementProcessor;
import org.apache.cocoon.components.elementprocessor.impl.poi.hssf.elements.BaseElementProcessor;
import org.apache.cocoon.components.elementprocessor.impl.poi.hssf.elements.ColorCode;
import org.apache.cocoon.components.elementprocessor.impl.poi.hssf.elements.EPStyleRegion;
import org.apache.cocoon.components.elementprocessor.impl.poi.hssf.elements.HorizontalAlignment;
import org.apache.cocoon.components.elementprocessor.impl.poi.hssf.elements.StyleOrientation;
import org.apache.cocoon.components.elementprocessor.impl.poi.hssf.elements.StyleShading;
import org.apache.cocoon.components.elementprocessor.impl.poi.hssf.elements.VerticalAlignment;
import org.apache.cocoon.components.elementprocessor.impl.poi.hssf.elements.Workbook;
import org.apache.cocoon.components.elementprocessor.types.Attribute;
import org.apache.cocoon.components.elementprocessor.types.BooleanConverter;
import org.apache.cocoon.components.elementprocessor.types.BooleanResult;
import org.apache.cocoon.components.elementprocessor.types.NumericConverter;
import org.apache.cocoon.components.elementprocessor.types.NumericResult;
import org.apache.cocoon.components.elementprocessor.types.Validator;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFDataFormat;
import org.apache.poi.hssf.util.HSSFColor;

public class EPStyle
extends BaseElementProcessor {
    private static final String _general_format = "General";
    private HorizontalAlignment _h_align = null;
    private VerticalAlignment _v_align = null;
    private BooleanResult _wrap_text = null;
    private StyleOrientation _orient = null;
    private NumericResult _shade = null;
    private NumericResult _indent = null;
    private ColorCode _fore = null;
    private ColorCode _back = null;
    private ColorCode _pattern_color = null;
    private String _format = null;
    private static final String _h_align_attribute = "HAlign";
    private static final String _v_align_attribute = "VAlign";
    private static final String _wrap_text_attribute = "WrapText";
    private static final String _orient_attribute = "Orient";
    private static final String _shade_attribute = "Shade";
    private static final String _indent_attribute = "Indent";
    private static final String _fore_attribute = "Fore";
    private static final String _back_attribute = "Back";
    private static final String _pattern_color_attribute = "PatternColor";
    private static final String _format_attribute = "Format";
    private boolean invalid;
    private static final Validator _shade_validator = new Validator(){

        public IOException validate(Number number) {
            return StyleShading.isValid(number.intValue()) ? null : new IOException("\"" + number + "\" is not a legal value");
        }
    };

    public EPStyle() {
        super(null);
    }

    public void initialize(Attribute[] attributes, ElementProcessor parent) throws IOException {
        super.initialize(attributes, parent);
        EPStyleRegion sregion = (EPStyleRegion)parent;
        if (sregion.isValid()) {
            HSSFColor color;
            Hashtable colorhash = sregion.getColorHash();
            HSSFCellStyle style = sregion.getStyle();
            short cnvhalign = this.convertAlignment(this.getHorizontalAlignment().getCode());
            style.setAlignment(cnvhalign);
            short cnvvalign = this.convertVAlignment(this.getVerticalAlignment().getCode());
            style.setVerticalAlignment(cnvvalign);
            style.setFillPattern((short)this.getShade());
            Workbook workbook = this.getWorkbook();
            HSSFDataFormat dataformat = workbook.createDataFormat();
            if (this.getShade() == 1) {
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug("shade = 1");
                }
                if ((color = (HSSFColor)colorhash.get(this.getBackgroundColor().toString())) == null) {
                    if (this.getLogger().isDebugEnabled()) {
                        this.getLogger().debug("s1 BG couldn't find color for " + this.getBackgroundColor().toString());
                    }
                    color = new HSSFColor.WHITE();
                }
                style.setFillForegroundColor(color.getIndex());
                color = (HSSFColor)colorhash.get(this.getPatternColor().toString());
                if (color == null) {
                    if (this.getLogger().isDebugEnabled()) {
                        this.getLogger().debug("s1 PC couldn't find color for " + this.getPatternColor().toString());
                    }
                    color = new HSSFColor.BLACK();
                }
                style.setFillBackgroundColor(color.getIndex());
            } else {
                color = (HSSFColor)colorhash.get(this.getBackgroundColor().toString());
                if (color == null) {
                    if (this.getLogger().isDebugEnabled()) {
                        this.getLogger().debug("BG couldn't find color for " + this.getBackgroundColor().toString());
                    }
                    color = new HSSFColor.BLACK();
                }
                style.setFillBackgroundColor(color.getIndex());
                color = (HSSFColor)colorhash.get(this.getPatternColor().toString());
                if (color == null) {
                    if (this.getLogger().isDebugEnabled()) {
                        this.getLogger().debug("PC couldn't find color for " + this.getPatternColor().toString());
                    }
                    color = new HSSFColor.WHITE();
                }
                style.setFillForegroundColor(color.getIndex());
            }
            style.setWrapText(this.getWrapText());
            style.setLocked(true);
            String format = null;
            try {
                format = this.getFormat();
            }
            catch (NullPointerException e) {
                format = _general_format;
            }
            if (!_general_format.equals(format)) {
                format = this.kludgeForGnumericMisformats(format);
                format = this.kludgeForGnumericDateDivergence(format);
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug("setting format to " + format);
                }
                Object o = workbook.getValidate(format, dataformat.getFormat(format));
                Short sh = null;
                sh = (Short)o;
                short valuenumber = sh;
                style.setDataFormat(valuenumber);
            }
        } else {
            this.invalid = true;
        }
    }

    public boolean isHorizontalGeneral() throws IOException {
        return this.getHorizontalAlignment().isGeneral();
    }

    public boolean isHorizontalLeft() throws IOException {
        return this.getHorizontalAlignment().isLeft();
    }

    public boolean isHorizontalRight() throws IOException {
        return this.getHorizontalAlignment().isRight();
    }

    public boolean isHorizontalCenter() throws IOException {
        return this.getHorizontalAlignment().isCenter();
    }

    public boolean isHorizontalFill() throws IOException {
        return this.getHorizontalAlignment().isFill();
    }

    public boolean isHorizontalJustify() throws IOException {
        return this.getHorizontalAlignment().isJustify();
    }

    public boolean isHorizontalCenterAcrossSelection() throws IOException {
        return this.getHorizontalAlignment().isCenterAcrossSelection();
    }

    public boolean isVerticalTop() throws IOException {
        return this.getVerticalAlignment().isTop();
    }

    public boolean isVerticalBottom() throws IOException {
        return this.getVerticalAlignment().isBottom();
    }

    public boolean isVerticalCenter() throws IOException {
        return this.getVerticalAlignment().isCenter();
    }

    public boolean isVerticalJustify() throws IOException {
        return this.getVerticalAlignment().isJustify();
    }

    public boolean getWrapText() throws IOException {
        if (this._wrap_text == null) {
            this._wrap_text = BooleanConverter.extractBoolean(this.getValue(_wrap_text_attribute));
        }
        return this._wrap_text.booleanValue();
    }

    public boolean isStyleOrientationHoriz() throws IOException {
        return this.getStyleOrientation().isHoriz();
    }

    public boolean isStyleOrientationVertHorizText() throws IOException {
        return this.getStyleOrientation().isVertHorizText();
    }

    public boolean isStyleOrientationVertVertText() throws IOException {
        return this.getStyleOrientation().isVertVertText();
    }

    public boolean isStyleOrientationVertVertText2() throws IOException {
        return this.getStyleOrientation().isVertVertText2();
    }

    public int getShade() throws IOException {
        if (this._shade == null) {
            this._shade = NumericConverter.extractInteger(this.getValue(_shade_attribute), _shade_validator);
        }
        return this._shade.intValue();
    }

    public int getIndent() throws IOException {
        if (this._indent == null) {
            this._indent = NumericConverter.extractInteger(this.getValue(_indent_attribute));
        }
        return this._indent.intValue();
    }

    public ColorCode getForegroundColor() throws IOException {
        if (this._fore == null) {
            this._fore = new ColorCode(this.getValue(_fore_attribute));
        }
        return this._fore;
    }

    public ColorCode getBackgroundColor() throws IOException {
        if (this._back == null) {
            this._back = new ColorCode(this.getValue(_back_attribute));
        }
        return this._back;
    }

    public ColorCode getPatternColor() throws IOException {
        if (this._pattern_color == null) {
            this._pattern_color = new ColorCode(this.getValue(_pattern_color_attribute));
        }
        return this._pattern_color;
    }

    public String getFormat() throws IOException {
        if (this._format == null) {
            this._format = this.getValue(_format_attribute);
        }
        return this._format;
    }

    private HorizontalAlignment getHorizontalAlignment() throws IOException {
        if (this._h_align == null) {
            this._h_align = new HorizontalAlignment(this.getValue(_h_align_attribute));
        }
        return this._h_align;
    }

    private VerticalAlignment getVerticalAlignment() throws IOException {
        if (this._v_align == null) {
            this._v_align = new VerticalAlignment(this.getValue(_v_align_attribute));
        }
        return this._v_align;
    }

    private StyleOrientation getStyleOrientation() throws IOException {
        if (this._orient == null) {
            this._orient = new StyleOrientation(this.getValue(_orient_attribute));
        }
        return this._orient;
    }

    Hashtable getColorHash() {
        return ((EPStyleRegion)this.getAncestor(EPStyleRegion.class)).getColorHash();
    }

    HSSFCellStyle getStyle() {
        return ((EPStyleRegion)this.getAncestor(EPStyleRegion.class)).getStyle();
    }

    public boolean isValid() {
        return !this.invalid;
    }

    private short convertAlignment(short alignment) {
        short retval = 0;
        switch (alignment) {
            case 1: {
                retval = 0;
                break;
            }
            case 2: {
                retval = 1;
                break;
            }
            case 4: {
                retval = 3;
                break;
            }
            case 8: {
                retval = 2;
                break;
            }
            case 16: {
                retval = 4;
                break;
            }
            case 32: {
                retval = 5;
                break;
            }
            case 64: {
                retval = 6;
                break;
            }
            default: {
                retval = 0;
            }
        }
        return retval;
    }

    private short convertVAlignment(short alignment) {
        short retval = 0;
        switch (alignment) {
            case 1: {
                retval = 0;
                break;
            }
            case 2: {
                retval = 2;
                break;
            }
            case 4: {
                retval = 1;
                break;
            }
            case 8: {
                retval = 3;
                break;
            }
            default: {
                retval = 0;
            }
        }
        return retval;
    }

    private String kludgeForGnumericMisformats(String format) {
        String retval = format;
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("going out of the format kludger " + retval);
            this.getLogger().debug("first )=" + format.indexOf(41));
            this.getLogger().debug("first (=" + format.indexOf(40));
        }
        if (format.indexOf(41) < format.indexOf(40) && format.indexOf(41) != -1) {
            retval = "(" + format;
        }
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("going out of the format kludger " + retval);
        }
        return retval;
    }

    private String kludgeForGnumericDateDivergence(String format) {
        String retval = format;
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("going into the format kludgeForGnumericDateDivergence" + retval);
        }
        if (retval.equals("mm/dd/yy")) {
            retval = "m/d/yy";
        } else if (retval.equals("dd-mmm-yy")) {
            retval = "d-mmm-yy";
        } else if (retval.equals("dd-mmm")) {
            retval = "d-mmm";
        }
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("going out of the format kludgeForGnumericDateDivergence" + retval);
        }
        return retval;
    }
}

