/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import java.io.File;
import java.io.IOException;
import org.hsqldb.Cache;
import org.hsqldb.CacheFree;
import org.hsqldb.CachedRow;
import org.hsqldb.DataFileDefrag;
import org.hsqldb.Database;
import org.hsqldb.HsqlException;
import org.hsqldb.ScaledRAFile;
import org.hsqldb.Table;
import org.hsqldb.Trace;
import org.hsqldb.lib.FileUtil;
import org.hsqldb.lib.HsqlArrayList;
import org.hsqldb.lib.StringUtil;
import org.hsqldb.lib.ZipUnzipFile;

public class DataFileCache
extends Cache {
    private static final int MAX_FREE_COUNT = 1024;

    DataFileCache(String string, Database database) throws HsqlException {
        super(string, database);
    }

    void open(boolean bl) throws HsqlException {
        try {
            boolean bl2;
            boolean bl3 = false;
            File file = new File(this.sName);
            if (file.exists() && file.length() > 16L) {
                bl3 = true;
            }
            int n = (bl2 = this.dDatabase.getProperties().isPropertyTrue("hsqldb.nio_data_file")) ? 1 : 0;
            this.dataFile = ScaledRAFile.newScaledRAFile(this.sName, bl, 1, n);
            if (bl3) {
                this.dataFile.seek(16L);
                this.fileFreePosition = this.dataFile.readInt();
            } else {
                this.fileFreePosition = 32;
                this.dbProps.setProperty("hsqldb.cache_version", "1.7.0");
            }
            String string = this.dbProps.getProperty("hsqldb.cache_version", "1.6.0");
            if (string.equals("1.7.0")) {
                this.cachedRowType = 1;
            }
            this.initBuffers();
            this.fileModified = false;
        }
        catch (Exception exception) {
            throw Trace.error(29, 210, new Object[]{exception, this.sName});
        }
    }

    void close() throws HsqlException {
        if (this.dataFile == null || this.dataFile.isReadOnly()) {
            return;
        }
        try {
            boolean bl;
            this.dataFile.seek(16L);
            this.dataFile.writeInt(this.fileFreePosition);
            this.saveAll();
            this.dataFile.close();
            this.dataFile = null;
            boolean bl2 = bl = this.fileFreePosition == 32;
            if (bl) {
                new File(this.sName).delete();
            }
        }
        catch (Exception exception) {
            throw Trace.error(29, 211, new Object[]{exception, this.sName});
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void defrag() throws HsqlException {
        this.close();
        if (!FileUtil.exists(this.sName)) {
            this.init();
            this.open(this.cacheReadonly);
            Trace.printSystemOut("opened empty chache");
            return;
        }
        HsqlArrayList hsqlArrayList = null;
        try {
            try {
                Object object;
                this.open(true);
                boolean bl = this.dataFile.wasNio();
                DataFileDefrag dataFileDefrag = new DataFileDefrag();
                hsqlArrayList = dataFileDefrag.defrag(this.dDatabase, this.sName);
                this.closeFile();
                Trace.printSystemOut("closed old cache");
                if (bl) {
                    System.gc();
                    FileUtil.renameOverwrite(this.sName, this.sName + ".old");
                    object = new File(this.sName + ".old");
                    ((File)object).delete();
                    FileUtil.deleteOnExit((File)object);
                }
                FileUtil.renameOverwrite(this.sName + ".new", this.sName);
                object = this.dDatabase.getPath() + ".backup";
                this.backup((String)object + ".new");
                FileUtil.renameOverwrite((String)object + ".new", (String)object);
                this.dbProps.setProperty("hsqldb.cache_version", "1.7.0");
                int n = 0;
                while (n < hsqlArrayList.size()) {
                    int[] nArray = (int[])hsqlArrayList.get(n);
                    if (nArray != null) {
                        Trace.printSystemOut(StringUtil.getList(nArray, " ", ""));
                    }
                    ++n;
                }
            }
            catch (Exception exception) {
                throw Trace.error(29, 207, new Object[]{exception, this.sName});
            }
            Object var8_8 = null;
            this.init();
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            this.init();
            this.open(this.cacheReadonly);
            if (hsqlArrayList != null) {
                DataFileDefrag.updateTableIndexRoots(this.dDatabase.getTables(), hsqlArrayList);
            }
            Trace.printSystemOut("opened cache");
            throw throwable;
        }
        this.open(this.cacheReadonly);
        if (hsqlArrayList != null) {
            DataFileDefrag.updateTableIndexRoots(this.dDatabase.getTables(), hsqlArrayList);
        }
        Trace.printSystemOut("opened cache");
    }

    void closeFile() throws HsqlException {
        Trace.printSystemOut("DataFileCache.closeFile()");
        if (this.dataFile == null) {
            return;
        }
        try {
            this.dataFile.close();
            this.dataFile = null;
        }
        catch (Exception exception) {
            throw Trace.error(29, 208, new Object[]{this.sName, exception});
        }
    }

    void free(CachedRow cachedRow) throws HsqlException {
        this.fileModified = true;
        ++this.iFreeCount;
        CacheFree cacheFree = new CacheFree();
        cacheFree.iPos = cachedRow.iPos;
        cacheFree.iLength = cachedRow.storageSize;
        if (this.iFreeCount > 1024) {
            this.iFreeCount = 0;
        } else {
            cacheFree.fNext = this.fRoot;
        }
        this.fRoot = cacheFree;
        cachedRow = this.getRow(cachedRow.iPos);
        if (cachedRow != null) {
            this.remove(cachedRow);
        }
    }

    int setFilePos(CachedRow cachedRow) throws HsqlException {
        int n;
        int n2 = n = cachedRow.storageSize;
        CacheFree cacheFree = this.fRoot;
        CacheFree cacheFree2 = null;
        int n3 = this.fileFreePosition;
        while (cacheFree != null) {
            if (cacheFree.iLength >= n2) {
                n3 = cacheFree.iPos;
                if ((n2 = cacheFree.iLength - n2) < 32) {
                    if (cacheFree2 == null) {
                        this.fRoot = cacheFree.fNext;
                    } else {
                        cacheFree2.fNext = cacheFree.fNext;
                    }
                    --this.iFreeCount;
                    break;
                }
                cacheFree.iLength = n2;
                cacheFree.iPos += n;
                break;
            }
            cacheFree2 = cacheFree;
            cacheFree = cacheFree.fNext;
        }
        if (n3 == this.fileFreePosition) {
            this.fileFreePosition += n2;
        }
        cachedRow.setPos(n3);
        return n3;
    }

    protected CachedRow makeRow(int n, Table table) throws HsqlException {
        CachedRow cachedRow = null;
        ++this.makeRowCount;
        try {
            this.dataFile.seek(n);
            int n2 = this.dataFile.readInt();
            this.rowIn.resetRow(n, n2);
            this.dataFile.read(this.rowIn.getBuffer(), 4, n2 - 4);
            cachedRow = new CachedRow(table, this.rowIn);
        }
        catch (IOException iOException) {
            throw Trace.error(29, 209, new Object[]{iOException, this.sName});
        }
        return cachedRow;
    }

    protected void saveRow(CachedRow cachedRow) throws IOException, HsqlException {
        this.rowOut.reset();
        this.dataFile.seek(cachedRow.iPos);
        cachedRow.write(this.rowOut);
        this.dataFile.write(this.rowOut.getOutputStream().getBuffer(), 0, this.rowOut.getOutputStream().size());
    }

    void backup(String string) throws HsqlException {
        try {
            ZipUnzipFile.compressFile(this.sName, string);
        }
        catch (Exception exception) {
            throw Trace.error(29, 166 + string);
        }
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static void resetFreePos(String string) {
        ScaledRAFile scaledRAFile = null;
        scaledRAFile = ScaledRAFile.newScaledRAFile(string, false, 1, 0);
        scaledRAFile.seek(16L);
        scaledRAFile.writeInt(32);
        Object var4_2 = null;
        if (scaledRAFile == null) return;
        try {
            scaledRAFile.close();
            return;
        }
        catch (IOException iOException) {}
        return;
        {
            catch (IOException iOException) {
                Object var4_3 = null;
                if (scaledRAFile == null) return;
                try {
                    scaledRAFile.close();
                    return;
                }
                catch (IOException iOException2) {}
                return;
            }
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (scaledRAFile == null) throw throwable;
            try {
                scaledRAFile.close();
                throw throwable;
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw throwable;
        }
    }

    protected void setStorageSize(CachedRow cachedRow) throws HsqlException {
        Table table = cachedRow.getTable();
        int n = this.rowStoreExtra + 16 * table.getIndexCount();
        n += this.rowOut.getSize(cachedRow);
        cachedRow.storageSize = n = (n + this.cachedRowPadding - 1) / this.cachedRowPadding * this.cachedRowPadding;
    }

    int getCachedCount() {
        return this.iCacheSize;
    }
}

