/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import java.sql.Time;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import org.hsqldb.HsqlException;
import org.hsqldb.Trace;

public class HsqlDateTime {
    private static Calendar today = new GregorianCalendar();
    private static Calendar tempCalDefault = new GregorianCalendar();
    private static Calendar tempCalGMT = new GregorianCalendar(TimeZone.getTimeZone("GMT"));
    private static java.sql.Date tempDate = new java.sql.Date(0L);
    private static java.sql.Date currentDate;
    static final String zerodatetime = "1970-01-01 00:00:00.000000000";
    private static final String sdftPattern = "HH:mm:ss";
    private static final String sdfdPattern = "yyyy-MM-dd";
    private static final String sdftsPattern = "yyyy-MM-dd HH:mm:ss.";
    static SimpleDateFormat sdfd;
    static SimpleDateFormat sdft;
    static SimpleDateFormat sdfts;

    public static Timestamp timestampValue(String string) {
        if (string == null) {
            throw new IllegalArgumentException(Trace.getMessage(131));
        }
        string = string + zerodatetime.substring(string.length());
        return Timestamp.valueOf(string);
    }

    public static Timestamp simpleTimestampValue(String string) {
        return Timestamp.valueOf(string);
    }

    public static Timestamp timestampValue(long l, int n) {
        Timestamp timestamp = new Timestamp(l);
        timestamp.setNanos(n);
        return timestamp;
    }

    public static java.sql.Date dateValue(String string) {
        if (string == null) {
            throw new IllegalArgumentException(Trace.getMessage(133));
        }
        if (string.length() > sdfdPattern.length()) {
            return java.sql.Date.valueOf(string.substring(0, sdfdPattern.length()));
        }
        return java.sql.Date.valueOf(string);
    }

    public static Time timeValue(String string) {
        if (string == null) {
            throw new IllegalArgumentException(Trace.getMessage(131));
        }
        return Time.valueOf(string);
    }

    static int compare(Time time, Time time2) throws HsqlException {
        if (time.getTime() == time2.getTime()) {
            return 0;
        }
        return time.getTime() > time2.getTime() ? 1 : -1;
    }

    public static synchronized java.sql.Date getCurrentDate(long l) {
        HsqlDateTime.getToday(l);
        return currentDate;
    }

    public static Timestamp getTimestamp(long l) {
        return new Timestamp(l);
    }

    static java.sql.Date getDate(String string, Calendar calendar) throws Exception {
        SimpleDateFormat simpleDateFormat = sdfd;
        synchronized (simpleDateFormat) {
            sdfd.setCalendar(calendar);
            Date date = sdfd.parse(string);
            java.sql.Date date2 = new java.sql.Date(date.getTime());
            return date2;
        }
    }

    static Time getTime(String string, Calendar calendar) throws Exception {
        SimpleDateFormat simpleDateFormat = sdft;
        synchronized (simpleDateFormat) {
            sdft.setCalendar(calendar);
            Date date = sdft.parse(string);
            Time time = new Time(date.getTime());
            return time;
        }
    }

    static Timestamp getTimestamp(String string, Calendar calendar) throws Exception {
        SimpleDateFormat simpleDateFormat = sdfts;
        synchronized (simpleDateFormat) {
            sdfts.setCalendar(calendar);
            Date date = sdfts.parse(string.substring(0, sdftsPattern.length()));
            String string2 = string.substring(sdftsPattern.length(), string.length());
            Timestamp timestamp = new Timestamp(date.getTime());
            timestamp.setNanos(Integer.parseInt(string2));
            Timestamp timestamp2 = timestamp;
            return timestamp2;
        }
    }

    public static String getTimestampString(Timestamp timestamp, Calendar calendar) throws Exception {
        SimpleDateFormat simpleDateFormat = sdfts;
        synchronized (simpleDateFormat) {
            sdfts.setCalendar(calendar == null ? tempCalDefault : calendar);
            String string = sdfts.format(new Date(((Date)timestamp).getTime())) + timestamp.getNanos();
            String string2 = string + zerodatetime.substring(string.length());
            return string2;
        }
    }

    public static String getTimeString(Time time, Calendar calendar) throws Exception {
        SimpleDateFormat simpleDateFormat = sdft;
        synchronized (simpleDateFormat) {
            sdft.setCalendar(calendar == null ? tempCalDefault : calendar);
            String string = sdft.format(time);
            return string;
        }
    }

    public static String getDateString(java.sql.Date date, Calendar calendar) throws Exception {
        SimpleDateFormat simpleDateFormat = sdfd;
        synchronized (simpleDateFormat) {
            sdfd.setCalendar(calendar == null ? tempCalDefault : calendar);
            String string = sdfd.format(date);
            return string;
        }
    }

    static synchronized Calendar getToday(long l) {
        if (l - HsqlDateTime.getTimeInMillis(today) >= 86400000L) {
            HsqlDateTime.resetToday(l);
        }
        return today;
    }

    public static void resetToDate(Calendar calendar) {
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
    }

    public static void resetToTime(Calendar calendar) {
        calendar.set(1, 1970);
        calendar.set(2, 0);
        calendar.set(5, 1);
        calendar.set(14, 0);
    }

    private static synchronized void resetToday(long l) {
        tempDate.setTime(l);
        today.setTime(tempDate);
        HsqlDateTime.resetToDate(today);
        currentDate = new java.sql.Date(HsqlDateTime.getTimeInMillis(today));
    }

    private static void setTimeInMillis(Calendar calendar, long l) {
        java.sql.Date date = tempDate;
        synchronized (date) {
            tempDate.setTime(l);
            calendar.setTime(tempDate);
        }
    }

    public static long getTimeInMillis(Calendar calendar) {
        return calendar.getTime().getTime();
    }

    public static Time getNormalisedTime(long l) {
        Calendar calendar = tempCalDefault;
        synchronized (calendar) {
            HsqlDateTime.setTimeInMillis(tempCalDefault, l);
            HsqlDateTime.resetToTime(tempCalDefault);
            long l2 = HsqlDateTime.getTimeInMillis(tempCalDefault);
            Time time = new Time(l2);
            return time;
        }
    }

    public static Time getNormalisedTime(Time time) {
        return HsqlDateTime.getNormalisedTime(time.getTime());
    }

    public static Time getNormalisedTime(Timestamp timestamp) {
        return HsqlDateTime.getNormalisedTime(((Date)timestamp).getTime());
    }

    public static long getNormalisedDate(long l) {
        Calendar calendar = tempCalDefault;
        synchronized (calendar) {
            HsqlDateTime.setTimeInMillis(tempCalDefault, l);
            HsqlDateTime.resetToDate(tempCalDefault);
            long l2 = HsqlDateTime.getTimeInMillis(tempCalDefault);
            return l2;
        }
    }

    public static java.sql.Date getNormalisedDate(Timestamp timestamp) {
        Calendar calendar = tempCalDefault;
        synchronized (calendar) {
            HsqlDateTime.setTimeInMillis(tempCalDefault, ((Date)timestamp).getTime());
            HsqlDateTime.resetToDate(tempCalDefault);
            long l = HsqlDateTime.getTimeInMillis(tempCalDefault);
            java.sql.Date date = new java.sql.Date(l);
            return date;
        }
    }

    public static java.sql.Date getNormalisedDate(java.sql.Date date) {
        Calendar calendar = tempCalDefault;
        synchronized (calendar) {
            HsqlDateTime.setTimeInMillis(tempCalDefault, date.getTime());
            HsqlDateTime.resetToDate(tempCalDefault);
            long l = HsqlDateTime.getTimeInMillis(tempCalDefault);
            java.sql.Date date2 = new java.sql.Date(l);
            return date2;
        }
    }

    public static Timestamp getNormalisedTimestamp(Time time) {
        Calendar calendar = tempCalGMT;
        synchronized (calendar) {
            HsqlDateTime.setTimeInMillis(tempCalGMT, System.currentTimeMillis());
            HsqlDateTime.resetToDate(tempCalGMT);
            long l = HsqlDateTime.getTimeInMillis(tempCalGMT) + time.getTime();
            Timestamp timestamp = new Timestamp(l);
            return timestamp;
        }
    }

    public static Timestamp getNormalisedTimestamp(java.sql.Date date) {
        Calendar calendar = tempCalDefault;
        synchronized (calendar) {
            HsqlDateTime.setTimeInMillis(tempCalDefault, date.getTime());
            HsqlDateTime.resetToDate(tempCalDefault);
            long l = HsqlDateTime.getTimeInMillis(tempCalDefault);
            Timestamp timestamp = new Timestamp(l);
            return timestamp;
        }
    }

    static int getDateTimePart(Date date, int n) {
        Calendar calendar = tempCalDefault;
        synchronized (calendar) {
            tempCalDefault.setTime(date);
            int n2 = tempCalDefault.get(n);
            return n2;
        }
    }

    static {
        HsqlDateTime.resetToday(System.currentTimeMillis());
        sdfd = new SimpleDateFormat(sdfdPattern);
        sdft = new SimpleDateFormat(sdftPattern);
        sdfts = new SimpleDateFormat(sdftsPattern);
    }
}

