/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.CachedDataRow;
import org.hsqldb.CachedRow;
import org.hsqldb.HsqlException;
import org.hsqldb.Node;
import org.hsqldb.Record;
import org.hsqldb.Table;

public class Row {
    protected Object[] oData;
    protected Node nPrimaryNode;

    static Row newRow(Table table, Object[] objectArray) throws HsqlException {
        if (table.isText()) {
            return new CachedDataRow(table, objectArray);
        }
        if (table.isCached()) {
            return new CachedRow(table, objectArray);
        }
        return new Row(table, objectArray);
    }

    Row() {
    }

    Row(Table table, Object[] objectArray) throws HsqlException {
        int n = table.getIndexCount();
        Node node = this.nPrimaryNode = Node.newNode(this, 0, table);
        int n2 = 1;
        while (n2 < n) {
            node = node.nNext = Node.newNode(this, n2, table);
            ++n2;
        }
        this.oData = objectArray;
        table.addRowToStore(this);
    }

    Node getNode(int n) {
        Node node = this.nPrimaryNode;
        while (n-- > 0) {
            node = node.nNext;
        }
        return node;
    }

    Node getNextNode(Node node) {
        node = node == null ? this.nPrimaryNode : node.nNext;
        return node;
    }

    public Object[] getData() {
        return this.oData;
    }

    Row getUpdatedRow() throws HsqlException {
        return this;
    }

    void delete() throws HsqlException {
        ++Record.memoryRecords;
        this.nPrimaryNode = null;
    }

    boolean isDeleted() {
        return this.nPrimaryNode == null;
    }
}

