/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.HsqlException;
import org.hsqldb.HsqlNameManager;
import org.hsqldb.Logger;
import org.hsqldb.NumberSequence;
import org.hsqldb.Session;
import org.hsqldb.Trace;
import org.hsqldb.lib.HashMappedList;

class SequenceManager {
    HashMappedList sequenceMap = new HashMappedList();

    SequenceManager() {
    }

    void dropSequence(String string) throws HsqlException {
        boolean bl = this.sequenceMap.containsKey(string);
        Trace.check(bl, 191, string);
        this.sequenceMap.remove(string);
    }

    NumberSequence getSequence(String string) {
        return (NumberSequence)this.sequenceMap.get(string);
    }

    NumberSequence createSequence(HsqlNameManager.HsqlName hsqlName, long l, long l2, int n) throws HsqlException {
        Trace.check(!this.sequenceMap.containsKey(hsqlName.name), 192);
        NumberSequence numberSequence = new NumberSequence(hsqlName, l, l2, n);
        this.sequenceMap.put(hsqlName.name, numberSequence);
        return numberSequence;
    }

    String logSequences(Session session, Logger logger) throws HsqlException {
        int n = 0;
        while (n < this.sequenceMap.size()) {
            NumberSequence numberSequence = (NumberSequence)this.sequenceMap.get(n);
            if (numberSequence.wasUsed()) {
                logger.writeSequenceStatement(session, numberSequence);
                numberSequence.resetWasUsed();
            }
            ++n;
        }
        return null;
    }
}

