/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.Column;
import org.hsqldb.Constraint;
import org.hsqldb.Expression;
import org.hsqldb.HsqlException;
import org.hsqldb.HsqlNameManager;
import org.hsqldb.Index;
import org.hsqldb.Result;
import org.hsqldb.Select;
import org.hsqldb.Session;
import org.hsqldb.Table;
import org.hsqldb.Trace;
import org.hsqldb.lib.ArrayUtil;
import org.hsqldb.lib.HashSet;

class TableWorks {
    private Table table;
    private Session session;

    TableWorks(Session session, Table table) {
        this.table = table;
        this.session = session;
    }

    Table getTable() {
        return this.table;
    }

    void createForeignKey(int[] nArray, int[] nArray2, HsqlNameManager.HsqlName hsqlName, Table table, int n, int n2) throws HsqlException {
        if (this.table.database.constraintNameList.containsName(hsqlName.name)) {
            throw Trace.error(60, hsqlName.name);
        }
        if (this.table.getConstraint(hsqlName.name) != null) {
            throw Trace.error(60);
        }
        if (this.table.getConstraintForColumns(table, nArray2, nArray) != null) {
            throw Trace.error(60);
        }
        if (table.isTemp() != this.table.isTemp()) {
            throw Trace.error(47);
        }
        boolean bl = this.table == table;
        boolean bl2 = this.table.database.getTableIndex(this.table) < this.table.database.getTableIndex(table);
        Index index = table.getConstraintIndexForColumns(nArray2);
        if (index == null) {
            throw Trace.error(170, table.getName().statementName);
        }
        Constraint.checkReferencedRows(this.table, nArray, index);
        HsqlNameManager.HsqlName hsqlName2 = this.table.database.nameManager.newAutoName("IDX");
        Index index2 = this.createIndex(nArray, hsqlName2, false, true, bl2);
        HsqlNameManager.HsqlName hsqlName3 = this.table.database.nameManager.newAutoName("REF", hsqlName.name);
        if (bl) {
            table = this.table;
        }
        Constraint constraint = new Constraint(hsqlName3, hsqlName, table, this.table, nArray2, nArray, index, index2, n, n2);
        this.table.addConstraint(constraint);
        table.addConstraint(new Constraint(hsqlName3, constraint));
        this.table.database.constraintNameList.addName(hsqlName.name, this.table.getName(), 60);
    }

    Index createIndex(int[] nArray, HsqlNameManager.HsqlName hsqlName, boolean bl, boolean bl2, boolean bl3) throws HsqlException {
        Index index;
        if (this.table.isEmpty() || this.table.isIndexingMutable()) {
            index = this.table.createIndex(nArray, hsqlName, bl, bl2, bl3);
        } else {
            Table table = this.table.moveDefinition(null, null, this.table.getColumnCount(), 0);
            index = table.createIndexStructure(nArray, hsqlName, false, bl, bl2, bl3);
            table.moveData(this.session, this.table, this.table.getColumnCount(), 0);
            table.updateConstraintsTables(this.table, this.table.getColumnCount(), 0);
            int n = this.table.database.getTableIndex(this.table);
            this.table.database.getTables().set(n, table);
            this.table = table;
        }
        this.table.database.indexNameList.addName(index.getName().name, this.table.getName(), 23);
        this.table.database.recompileViews(this.table.getName().name);
        return index;
    }

    void createUniqueConstraint(int[] nArray, HsqlNameManager.HsqlName hsqlName) throws HsqlException {
        Object object;
        if (this.table.database.constraintNameList.containsName(hsqlName.name)) {
            throw Trace.error(60, hsqlName.name);
        }
        Constraint[] constraintArray = this.table.getConstraints();
        int n = 0;
        int n2 = constraintArray.length;
        while (n < n2) {
            object = constraintArray[n];
            if (((Constraint)object).isEquivalent(nArray, 2) || ((Constraint)object).getName().name.equals(hsqlName.name)) {
                throw Trace.error(60);
            }
            ++n;
        }
        object = this.table.database.nameManager.newAutoName("IDX", hsqlName.name);
        Index index = this.createIndex(nArray, (HsqlNameManager.HsqlName)object, true, true, false);
        Constraint constraint = new Constraint(hsqlName, this.table, index);
        this.table.addConstraint(constraint);
        this.table.database.constraintNameList.addName(hsqlName.name, this.table.getName(), 60);
    }

    void createCheckConstraint(Constraint constraint, HsqlNameManager.HsqlName hsqlName) throws HsqlException {
        if (this.table.database.constraintNameList.containsName(hsqlName.name)) {
            throw Trace.error(60, hsqlName.name);
        }
        Expression expression = constraint.core.check;
        expression.setLikeOptimised();
        Select select = Expression.getCheckSelect(this.table, expression);
        Result result = select.getResult(this.table.database.getSessionManager().getSysSession(), 1);
        constraint.core.checkFilter = select.tFilter[0];
        constraint.core.mainTable = this.table;
        if (result.getSize() != 0) {
            throw Trace.error(157);
        }
        expression.getDDL();
        constraint.core.checkFilter.setAsCheckFilter();
        this.table.addConstraint(constraint);
        this.table.database.constraintNameList.addName(hsqlName.name, this.table.getName(), 60);
    }

    void dropIndex(String string) throws HsqlException {
        if (this.table.isIndexingMutable()) {
            this.table.dropIndex(string);
        } else {
            Table table = this.table.moveDefinition(string, null, this.table.getColumnCount(), 0);
            table.moveData(this.session, this.table, this.table.getColumnCount(), 0);
            table.updateConstraintsTables(this.table, this.table.getColumnCount(), 0);
            int n = this.table.database.getTableIndex(this.table);
            this.table.database.getTables().set(n, table);
            this.table = table;
        }
        this.table.database.indexNameList.removeName(string);
        this.table.database.recompileViews(this.table.getName().name);
    }

    void addOrDropColumn(Column column, int n, int n2) throws HsqlException {
        if (this.table.isText()) {
            throw Trace.error(73);
        }
        if (n2 == -1) {
            this.table.database.checkColumnIsInView(this.table.getName().name, this.table.getColumn((int)n).columnName.name);
            this.table.checkColumnInCheckConstraint(this.table.getColumn((int)n).columnName.name);
        }
        Table table = this.table.moveDefinition(null, column, n, n2);
        table.moveData(this.session, this.table, n, n2);
        table.updateConstraintsTables(this.table, n, n2);
        int n3 = this.table.database.getTableIndex(this.table);
        this.table.database.getTables().set(n3, table);
        this.table = table;
        this.table.database.recompileViews(this.table.getName().name);
    }

    void dropConstraint(String string) throws HsqlException {
        int n = this.table.getConstraintIndex(string);
        Constraint constraint = this.table.getConstraint(string);
        if (constraint == null) {
            throw Trace.error(61, 171, new Object[]{string, this.table.getName().name});
        }
        if (constraint.getType() == 1) {
            throw Trace.error(59);
        }
        if (constraint.getType() == 0) {
            Table table = constraint.getMain();
            int n2 = table.getConstraintIndex(constraint.getPkName());
            Index index = constraint.getRefIndex();
            this.dropIndex(index.getName().name);
            table.constraintList = (Constraint[])ArrayUtil.toAdjustedArray(table.constraintList, null, n2, -1);
            this.table.constraintList = (Constraint[])ArrayUtil.toAdjustedArray(this.table.constraintList, null, n, -1);
        } else if (constraint.getType() == 2) {
            HashSet hashSet = new HashSet();
            hashSet.add(constraint);
            this.table.checkDropIndex(constraint.getMainIndex().getName().name, hashSet);
            this.dropIndex(constraint.getMainIndex().getName().name);
            this.table.constraintList = (Constraint[])ArrayUtil.toAdjustedArray(this.table.constraintList, null, n, -1);
        } else if (constraint.getType() == 3) {
            this.table.constraintList = (Constraint[])ArrayUtil.toAdjustedArray(this.table.constraintList, null, n, -1);
        }
        this.table.database.constraintNameList.removeName(string);
    }
}

