/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.scriptio;

import java.io.IOException;
import java.io.InputStream;
import org.hsqldb.Database;
import org.hsqldb.HsqlException;
import org.hsqldb.Result;
import org.hsqldb.Session;
import org.hsqldb.Table;
import org.hsqldb.Trace;
import org.hsqldb.lib.InOutUtil;
import org.hsqldb.lib.Iterator;
import org.hsqldb.rowio.RowInputBase;
import org.hsqldb.rowio.RowInputBinary;
import org.hsqldb.scriptio.ScriptReaderBase;

class ScriptReaderBinary
extends ScriptReaderBase {
    RowInputBinary rowIn = new RowInputBinary();

    ScriptReaderBinary(Database database, String string) throws HsqlException, IOException {
        super(database, string);
    }

    protected void readDDL(Session session) throws IOException, HsqlException {
        this.readSingleColumnResult(session);
    }

    protected void readSingleColumnResult(Session session) throws IOException, HsqlException {
        Result result = Result.read(this.rowIn, this.dataStreamIn);
        Iterator iterator = result.iterator();
        while (iterator.hasNext()) {
            Object[] objectArray = (Object[])iterator.next();
            String string = (String)objectArray[0];
            session.sqlExecuteDirectNoPreChecks(string);
        }
    }

    protected void readExistingData(Session session) throws IOException, HsqlException {
        String string;
        while ((string = this.readTableInit()) != null) {
            Table table = this.db.getTable(session, string);
            int n = 0;
            n = 0;
            while (this.readRow(table)) {
                ++n;
            }
            int n2 = this.readTableTerm();
            if (n == n2) continue;
            throw Trace.error(78, 96, new Object[]{string, new Integer(n), new Integer(n2)});
        }
    }

    public String readLoggedStatement() throws IOException {
        return null;
    }

    protected boolean readRow(Table table) throws IOException, HsqlException {
        boolean bl = this.readRow(this.rowIn, 0, this.dataStreamIn);
        if (!bl) {
            return false;
        }
        Object[] objectArray = this.rowIn.readData(table.getColumnTypes(), table.getColumnCount());
        table.insertFromScript(objectArray);
        return true;
    }

    protected int readTableTerm() throws IOException, HsqlException {
        return InOutUtil.readInt(this.dataStreamIn);
    }

    protected String readTableInit() throws IOException, HsqlException {
        boolean bl = this.readRow(this.rowIn, 0, this.dataStreamIn);
        if (!bl) {
            return null;
        }
        String string = this.rowIn.readString();
        int n = this.rowIn.readIntData();
        if (n != 0) {
            throw Trace.error(78, 97);
        }
        return string;
    }

    boolean readRow(RowInputBase rowInputBase, int n, InputStream inputStream) throws IOException {
        int n2 = InOutUtil.readInt(inputStream);
        int n3 = 4;
        if (n2 == 0) {
            return false;
        }
        rowInputBase.resetRow(n, n2);
        while (n3 < n2) {
            int n4 = this.dataStreamIn.read(rowInputBase.getBuffer(), n3, n2 - n3);
            if (n4 == -1) {
                throw new IOException();
            }
            n3 += n4;
        }
        return true;
    }
}

