/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.store;

import java.math.BigDecimal;
import java.sql.Date;
import org.hsqldb.store.ValuePoolHashMap;

public class ValuePool {
    static ValuePoolHashMap intPool;
    static ValuePoolHashMap longPool;
    static ValuePoolHashMap doublePool;
    static ValuePoolHashMap bigdecimalPool;
    static ValuePoolHashMap stringPool;
    static ValuePoolHashMap datePool;
    static final int DEFAULT_VALUE_POOL_SIZE = 10000;
    static final int[] defaultPoolLookupSize;
    static final int defaultSizeFactor = 2;
    static final int defaultMaxStringLength = 16;
    static ValuePoolHashMap[] poolList;
    static int maxStringLength;
    static /* synthetic */ Class class$org$hsqldb$store$ValuePool;

    private static void initPool() {
        int[] nArray = defaultPoolLookupSize;
        int n = 2;
        Class clazz = class$org$hsqldb$store$ValuePool == null ? (class$org$hsqldb$store$ValuePool = ValuePool.class$("org.hsqldb.store.ValuePool")) : class$org$hsqldb$store$ValuePool;
        synchronized (clazz) {
            maxStringLength = 16;
            poolList = new ValuePoolHashMap[6];
            int n2 = 0;
            while (n2 < poolList.length) {
                int n3 = nArray[n2];
                ValuePool.poolList[n2] = new ValuePoolHashMap(n3, n3 * n, 2);
                ++n2;
            }
            intPool = poolList[0];
            longPool = poolList[1];
            doublePool = poolList[2];
            bigdecimalPool = poolList[3];
            stringPool = poolList[4];
            datePool = poolList[5];
        }
    }

    public static void resetPool(int[] nArray, int n) {
        Class clazz = class$org$hsqldb$store$ValuePool == null ? (class$org$hsqldb$store$ValuePool = ValuePool.class$("org.hsqldb.store.ValuePool")) : class$org$hsqldb$store$ValuePool;
        synchronized (clazz) {
            int n2 = 0;
            while (n2 < poolList.length) {
                poolList[n2].resetCapacity(nArray[n2] * n, 2);
                ++n2;
            }
        }
    }

    public static void resetPool() {
        Class clazz = class$org$hsqldb$store$ValuePool == null ? (class$org$hsqldb$store$ValuePool = ValuePool.class$("org.hsqldb.store.ValuePool")) : class$org$hsqldb$store$ValuePool;
        synchronized (clazz) {
            ValuePool.resetPool(defaultPoolLookupSize, 2);
        }
    }

    public static void clearPool() {
        Class clazz = class$org$hsqldb$store$ValuePool == null ? (class$org$hsqldb$store$ValuePool = ValuePool.class$("org.hsqldb.store.ValuePool")) : class$org$hsqldb$store$ValuePool;
        synchronized (clazz) {
            int n = 0;
            while (n < poolList.length) {
                poolList[n].clear();
                ++n;
            }
        }
    }

    public static Integer getInt(int n) {
        ValuePoolHashMap valuePoolHashMap = intPool;
        synchronized (valuePoolHashMap) {
            Integer n2 = intPool.getOrAddInteger(n);
            return n2;
        }
    }

    public static Long getLong(long l) {
        ValuePoolHashMap valuePoolHashMap = longPool;
        synchronized (valuePoolHashMap) {
            Long l2 = longPool.getOrAddLong(l);
            return l2;
        }
    }

    public static Double getDouble(long l) {
        ValuePoolHashMap valuePoolHashMap = doublePool;
        synchronized (valuePoolHashMap) {
            Double d = doublePool.getOrAddDouble(l);
            return d;
        }
    }

    public static String getString(String string) {
        if (string == null || string.length() > maxStringLength) {
            return string;
        }
        ValuePoolHashMap valuePoolHashMap = stringPool;
        synchronized (valuePoolHashMap) {
            String string2 = stringPool.getOrAddString(string);
            return string2;
        }
    }

    public static Date getDate(long l) {
        ValuePoolHashMap valuePoolHashMap = datePool;
        synchronized (valuePoolHashMap) {
            Date date = datePool.getOrAddDate(l);
            return date;
        }
    }

    public static BigDecimal getBigDecimal(BigDecimal bigDecimal) {
        if (bigDecimal == null) {
            return bigDecimal;
        }
        ValuePoolHashMap valuePoolHashMap = bigdecimalPool;
        synchronized (valuePoolHashMap) {
            BigDecimal bigDecimal2 = (BigDecimal)bigdecimalPool.getOrAddObject(bigDecimal);
            return bigDecimal2;
        }
    }

    public static Boolean getBoolean(boolean bl) {
        return bl ? Boolean.TRUE : Boolean.FALSE;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        defaultPoolLookupSize = new int[]{10000, 10000, 10000, 10000, 10000, 10000};
        ValuePool.initPool();
    }

    public static class poolSettings {
        String[] propertyStrings = new String[]{"runtime.pool.int_size", "runtime.pool.long_size", "runtime.pool.double_size", "runtime.pool.decimal_size", "runtime.pool.string_size", "runtime.pool.date_size", "runtime.pool.factor", "runtime.pool.string_length"};
        static final int[] defaultPoolLookupSize = new int[]{1000, 1000, 1000, 1000, 1000, 1000};
    }
}

