/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang.time;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.time.Token;

public class DurationFormatUtils {
    public static final String ISO_EXTENDED_FORMAT_PATTERN = "'P'yyyy'Y'M'M'd'DT'H'H'm'M's.S'S'";
    static final Object y = "y";
    static final Object M = "M";
    static final Object d = "d";
    static final Object H = "H";
    static final Object m = "m";
    static final Object s = "s";
    static final Object S = "S";

    public static String formatISO(long millis) {
        return DurationFormatUtils.format(millis, "H:mm:ss.SSS");
    }

    public static String format(long millis) {
        return DurationFormatUtils.format(millis, ISO_EXTENDED_FORMAT_PATTERN, false, TimeZone.getDefault());
    }

    public static String format(long startMillis, long endMillis) {
        return DurationFormatUtils.format(startMillis, endMillis, ISO_EXTENDED_FORMAT_PATTERN, false, TimeZone.getDefault());
    }

    public static String format(long millis, String format) {
        return DurationFormatUtils.format(millis, format, true, TimeZone.getDefault());
    }

    public static String format(long millis, String format, boolean padWithZeros, TimeZone timezone) {
        if (millis >= 2419200000L) {
            Calendar c = Calendar.getInstance(timezone);
            c.set(1970, 0, 1, 0, 0, 0);
            c.set(14, 0);
            return DurationFormatUtils.format(c.getTime().getTime(), millis, format, padWithZeros, timezone);
        }
        Token[] tokens = DurationFormatUtils.lexx(format);
        int years = 0;
        int months = 0;
        int days = 0;
        int hours = 0;
        int minutes = 0;
        int seconds = 0;
        int milliseconds = 0;
        if (Token.containsTokenWithValue(tokens, d)) {
            days = (int)(millis / 86400000L);
            millis -= (long)days * 86400000L;
        }
        if (Token.containsTokenWithValue(tokens, H)) {
            hours = (int)(millis / 3600000L);
            millis -= (long)hours * 3600000L;
        }
        if (Token.containsTokenWithValue(tokens, m)) {
            minutes = (int)(millis / 60000L);
            millis -= (long)minutes * 60000L;
        }
        if (Token.containsTokenWithValue(tokens, s)) {
            seconds = (int)(millis / 1000L);
            millis -= (long)seconds * 1000L;
        }
        if (Token.containsTokenWithValue(tokens, S)) {
            milliseconds = (int)millis;
        }
        return DurationFormatUtils.formatDuration(tokens, years, months, days, hours, minutes, seconds, milliseconds, padWithZeros);
    }

    static String formatDuration(Token[] tokens, int years, int months, int days, int hours, int minutes, int seconds, int milliseconds, boolean padWithZeros) {
        StringBuffer buffer = new StringBuffer();
        int sz = tokens.length;
        for (int i = 0; i < sz; ++i) {
            Token token = tokens[i];
            Object value = token.getValue();
            int count = token.getCount();
            if (value instanceof StringBuffer) {
                buffer.append(value.toString());
                continue;
            }
            if (value == y) {
                buffer.append(padWithZeros ? StringUtils.leftPad("" + years, count, "0") : "" + years);
                continue;
            }
            if (value == M) {
                buffer.append(padWithZeros ? StringUtils.leftPad("" + months, count, "0") : "" + months);
                continue;
            }
            if (value == d) {
                buffer.append(padWithZeros ? StringUtils.leftPad("" + days, count, "0") : "" + days);
                continue;
            }
            if (value == H) {
                buffer.append(padWithZeros ? StringUtils.leftPad("" + hours, count, "0") : "" + hours);
                continue;
            }
            if (value == m) {
                buffer.append(padWithZeros ? StringUtils.leftPad("" + minutes, count, "0") : "" + minutes);
                continue;
            }
            if (value == s) {
                buffer.append(padWithZeros ? StringUtils.leftPad("" + seconds, count, "0") : "" + seconds);
                continue;
            }
            if (value != S) continue;
            buffer.append(padWithZeros ? StringUtils.leftPad("" + milliseconds, count, "0") : "" + milliseconds);
        }
        return buffer.toString();
    }

    public static String format(long startMillis, long endMillis, String format) {
        return DurationFormatUtils.format(startMillis, endMillis, format, true, TimeZone.getDefault());
    }

    public static String format(long startMillis, long endMillis, String format, boolean padWithZeros, TimeZone timezone) {
        long millis = endMillis - startMillis;
        if (millis < 2419200000L) {
            return DurationFormatUtils.format(millis, format, padWithZeros, timezone);
        }
        Token[] tokens = DurationFormatUtils.lexx(format);
        Calendar start = Calendar.getInstance(timezone);
        start.setTime(new Date(startMillis));
        Calendar end = Calendar.getInstance(timezone);
        end.setTime(new Date(endMillis));
        int years = end.get(1) - start.get(1);
        int months = end.get(2) - start.get(2);
        while (months < 0) {
            months += 12;
            --years;
        }
        int days = end.get(5) - start.get(5);
        while (days < 0) {
            days += 31;
            --months;
        }
        int hours = end.get(11) - start.get(11);
        while (hours < 0) {
            hours += 24;
            --days;
        }
        int minutes = end.get(12) - start.get(12);
        while (minutes < 0) {
            minutes += 60;
            --hours;
        }
        int seconds = end.get(13) - start.get(13);
        while (seconds < 0) {
            seconds += 60;
            --minutes;
        }
        int milliseconds = end.get(14) - start.get(14);
        while (milliseconds < 0) {
            milliseconds += 1000;
            --seconds;
        }
        milliseconds -= DurationFormatUtils.reduceAndCorrect(start, end, 14, milliseconds);
        seconds -= DurationFormatUtils.reduceAndCorrect(start, end, 13, seconds);
        minutes -= DurationFormatUtils.reduceAndCorrect(start, end, 12, minutes);
        hours -= DurationFormatUtils.reduceAndCorrect(start, end, 11, hours);
        days -= DurationFormatUtils.reduceAndCorrect(start, end, 5, days);
        months -= DurationFormatUtils.reduceAndCorrect(start, end, 2, months);
        years -= DurationFormatUtils.reduceAndCorrect(start, end, 1, years);
        if (!Token.containsTokenWithValue(tokens, y)) {
            if (Token.containsTokenWithValue(tokens, M)) {
                months += 12 * years;
                years = 0;
            } else {
                days += 365 * years;
                years = 0;
            }
        }
        if (!Token.containsTokenWithValue(tokens, M)) {
            days += end.get(6) - start.get(6);
            months = 0;
        }
        if (!Token.containsTokenWithValue(tokens, d)) {
            hours += 24 * days;
            days = 0;
        }
        if (!Token.containsTokenWithValue(tokens, H)) {
            minutes += 60 * hours;
            hours = 0;
        }
        if (!Token.containsTokenWithValue(tokens, m)) {
            seconds += 60 * minutes;
            minutes = 0;
        }
        if (!Token.containsTokenWithValue(tokens, s)) {
            milliseconds += 1000 * seconds;
            seconds = 0;
        }
        return DurationFormatUtils.formatDuration(tokens, years, months, days, hours, minutes, seconds, milliseconds, padWithZeros);
    }

    static int reduceAndCorrect(Calendar start, Calendar end, int field, int difference) {
        end.add(field, -1 * difference);
        int endValue = end.get(field);
        int startValue = start.get(field);
        if (endValue < startValue) {
            int newdiff = startValue - endValue;
            end.add(field, newdiff);
            return newdiff;
        }
        return 0;
    }

    public static String formatWords(long millis, boolean suppressLeadingZeroElements, boolean suppressTrailingZeroElements) {
        String tmp;
        String duration = DurationFormatUtils.format(millis, "d' days 'H' hours 'm' minutes 's' seconds'");
        if (suppressLeadingZeroElements) {
            duration = " " + duration;
            tmp = StringUtils.replaceOnce(duration, " 0 days", "");
            if (tmp.length() != duration.length() && (tmp = StringUtils.replaceOnce(duration = tmp, " 0 hours", "")).length() != duration.length()) {
                duration = tmp;
                duration = tmp = StringUtils.replaceOnce(duration, " 0 minutes", "");
                if (tmp.length() != duration.length()) {
                    duration = StringUtils.replaceOnce(tmp, " 0 seconds", "");
                }
            }
            if (duration.length() != 0) {
                duration = duration.substring(1);
            }
        }
        if (suppressTrailingZeroElements && (tmp = StringUtils.replaceOnce(duration, " 0 seconds", "")).length() != duration.length() && (tmp = StringUtils.replaceOnce(duration = tmp, " 0 minutes", "")).length() != duration.length() && (tmp = StringUtils.replaceOnce(duration = tmp, " 0 hours", "")).length() != duration.length()) {
            duration = StringUtils.replaceOnce(tmp, " 0 days", "");
        }
        duration = StringUtils.replaceOnce(duration, "1 seconds", "1 second");
        duration = StringUtils.replaceOnce(duration, "1 minutes", "1 minute");
        duration = StringUtils.replaceOnce(duration, "1 hours", "1 hour");
        duration = StringUtils.replaceOnce(duration, "1 days", "1 day");
        return duration;
    }

    static Token[] lexx(String format) {
        char[] array = format.toCharArray();
        ArrayList<Token> list = new ArrayList<Token>(array.length);
        boolean inLiteral = false;
        StringBuffer buffer = null;
        Token previous = null;
        int sz = array.length;
        for (int i = 0; i < sz; ++i) {
            char ch = array[i];
            if (inLiteral && ch != '\'') {
                buffer.append(ch);
                continue;
            }
            Object value = null;
            switch (ch) {
                case '\'': {
                    if (inLiteral) {
                        buffer = null;
                        inLiteral = false;
                        break;
                    }
                    buffer = new StringBuffer();
                    list.add(new Token(buffer));
                    inLiteral = true;
                    break;
                }
                case 'y': {
                    value = y;
                    break;
                }
                case 'M': {
                    value = M;
                    break;
                }
                case 'd': {
                    value = d;
                    break;
                }
                case 'H': {
                    value = H;
                    break;
                }
                case 'm': {
                    value = m;
                    break;
                }
                case 's': {
                    value = s;
                    break;
                }
                case 'S': {
                    value = S;
                    break;
                }
                default: {
                    if (buffer == null) {
                        buffer = new StringBuffer();
                        list.add(new Token(buffer));
                    }
                    buffer.append(ch);
                }
            }
            if (value == null) continue;
            if (previous != null && previous.getValue() == value) {
                previous.increment();
            } else {
                Token token = new Token(value);
                list.add(token);
                previous = token;
            }
            buffer = null;
        }
        return list.toArray(new Token[0]);
    }
}

