/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.text;

import com.ibm.icu.impl.ICULocaleData;
import com.ibm.icu.impl.ICULocaleService;
import com.ibm.icu.impl.ICUService;
import com.ibm.icu.impl.LocaleUtility;
import com.ibm.icu.text.Collator;
import com.ibm.icu.text.CollatorServiceShim;
import com.ibm.icu.text.RuleBasedCollator;
import com.ibm.icu.util.ULocale;
import java.util.Locale;
import java.util.Set;

final class CollatorServiceShim
extends Collator.ServiceShim {
    private static ICULocaleService service = new CService();

    CollatorServiceShim() {
    }

    Collator getInstance(Locale locale) {
        if (service.isDefault()) {
            return new RuleBasedCollator(locale);
        }
        try {
            Locale[] actualLoc = new Locale[1];
            Collator coll = (Collator)service.get(locale, actualLoc);
            ULocale uloc = new ULocale(actualLoc[0]);
            coll = (Collator)coll.clone();
            coll.setLocale(uloc, uloc);
            return coll;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError(e.getMessage());
        }
    }

    Object registerInstance(Collator collator, Locale locale) {
        return service.registerObject((Object)collator, locale);
    }

    Object registerFactory(Collator.CollatorFactory f) {
        class CFactory
        extends ICULocaleService.LocaleKeyFactory {
            Collator.CollatorFactory delegate;
            private final /* synthetic */ CollatorServiceShim this$0;

            CFactory(CollatorServiceShim this$0, Collator.CollatorFactory f) {
                super(f.visible() ? 0 : 1, "CFactory");
                this.this$0 = this$0;
                this.delegate = f;
            }

            public Object handleCreate(Locale loc, int kind, ICUService service) {
                Collator coll = this.delegate.createCollator(loc);
                return coll;
            }

            public String getDisplayName(String id, Locale displayLocale) {
                Locale objectLocale = LocaleUtility.getLocaleFromName(id);
                return this.delegate.getDisplayName(objectLocale, displayLocale);
            }

            public Set getSupportedIDs() {
                return this.delegate.getSupportedLocaleIDs();
            }
        }
        return service.registerFactory(new CFactory(this, f));
    }

    boolean unregister(Object registryKey) {
        return service.unregisterFactory((ICUService.Factory)registryKey);
    }

    Locale[] getAvailableLocales() {
        if (service.isDefault()) {
            return ICULocaleData.getAvailableLocales();
        }
        return service.getAvailableLocales();
    }

    String getDisplayName(Locale objectLocale, Locale displayLocale) {
        String id = LocaleUtility.canonicalLocaleString(objectLocale);
        return service.getDisplayName(id, displayLocale);
    }

    private static class CService
    extends ICULocaleService {
        CService() {
            super("Collator");
            class CollatorFactory
            extends ICULocaleService.ICUResourceBundleFactory {
                private final /* synthetic */ CService this$0;

                CollatorFactory(CService this$0) {
                    this.this$0 = this$0;
                }

                protected Object handleCreate(Locale loc, int kind, ICUService service) {
                    return new RuleBasedCollator(loc);
                }

                protected Set getSupportedIDs() {
                    return ICULocaleData.getAvailableLocaleNameSet();
                }
            }
            this.registerFactory(new CollatorFactory(this));
            this.markDefault();
        }

        protected Object handleDefault(ICUService.Key key, String[] actualIDReturn) {
            if (actualIDReturn != null) {
                actualIDReturn[0] = "root";
            }
            return new RuleBasedCollator(new Locale("", "", ""));
        }
    }
}

