/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.repository;

import java.util.HashMap;
import java.util.Map;
import org.apache.avalon.framework.activity.Disposable;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.framework.logger.Logger;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.avalon.framework.thread.ThreadSafe;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.components.LifecycleHelper;
import org.apache.cocoon.components.repository.Repository;
import org.apache.cocoon.components.repository.helpers.CredentialsToken;

public class RepositoryManager
extends AbstractLogEnabled
implements Serviceable,
Disposable,
Configurable,
Component,
ThreadSafe {
    public static final String ROLE = RepositoryManager.class.getName();
    private ServiceManager manager;
    private Map repos = new HashMap();

    public void service(ServiceManager manager) throws ServiceException {
        this.manager = manager;
    }

    public void configure(Configuration configuration) throws ConfigurationException {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("configuring repository manager");
        }
        Configuration[] children = configuration.getChildren();
        for (int i = 0; i < children.length; ++i) {
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("found repository: " + children[i].getAttribute("class"));
            }
            this.repos.put(children[i].getAttribute("name"), children[i]);
        }
    }

    public void dispose() {
        this.manager = null;
    }

    public Repository getRepository(String hint, CredentialsToken credentials) throws ProcessingException {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("get repository for: " + hint);
        }
        String className = null;
        try {
            Configuration repoConfiguration = (Configuration)this.repos.get(hint);
            className = repoConfiguration.getAttribute("class");
            Class<?> repoClass = Class.forName(className);
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("loading class" + className);
            }
            Repository repo = (Repository)repoClass.newInstance();
            LifecycleHelper.setupComponent((Object)repo, (Logger)this.getLogger(), null, (ServiceManager)this.manager, (Configuration)repoConfiguration, (boolean)true);
            repo.setCredentials(credentials);
            return repo;
        }
        catch (ConfigurationException ce) {
            throw new ProcessingException("Could not get configuration for " + hint, (Throwable)ce);
        }
        catch (ClassNotFoundException cnfe) {
            throw new ProcessingException("Could not load class " + className, (Throwable)cnfe);
        }
        catch (InstantiationException ie) {
            throw new ProcessingException("Could not instantiate class " + className, (Throwable)ie);
        }
        catch (IllegalAccessException iae) {
            throw new ProcessingException("Could not instantiate class " + className, (Throwable)iae);
        }
        catch (Exception e) {
            throw new ProcessingException("Could not setup component " + className, (Throwable)e);
        }
    }
}

