/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.source.impl;

import java.io.IOException;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.framework.parameters.ParameterException;
import org.apache.avalon.framework.parameters.Parameterizable;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.avalon.framework.thread.ThreadSafe;
import org.apache.cocoon.components.source.SourceInspector;
import org.apache.cocoon.components.source.helpers.SourceProperty;
import org.apache.excalibur.source.Source;
import org.apache.excalibur.source.SourceException;
import org.apache.excalibur.source.SourceValidity;
import org.apache.excalibur.source.impl.validity.NOPValidity;
import org.apache.excalibur.xml.dom.DOMParser;
import org.apache.excalibur.xml.xpath.XPathProcessor;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XPathSourceInspector
extends AbstractLogEnabled
implements SourceInspector,
Serviceable,
Parameterizable,
ThreadSafe {
    public static final String DEFAULT_PROPERTY_NS = "http://apache.org/cocoon/inspector/xpath/1.0";
    public static final String DEFAULT_PROPERTY_NAME = "result";
    private String m_namespace;
    private String m_propertyname;
    private String m_extension;
    private String m_xpath;
    private ServiceManager manager = null;

    public void service(ServiceManager manager) {
        this.manager = manager;
    }

    public void parameterize(Parameters params) throws ParameterException {
        this.m_namespace = params.getParameter("namespace", DEFAULT_PROPERTY_NS);
        this.m_propertyname = params.getParameter("name", DEFAULT_PROPERTY_NAME);
        this.m_extension = params.getParameter("extension", ".xml");
        this.m_xpath = params.getParameter("xpath", "/*");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SourceProperty getSourceProperty(Source source, String namespace, String name) throws SourceException {
        SourceProperty sourceProperty;
        Document doc;
        block14: {
            if (!namespace.equals(this.m_namespace)) return null;
            if (!name.equals(this.m_propertyname)) return null;
            if (!source.getURI().endsWith(this.m_extension)) return null;
            DOMParser parser = null;
            doc = null;
            try {
                Object var8_6;
                try {
                    parser = (DOMParser)this.manager.lookup(DOMParser.ROLE);
                    doc = parser.parseDocument(new InputSource(source.getInputStream()));
                }
                catch (SAXException se) {
                    this.getLogger().error(source.getURI() + " is not a valid XML file");
                    var8_6 = null;
                    if (parser != null) {
                        this.manager.release((Object)parser);
                    }
                    break block14;
                }
                catch (IOException ioe) {
                    this.getLogger().error("Could not read file", (Throwable)ioe);
                    var8_6 = null;
                    if (parser != null) {
                        this.manager.release((Object)parser);
                    }
                    break block14;
                }
                catch (ServiceException ce) {
                    this.getLogger().error("Missing service dependency: DOMParser", (Throwable)ce);
                    var8_6 = null;
                    if (parser != null) {
                        this.manager.release((Object)parser);
                    }
                    break block14;
                }
                var8_6 = null;
                if (parser == null) break block14;
            }
            catch (Throwable throwable) {
                Object var8_7 = null;
                if (parser == null) throw throwable;
                this.manager.release((Object)parser);
                throw throwable;
            }
            this.manager.release((Object)parser);
        }
        if (doc == null) return null;
        XPathProcessor processor = null;
        try {
            try {
                processor = (XPathProcessor)this.manager.lookup(XPathProcessor.ROLE);
                NodeList nodelist = processor.selectNodeList((Node)doc.getDocumentElement(), this.m_xpath);
                SourceProperty property = new SourceProperty(this.m_namespace, this.m_propertyname);
                property.setValue(nodelist);
                sourceProperty = property;
                Object var11_16 = null;
                if (processor == null) return sourceProperty;
            }
            catch (ServiceException se) {
                this.getLogger().error("Could not retrieve component", (Throwable)se);
                Object var11_17 = null;
                if (processor == null) return null;
                this.manager.release((Object)processor);
                return null;
            }
        }
        catch (Throwable throwable) {
            Object var11_18 = null;
            if (processor == null) throw throwable;
            this.manager.release((Object)processor);
            throw throwable;
        }
        this.manager.release((Object)processor);
        return sourceProperty;
    }

    public SourceProperty[] getSourceProperties(Source source) throws SourceException {
        SourceProperty property = this.getSourceProperty(source, this.m_namespace, this.m_propertyname);
        if (property != null) {
            return new SourceProperty[]{property};
        }
        return null;
    }

    public boolean handlesProperty(String namespace, String name) {
        return this.m_namespace.equals(namespace) && this.m_propertyname.equals(name);
    }

    public SourceValidity getValidity(Source source) {
        return NOPValidity.SHARED_INSTANCE;
    }
}

