/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.ojb.components;

import org.apache.avalon.framework.activity.Initializable;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.framework.logger.Logger;
import org.apache.avalon.framework.thread.ThreadSafe;
import org.apache.ojb.broker.util.configuration.Configuration;
import org.apache.ojb.broker.util.configuration.ConfigurationException;

public class LoggerImpl
extends AbstractLogEnabled
implements Component,
ThreadSafe,
Initializable,
org.apache.ojb.broker.util.logging.Logger {
    private static Logger LOGGER;
    private final String name;
    private transient int level;
    private transient Logger logger;

    public LoggerImpl() {
        this.name = null;
    }

    public LoggerImpl(String name) {
        this.name = name.startsWith("org.apache.ojb.") ? name.substring(15) : name;
    }

    public void initialize() {
        LOGGER = this.getLogger();
    }

    protected int getLevel() {
        if (this.logger == null) {
            this.logger = LOGGER.getChildLogger(this.name);
            this.level = this.logger.isDebugEnabled() ? 1 : (this.logger.isInfoEnabled() ? 2 : (this.logger.isWarnEnabled() ? 3 : (this.logger.isErrorEnabled() ? 4 : 5)));
        }
        return this.level;
    }

    public String getName() {
        return this.name;
    }

    public void debug(Object message) {
        if (1 >= this.getLevel()) {
            this.logger.debug(this.toString(message));
        }
    }

    public void debug(Object message, Throwable t) {
        if (1 >= this.getLevel()) {
            this.logger.debug(this.toString(message), t);
        }
    }

    public void safeDebug(String message, Object obj) {
        if (1 >= this.getLevel()) {
            this.logger.debug(message + " : " + this.toString(obj));
        }
    }

    public void safeDebug(String message, Object obj, Throwable t) {
        if (1 >= this.getLevel()) {
            this.logger.debug(message + " : " + this.toString(obj), t);
        }
    }

    public void info(Object message) {
        if (2 >= this.getLevel()) {
            this.logger.info(this.toString(message));
        }
    }

    public void info(Object message, Throwable t) {
        if (2 >= this.getLevel()) {
            this.logger.info(this.toString(message), t);
        }
    }

    public void safeInfo(String message, Object obj) {
        if (2 >= this.getLevel()) {
            this.logger.info(message + " : " + this.toString(obj));
        }
    }

    public void safeInfo(String message, Object obj, Throwable t) {
        if (2 >= this.getLevel()) {
            this.logger.info(message + " : " + this.toString(obj), t);
        }
    }

    public void warn(Object message) {
        if (3 >= this.getLevel()) {
            this.logger.warn(this.toString(message));
        }
    }

    public void warn(Object message, Throwable t) {
        if (3 >= this.getLevel()) {
            this.logger.warn(this.toString(message), t);
        }
    }

    public void safeWarn(String message, Object obj) {
        if (3 >= this.getLevel()) {
            this.logger.warn(message + " : " + this.toString(obj));
        }
    }

    public void safeWarn(String message, Object obj, Throwable t) {
        if (3 >= this.getLevel()) {
            this.logger.warn(message + " : " + this.toString(obj), t);
        }
    }

    public void error(Object message) {
        if (4 >= this.getLevel()) {
            this.logger.fatalError(this.toString(message));
        }
    }

    public void error(Object message, Throwable t) {
        if (4 >= this.getLevel()) {
            this.logger.fatalError(this.toString(message), t);
        }
    }

    public void safeError(String message, Object obj) {
        if (4 >= this.getLevel()) {
            this.logger.error(message + " : " + this.toString(obj));
        }
    }

    public void safeError(String message, Object obj, Throwable t) {
        if (4 >= this.getLevel()) {
            this.logger.error(message + " : " + this.toString(obj), t);
        }
    }

    public void fatal(Object message) {
        if (5 >= this.getLevel()) {
            this.logger.fatalError(this.toString(message));
        }
    }

    public void fatal(Object message, Throwable t) {
        if (5 >= this.getLevel()) {
            this.logger.fatalError(this.toString(message), t);
        }
    }

    public void safeFatal(String message, Object obj) {
        if (5 >= this.getLevel()) {
            this.logger.fatalError(message + " : " + this.toString(obj));
        }
    }

    public void safeFatal(String message, Object obj, Throwable t) {
        if (5 >= this.getLevel()) {
            this.logger.fatalError(message + " : " + this.toString(obj), t);
        }
    }

    public boolean isDebugEnabled() {
        return this.isEnabledFor(1);
    }

    public boolean isEnabledFor(int priority) {
        return priority >= this.getLevel();
    }

    public void configure(Configuration config) throws ConfigurationException {
    }

    private String toString(Object obj) {
        if (obj != null) {
            try {
                return obj.toString();
            }
            catch (Throwable throwable) {
                return "BAD toString() impl for " + obj.getClass().getName();
            }
        }
        return "null";
    }
}

