/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.ojb.odmg.components;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import org.apache.avalon.framework.activity.Disposable;
import org.apache.avalon.framework.activity.Initializable;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.framework.thread.ThreadSafe;
import org.apache.cocoon.ojb.odmg.components.ODMG;
import org.apache.ojb.odmg.OJB;
import org.odmg.Database;
import org.odmg.Implementation;
import org.odmg.ODMGException;

public class ODMGImpl
extends AbstractLogEnabled
implements ODMG,
ThreadSafe,
Initializable,
Disposable {
    private static final String DEFAULT_CONNECTION = "default";
    private static final int DEFAULT_MODE = 2;
    private Implementation odmg;
    private HashMap databases = new HashMap();

    public void initialize() throws Exception {
        this.odmg = OJB.getInstance();
    }

    public void dispose() {
        Set keys = this.databases.keySet();
        Iterator i = keys.iterator();
        while (i.hasNext()) {
            Database db = (Database)i.next();
            try {
                db.close();
            }
            catch (ODMGException e) {
                this.getLogger().error("OJB-ODMG: Cannot close Database", (Throwable)e);
            }
            i.remove();
        }
    }

    public Implementation getInstance() throws ODMGException {
        return this.getInstance(DEFAULT_CONNECTION, 2);
    }

    public Implementation getInstance(String connection) throws ODMGException {
        return this.getInstance(connection, 2);
    }

    public Implementation getInstance(int mode) throws ODMGException {
        return this.getInstance(DEFAULT_CONNECTION, mode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Implementation getInstance(String connection, int mode) throws ODMGException {
        HashMap hashMap = this.databases;
        synchronized (hashMap) {
            Database db = (Database)this.databases.get(connection + ":" + mode);
            if (null == db) {
                db = this.odmg.newDatabase();
                db.open(connection, mode);
                this.databases.put(connection + ":" + mode, db);
            }
        }
        return this.odmg;
    }
}

