/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.generation;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.Serializable;
import java.util.Map;
import org.apache.avalon.framework.parameters.ParameterException;
import org.apache.avalon.framework.parameters.Parameterizable;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.caching.CacheableProcessingComponent;
import org.apache.cocoon.environment.SourceResolver;
import org.apache.cocoon.generation.ServiceableGenerator;
import org.apache.commons.lang.SystemUtils;
import org.apache.excalibur.source.Source;
import org.apache.excalibur.source.SourceException;
import org.apache.excalibur.source.SourceValidity;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;
import org.xml.sax.helpers.LocatorImpl;

public class TextGenerator
extends ServiceableGenerator
implements Parameterizable,
CacheableProcessingComponent {
    public static final String URI = "http://chaperon.sourceforge.net/schema/text/1.0";
    private static final char[] initNonXmlChars = new char[]{' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' '};
    private Source inputSource;
    private String encoding;
    private char[] nonXmlChars;
    private boolean localizable = false;

    public void recycle() {
        if (this.inputSource != null) {
            this.resolver.release(this.inputSource);
        }
        this.inputSource = null;
        this.encoding = null;
        this.nonXmlChars = null;
        super.recycle();
    }

    public void parameterize(Parameters parameters) throws ParameterException {
        this.localizable = parameters.getParameterAsBoolean("localizable", false);
    }

    public void setup(SourceResolver resolver, Map objectmodel, String src, Parameters parameters) throws ProcessingException, SAXException, IOException {
        super.setup(resolver, objectmodel, src, parameters);
        try {
            this.encoding = parameters.getParameter("encoding", null);
            this.inputSource = resolver.resolveURI(src);
            String nXmlCh = parameters.getParameter("nonXmlChars", String.valueOf(initNonXmlChars));
            if (nXmlCh.length() != initNonXmlChars.length) {
                throw new ProcessingException("Error during resolving of '" + src + "'.", (Throwable)new SourceException("length of attribute string 'nonXmlChars' is " + nXmlCh.length() + " where it should be " + initNonXmlChars.length + "!"));
            }
            this.nonXmlChars = nXmlCh.toCharArray();
        }
        catch (SourceException se) {
            throw new ProcessingException("Error during resolving of '" + src + "'.", (Throwable)se);
        }
    }

    public Serializable getKey() {
        return this.inputSource.getURI() + ";localizable=" + this.localizable + ";encoding=" + this.encoding;
    }

    public SourceValidity getValidity() {
        return this.inputSource.getValidity();
    }

    public void generate() throws IOException, SAXException, ProcessingException {
        String line;
        InputStreamReader in = null;
        try {
            InputStream sis = this.inputSource.getInputStream();
            if (sis == null) {
                throw new ProcessingException("Source '" + this.inputSource.getURI() + "' not found");
            }
            in = this.encoding != null ? new InputStreamReader(sis, this.encoding) : new InputStreamReader(sis);
        }
        catch (SourceException se) {
            throw new ProcessingException("Error during resolving of '" + this.source + "'.", (Throwable)se);
        }
        LocatorImpl locator = new LocatorImpl();
        locator.setSystemId(this.inputSource.getURI());
        locator.setLineNumber(1);
        locator.setColumnNumber(1);
        this.contentHandler.setDocumentLocator(locator);
        this.contentHandler.startDocument();
        this.contentHandler.startPrefixMapping("", URI);
        AttributesImpl atts = new AttributesImpl();
        if (this.localizable) {
            atts.addAttribute("", "source", "source", "CDATA", locator.getSystemId());
            atts.addAttribute("", "line", "line", "CDATA", String.valueOf(locator.getLineNumber()));
            atts.addAttribute("", "column", "column", "CDATA", String.valueOf(locator.getColumnNumber()));
        }
        this.contentHandler.startElement(URI, "text", "text", atts);
        LineNumberReader reader = new LineNumberReader(in);
        String newline = null;
        while ((line = newline == null ? this.convertNonXmlChars(reader.readLine()) : newline) != null) {
            newline = this.convertNonXmlChars(reader.readLine());
            if (newline != null) {
                line = line + SystemUtils.LINE_SEPARATOR;
            }
            locator.setLineNumber(reader.getLineNumber());
            locator.setColumnNumber(1);
            this.contentHandler.characters(line.toCharArray(), 0, line.length());
            if (newline != null) continue;
        }
        reader.close();
        this.contentHandler.endElement(URI, "text", "text");
        this.contentHandler.endPrefixMapping("");
        this.contentHandler.endDocument();
    }

    private String convertNonXmlChars(String s) {
        if (s != null) {
            char[] sc = s.toCharArray();
            for (int i = 0; i < sc.length; ++i) {
                char nv = sc[i];
                if (nv < '\u0000' || nv >= this.nonXmlChars.length || nv == '\t' || nv == '\n' || nv == '\r') continue;
                sc[i] = this.nonXmlChars[nv];
            }
            return String.valueOf(sc);
        }
        return null;
    }
}

