/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.transformation;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Map;
import net.sourceforge.chaperon.build.LexicalAutomatonBuilder;
import net.sourceforge.chaperon.model.lexicon.Lexicon;
import net.sourceforge.chaperon.model.lexicon.LexiconFactory;
import net.sourceforge.chaperon.process.LexicalAutomaton;
import net.sourceforge.chaperon.process.LexicalProcessor;
import org.apache.avalon.excalibur.pool.Recyclable;
import org.apache.avalon.framework.activity.Disposable;
import org.apache.avalon.framework.logger.LogEnabled;
import org.apache.avalon.framework.logger.Logger;
import org.apache.avalon.framework.parameters.ParameterException;
import org.apache.avalon.framework.parameters.Parameterizable;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.caching.CacheableProcessingComponent;
import org.apache.cocoon.components.source.SourceUtil;
import org.apache.cocoon.environment.SourceResolver;
import org.apache.cocoon.transformation.Transformer;
import org.apache.cocoon.xml.XMLConsumer;
import org.apache.excalibur.source.Source;
import org.apache.excalibur.source.SourceException;
import org.apache.excalibur.source.SourceValidity;
import org.apache.excalibur.store.Store;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.ext.LexicalHandler;

public class LexicalTransformer
extends LexicalProcessor
implements Transformer,
LogEnabled,
Serviceable,
Recyclable,
Disposable,
Parameterizable,
CacheableProcessingComponent {
    private String lexicon = null;
    private Source lexiconSource = null;
    private Logger logger = null;
    private ServiceManager manager = null;
    private SourceResolver resolver = null;

    public void enableLogging(Logger logger) {
        this.logger = logger;
    }

    public void service(ServiceManager manager) {
        this.manager = manager;
    }

    public void parameterize(Parameters parameters) throws ParameterException {
        this.setLocalizable(parameters.getParameterAsBoolean("localizable", false));
    }

    public void setConsumer(XMLConsumer consumer) {
        this.setContentHandler((ContentHandler)consumer);
        this.setLexicalHandler((LexicalHandler)consumer);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setup(SourceResolver resolver, Map objectmodel, String src, Parameters parameters) throws ProcessingException, SAXException, IOException {
        this.resolver = resolver;
        Store store = null;
        try {
            try {
                this.lexicon = src;
                this.lexiconSource = resolver.resolveURI(this.lexicon);
                store = (Store)this.manager.lookup(Store.TRANSIENT_STORE);
                LexicalAutomatonEntry entry = (LexicalAutomatonEntry)store.get((Object)this.lexiconSource.getURI());
                if (entry == null || entry.getValidity() == null || entry.getValidity().isValid(this.lexiconSource.getValidity()) <= 0) {
                    this.logger.info("(Re)building the automaton from '" + this.lexiconSource.getURI() + "'");
                    if (this.lexiconSource.getInputStream() == null) {
                        throw new ProcessingException("Source '" + this.lexiconSource.getURI() + "' not found");
                    }
                    LexiconFactory factory = new LexiconFactory();
                    SourceUtil.toSAX((ServiceManager)this.manager, (Source)this.lexiconSource, null, (ContentHandler)factory);
                    Lexicon lexicon = factory.getLexicon();
                    LexicalAutomatonBuilder builder = new LexicalAutomatonBuilder(lexicon);
                    LexicalAutomaton automaton = builder.getLexicalAutomaton();
                    this.setLexicalAutomaton(automaton);
                    this.logger.info("Store automaton into store for '" + this.lexiconSource.getURI() + "'");
                    store.store((Object)this.lexiconSource.getURI(), (Object)new LexicalAutomatonEntry(automaton, this.lexiconSource.getValidity()));
                }
                this.logger.info("Getting automaton from store for '" + this.lexiconSource.getURI() + "'");
                this.setLexicalAutomaton(entry.getLexicalAutomaton());
            }
            catch (SourceException se) {
                throw new ProcessingException("Error during resolving of '" + src + "'.", (Throwable)se);
            }
            catch (ServiceException se) {
                throw new ProcessingException("Could not lookup for service", (Throwable)se);
            }
            Object var12_13 = null;
            if (store == null) return;
        }
        catch (Throwable throwable) {
            Object var12_14 = null;
            if (store == null) throw throwable;
            this.manager.release(store);
            throw throwable;
        }
        this.manager.release((Object)store);
    }

    public Serializable getKey() {
        return this.lexiconSource.getURI();
    }

    public SourceValidity getValidity() {
        return this.lexiconSource.getValidity();
    }

    public void recycle() {
        if (this.resolver != null && this.lexiconSource != null) {
            this.resolver.release(this.lexiconSource);
            this.lexiconSource = null;
        }
    }

    public void dispose() {
        if (this.resolver != null && this.lexiconSource != null) {
            this.resolver.release(this.lexiconSource);
            this.lexiconSource = null;
        }
        this.manager = null;
    }

    public static class LexicalAutomatonEntry
    implements Serializable {
        private SourceValidity validity = null;
        private LexicalAutomaton automaton = null;

        public LexicalAutomatonEntry(LexicalAutomaton automaton, SourceValidity validity) {
            this.automaton = automaton;
            this.validity = validity;
        }

        public SourceValidity getValidity() {
            return this.validity;
        }

        public LexicalAutomaton getLexicalAutomaton() {
            return this.automaton;
        }

        private void writeObject(ObjectOutputStream out) throws IOException {
            out.writeObject(this.validity);
            out.writeObject(this.automaton);
        }

        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            this.validity = (SourceValidity)in.readObject();
            this.automaton = (LexicalAutomaton)in.readObject();
        }
    }
}

