/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.caching.impl;

import javax.jms.Message;
import org.apache.avalon.framework.parameters.ParameterException;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.avalon.framework.thread.ThreadSafe;
import org.apache.cocoon.caching.Cache;
import org.apache.cocoon.caching.EventAware;
import org.apache.cocoon.caching.validity.Event;
import org.apache.cocoon.caching.validity.NamedEvent;
import org.apache.cocoon.components.jms.AbstractMessageListener;

public class JMSEventMessageListener
extends AbstractMessageListener
implements ThreadSafe {
    private static final String DEFAULT_EVENTCACHE_ROLE = Cache.ROLE + "/EventAware";
    private static final String EVENTCACHE_ROLE_PARAM = "eventcache-role";
    private String m_eventAwareRole;
    private EventAware m_eventCache;

    public void parameterize(Parameters parameters) throws ParameterException {
        super.parameterize(parameters);
        this.m_eventAwareRole = parameters.getParameter(EVENTCACHE_ROLE_PARAM, DEFAULT_EVENTCACHE_ROLE);
    }

    public void initialize() throws Exception {
        super.initialize();
        this.m_eventCache = (EventAware)this.m_manager.lookup(this.m_eventAwareRole);
    }

    public void dispose() {
        super.dispose();
        this.m_manager.release((Object)this.m_eventCache);
    }

    public synchronized void onMessage(Message message) {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Receiving message: " + message);
        }
        Event[] events = this.eventsFromMessage(message);
        for (int i = 0; i < events.length; ++i) {
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("Notifying " + this.m_eventAwareRole + " of " + events[i]);
            }
            this.m_eventCache.processEvent(events[i]);
        }
    }

    protected Event[] eventsFromMessage(Message message) {
        String name = message.toString();
        int pos = name.indexOf(124);
        return new Event[]{new NamedEvent(name.substring(pos + 1))};
    }
}

