/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.webapps.session.components;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.avalon.framework.activity.Disposable;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.context.Contextualizable;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.ServiceSelector;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.avalon.framework.thread.ThreadSafe;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.components.ContextHelper;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.environment.Session;
import org.apache.cocoon.webapps.session.ContextManager;
import org.apache.cocoon.webapps.session.context.SessionContext;
import org.apache.cocoon.webapps.session.context.SessionContextProvider;
import org.apache.cocoon.webapps.session.context.SimpleSessionContext;
import org.apache.excalibur.source.SourceResolver;
import org.apache.excalibur.xml.xpath.XPathProcessor;
import org.xml.sax.SAXException;

public final class DefaultContextManager
extends AbstractLogEnabled
implements Serviceable,
ContextManager,
ThreadSafe,
Component,
Contextualizable,
Disposable {
    private ServiceManager manager;
    private Context context;
    private ServiceSelector contextSelector;
    private XPathProcessor xpathProcessor;
    private SourceResolver resolver;
    private static final String[] reservedContextNames = new String[]{"session", "context"};

    public void service(ServiceManager manager) throws ServiceException {
        this.manager = manager;
        this.contextSelector = (ServiceSelector)this.manager.lookup(SessionContextProvider.ROLE + "Selector");
        this.xpathProcessor = (XPathProcessor)this.manager.lookup(XPathProcessor.ROLE);
        this.resolver = (SourceResolver)this.manager.lookup(SourceResolver.ROLE);
    }

    private Session getSession(boolean create) {
        Request request = ContextHelper.getRequest((Context)this.context);
        return request.getSession(create);
    }

    private Map getSessionContexts(Session session) {
        HashMap contexts = (HashMap)session.getAttribute(SessionContext.class.getName());
        if (contexts == null) {
            contexts = new HashMap(5, 3.0f);
            session.setAttribute(SessionContext.class.getName(), contexts);
        }
        return contexts;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isReservedContextName(String name) {
        boolean found = false;
        int l = reservedContextNames.length;
        for (int i = 0; i < l && !found; ++i) {
            found = reservedContextNames[i].equals(name);
        }
        if (!found) {
            found = false;
            SessionContextProvider provider = null;
            try {
                provider = (SessionContextProvider)this.contextSelector.select((Object)name);
                found = true;
            }
            catch (ServiceException ignore) {
            }
            finally {
                this.contextSelector.release((Object)provider);
            }
        }
        return found;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean existsReservedContext(String name) throws ProcessingException {
        boolean exists = false;
        SessionContextProvider provider = null;
        try {
            provider = (SessionContextProvider)this.contextSelector.select((Object)name);
            exists = provider.existsSessionContext(name);
        }
        catch (ServiceException ignore) {
        }
        finally {
            this.contextSelector.release((Object)provider);
        }
        return exists;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SessionContext getReservedContext(String name) throws ProcessingException {
        SessionContext context = null;
        SessionContextProvider provider = null;
        try {
            SessionContextProvider sessionContextProvider = provider = (SessionContextProvider)this.contextSelector.select((Object)name);
            synchronized (sessionContextProvider) {
                context = provider.getSessionContext(name);
            }
        }
        catch (ServiceException ignore) {
        }
        finally {
            this.contextSelector.release((Object)provider);
        }
        return context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SessionContext createContext(String name, String loadURI, String saveURI) throws IOException, SAXException, ProcessingException {
        SessionContext context;
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("BEGIN createContext name=" + name + "load=" + loadURI + "save=" + saveURI);
        }
        if (name == null) {
            throw new ProcessingException("CreateContext: Name is required");
        }
        Session session = this.getSession(true);
        if (session == null) {
            throw new ProcessingException("CreateContext: Session is required");
        }
        Session session2 = session;
        synchronized (session2) {
            if (this.isReservedContextName(name)) {
                throw new ProcessingException("SessionContext with name " + name + " is reserved and cannot be created manually.");
            }
            if (this.existsContext(name)) {
                context = this.getContext(name);
            } else {
                Map contexts = this.getSessionContexts(session);
                context = new SimpleSessionContext(this.xpathProcessor, this.resolver);
                context.setup(name, loadURI, saveURI);
                contexts.put(name, context);
            }
        }
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("END createContext context=" + context);
        }
        return context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteContext(String name) throws ProcessingException {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("BEGIN deleteContext name=" + name);
        }
        if (name == null) {
            throw new ProcessingException("SessionManager.deleteContext: Name is required");
        }
        if (this.isReservedContextName(name)) {
            throw new ProcessingException("SessionContext with name " + name + " is reserved and cannot be deleted manually.");
        }
        Session session = this.getSession(false);
        if (session == null) {
            throw new ProcessingException("SessionManager.deleteContext: Session is required");
        }
        Session session2 = session;
        synchronized (session2) {
            Map contexts = this.getSessionContexts(session);
            if (contexts.containsKey(name)) {
                contexts.remove(name);
            }
        }
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("END deleteContext");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SessionContext getContext(String name) throws ProcessingException {
        SessionContext context;
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("BEGIN getContext name=" + name);
        }
        if (this.isReservedContextName(name)) {
            context = this.getReservedContext(name);
        } else {
            Session session = this.getSession(false);
            if (session != null) {
                Session session2 = session;
                synchronized (session2) {
                    Map contexts = this.getSessionContexts(session);
                    context = (SessionContext)contexts.get(name);
                }
            } else {
                context = null;
            }
        }
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("END getContext context=" + context);
        }
        return context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasSessionContext() throws ProcessingException {
        Session session = this.getSession(false);
        if (session == null) {
            throw new ProcessingException("SessionManager.hasSessionContext: Session is required.");
        }
        Session session2 = session;
        synchronized (session2) {
            Map contexts = this.getSessionContexts(session);
            return !contexts.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean existsContext(String name) throws ProcessingException {
        Session session = this.getSession(false);
        if (session == null) {
            throw new ProcessingException("SessionManager.existsContext: Session is required.");
        }
        Session session2 = session;
        synchronized (session2) {
            Map contexts = this.getSessionContexts(session);
            boolean result = contexts.containsKey(name);
            if (!result && this.isReservedContextName(name)) {
                result = this.existsReservedContext(name);
            }
            return result;
        }
    }

    public void contextualize(Context context) throws ContextException {
        this.context = context;
    }

    public void dispose() {
        if (this.manager != null) {
            this.manager.release((Object)this.contextSelector);
            this.manager.release((Object)this.xpathProcessor);
            this.manager.release((Object)this.resolver);
            this.contextSelector = null;
            this.xpathProcessor = null;
            this.resolver = null;
            this.manager = null;
        }
    }
}

