/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.webapps.session.components;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.context.Contextualizable;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.avalon.framework.thread.ThreadSafe;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.components.ContextHelper;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.environment.Session;
import org.apache.cocoon.webapps.session.ContextManager;
import org.apache.cocoon.webapps.session.FormManager;
import org.apache.cocoon.webapps.session.SessionManager;
import org.apache.cocoon.webapps.session.context.SessionContext;
import org.w3c.dom.DocumentFragment;

public final class DefaultFormManager
extends AbstractLogEnabled
implements Serviceable,
Component,
FormManager,
ThreadSafe,
Contextualizable {
    private static final String ATTRIBUTE_INPUTXML_STORAGE = "org.apache.cocoon.webapps.session.InputXMLStorage";
    private ServiceManager manager;
    private Context context;

    private SessionContext getContext(String name) throws ProcessingException {
        ContextManager contextManager = null;
        try {
            contextManager = (ContextManager)this.manager.lookup(ContextManager.ROLE);
            SessionContext sessionContext = contextManager.getContext(name);
            return sessionContext;
        }
        catch (ServiceException ce) {
            throw new ProcessingException("Unable to lookup context manager.", (Throwable)ce);
        }
        finally {
            this.manager.release((Object)contextManager);
        }
    }

    private DocumentFragment getContextFragment(String context, String path) throws ProcessingException {
        SessionManager sessionManager = null;
        try {
            sessionManager = (SessionManager)this.manager.lookup(SessionManager.ROLE);
            DocumentFragment documentFragment = sessionManager.getContextFragment(context, path);
            return documentFragment;
        }
        catch (ServiceException ce) {
            throw new ProcessingException("Unable to lookup session manager.", (Throwable)ce);
        }
        finally {
            this.manager.release((Object)sessionManager);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DocumentFragment registerInputField(String contextName, String path, String name, String formName) throws ProcessingException {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("BEGIN registerInputField context=" + contextName + ", path=" + path + ", name=" + name + ", formName=" + formName);
        }
        if (contextName == null) {
            throw new ProcessingException("SessionManager.registerInputField: Context Name is required");
        }
        if (path == null) {
            throw new ProcessingException("SessionManager.registerInputField: Path is required");
        }
        if (name == null) {
            throw new ProcessingException("SessionManager.registerInputField: Name is required");
        }
        if (formName == null) {
            throw new ProcessingException("SessionManager.registerInputField: Form is required");
        }
        DocumentFragment value = null;
        SessionContext context = this.getContext(contextName);
        if (context == null) {
            throw new ProcessingException("SessionManager.registerInputField: Context not found " + contextName);
        }
        Request request = ContextHelper.getRequest((Context)this.context);
        Session session = request.getSession(false);
        if (session == null) {
            throw new ProcessingException("SessionManager.registerInputField: Session is required for context " + contextName);
        }
        Session session2 = session;
        synchronized (session2) {
            HashMap<String, Object[]> inputFields = (HashMap<String, Object[]>)session.getAttribute(ATTRIBUTE_INPUTXML_STORAGE);
            if (inputFields == null) {
                inputFields = new HashMap<String, Object[]>(10);
                session.setAttribute(ATTRIBUTE_INPUTXML_STORAGE, inputFields);
            }
            inputFields.put(name, new Object[]{context, path, formName});
            value = context.getXML(path);
        }
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("END registerInputField value=" + value);
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processInputFields(Map objectModel) {
        Session session;
        Request request;
        String formName;
        if (objectModel.containsKey(this.getClass().getName())) {
            return;
        }
        objectModel.put(this.getClass().getName(), "done");
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("BEGIN processInputFields");
        }
        if (null != (formName = (request = ObjectModelHelper.getRequest((Map)objectModel)).getParameter("sessionform")) && (session = request.getSession(false)) != null) {
            Session session2 = session;
            synchronized (session2) {
                Map inputFields = (Map)session.getAttribute(ATTRIBUTE_INPUTXML_STORAGE);
                if (inputFields != null) {
                    Enumeration keys = request.getParameterNames();
                    while (keys.hasMoreElements()) {
                        String currentKey = (String)keys.nextElement();
                        if (!inputFields.containsKey(currentKey)) continue;
                        Object[] contextAndPath = (Object[])inputFields.get(currentKey);
                        inputFields.remove(currentKey);
                        SessionContext context = (SessionContext)contextAndPath[0];
                        String path = (String)contextAndPath[1];
                        if (!formName.equals(contextAndPath[2])) continue;
                        try {
                            context.setXML(path, this.getContextFragment("request", "/parameter/" + currentKey));
                        }
                        catch (ProcessingException ignore) {
                            this.getLogger().warn("Exception during processing of input fields.", (Throwable)ignore);
                        }
                    }
                }
            }
        }
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("END processInputFields");
        }
    }

    public void processInputFields() {
        Map objectModel = ContextHelper.getObjectModel((Context)this.context);
        this.processInputFields(objectModel);
    }

    public void contextualize(Context context) throws ContextException {
        this.context = context;
    }

    public void service(ServiceManager manager) throws ServiceException {
        this.manager = manager;
    }
}

