/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.webapps.session.components;

import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.context.Contextualizable;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.framework.thread.ThreadSafe;
import org.apache.cocoon.components.ContextHelper;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.webapps.session.MediaManager;
import org.apache.cocoon.webapps.session.components.PreparedMediaType;

public final class DefaultMediaManager
extends AbstractLogEnabled
implements MediaManager,
Configurable,
ThreadSafe,
Contextualizable,
Component {
    protected PreparedMediaType[] allMediaTypes;
    protected String defaultMediaType;
    protected String[] mediaTypeNames;
    protected Context context;

    public void contextualize(Context context) throws ContextException {
        this.context = context;
    }

    public void configure(Configuration myConfiguration) throws ConfigurationException {
        Configuration mediaConf = myConfiguration.getChild("mediatypes", false);
        this.defaultMediaType = mediaConf == null ? "html" : mediaConf.getAttribute("default", "html");
        this.mediaTypeNames = new String[1];
        this.mediaTypeNames[0] = this.defaultMediaType;
        Configuration[] childs = mediaConf.getChildren("media");
        PreparedMediaType[] array = new PreparedMediaType[]{};
        if (childs != null) {
            for (int x = 0; x < childs.length; ++x) {
                Configuration current = childs[x];
                PreparedMediaType[] copy = new PreparedMediaType[array.length + 1];
                System.arraycopy(array, 0, copy, 0, array.length);
                array = copy;
                String name = current.getAttribute("name");
                array[array.length - 1] = new PreparedMediaType(name, current.getAttribute("useragent"));
                boolean found = false;
                for (int i = 0; i < this.mediaTypeNames.length && !found; ++i) {
                    found = this.mediaTypeNames[i].equals(name);
                }
                if (found) continue;
                String[] newStrings = new String[this.mediaTypeNames.length + 1];
                System.arraycopy(this.mediaTypeNames, 0, newStrings, 0, this.mediaTypeNames.length);
                newStrings[newStrings.length - 1] = name;
                this.mediaTypeNames = newStrings;
            }
        }
        this.allMediaTypes = array;
    }

    public boolean testMedia(String value) {
        boolean result = false;
        Request request = ContextHelper.getRequest((Context)this.context);
        String useragent = request.getHeader("User-Agent");
        PreparedMediaType theMedia = null;
        int i = 0;
        int l = this.allMediaTypes.length;
        while (i < l && theMedia == null) {
            if (useragent.indexOf(this.allMediaTypes[i].useragent) == -1) {
                ++i;
                continue;
            }
            theMedia = this.allMediaTypes[i];
        }
        result = theMedia != null ? theMedia.name.equals(value) : this.defaultMediaType.equals(value);
        return result;
    }

    public String[] getMediaTypes() {
        return this.mediaTypeNames;
    }

    public String getMediaType() {
        Request request = ContextHelper.getRequest((Context)this.context);
        String useragent = request.getHeader("User-Agent");
        PreparedMediaType media = null;
        if (useragent != null) {
            int i = 0;
            int l = this.allMediaTypes.length;
            while (i < l && media == null) {
                if (useragent.indexOf(this.allMediaTypes[i].useragent) == -1) {
                    ++i;
                    continue;
                }
                media = this.allMediaTypes[i];
            }
        }
        return media == null ? this.defaultMediaType : media.name;
    }
}

