/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.webapps.session.components;

import java.util.Properties;
import org.apache.avalon.framework.activity.Disposable;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.context.Contextualizable;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.avalon.framework.thread.ThreadSafe;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.components.ContextHelper;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.environment.Session;
import org.apache.cocoon.webapps.session.ContextManager;
import org.apache.cocoon.webapps.session.SessionManager;
import org.apache.cocoon.webapps.session.context.SessionContext;
import org.apache.cocoon.xml.XMLConsumer;
import org.apache.cocoon.xml.XMLUtils;
import org.apache.cocoon.xml.dom.DOMUtil;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.ext.LexicalHandler;

public final class DefaultSessionManager
extends AbstractLogEnabled
implements Serviceable,
Component,
ThreadSafe,
SessionManager,
Disposable,
Contextualizable {
    private Context context;
    private ServiceManager manager;
    private ContextManager contextManager;

    public void service(ServiceManager manager) throws ServiceException {
        this.manager = manager;
        this.contextManager = (ContextManager)this.manager.lookup(ContextManager.ROLE);
    }

    public void dispose() {
        if (this.manager != null) {
            this.manager.release((Object)this.contextManager);
            this.manager = null;
            this.contextManager = null;
        }
    }

    public Session createSession() {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("BEGIN createSession");
        }
        Session session = this.getSession(true);
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("END createSession session=" + session);
        }
        return session;
    }

    public Session getSession(boolean createFlag) {
        Request request = ContextHelper.getRequest((Context)this.context);
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("BEGIN getSession create=" + createFlag);
        }
        Session session = request.getSession(createFlag);
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("END getSession session=" + session);
        }
        return session;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void terminateSession(boolean force) throws ProcessingException {
        Session session;
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("BEGIN terminateSession force=" + force);
        }
        if ((session = this.getSession(false)) != null && (force || this.contextManager.hasSessionContext())) {
            Session session2 = session;
            synchronized (session2) {
                session.invalidate();
            }
        }
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("END terminateSession");
        }
    }

    public DocumentFragment getContextFragment(String contextName, String path) throws ProcessingException {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("BEGIN getContextFragment name=" + contextName + ", path=" + path);
        }
        if (contextName == null) {
            throw new ProcessingException("SessionManager.getContextFragment: Name is required");
        }
        if (path == null) {
            throw new ProcessingException("SessionManager.getContextFragment: Path is required");
        }
        SessionContext context = this.contextManager.getContext(contextName);
        if (context == null) {
            throw new ProcessingException("SessionManager.getContextFragment: Context '" + contextName + "' not found.");
        }
        DocumentFragment frag = context.getXML(path);
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("END getContextFragment documentFragment=" + (frag == null ? "null" : XMLUtils.serializeNode((Node)frag, (Properties)XMLUtils.createPropertiesForXML((boolean)false))));
        }
        return frag;
    }

    public boolean streamContextFragment(String contextName, String path, XMLConsumer consumer) throws SAXException, ProcessingException {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("BEGIN streamContextFragment name=" + contextName + ", path=" + path + ", consumer" + consumer);
        }
        boolean streamed = false;
        if (contextName == null) {
            throw new ProcessingException("SessionManager.streamContextFragment: Name is required");
        }
        if (path == null) {
            throw new ProcessingException("SessionManager.streamContextFragment: Path is required");
        }
        SessionContext context = this.contextManager.getContext(contextName);
        if (context == null) {
            throw new ProcessingException("SessionManager.streamContextFragment: Context '" + contextName + "' not found.");
        }
        streamed = context.streamXML(path, (ContentHandler)consumer, (LexicalHandler)consumer);
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("END streamContextFragment streamed=" + streamed);
        }
        return streamed;
    }

    public void setContextFragment(String contextName, String path, DocumentFragment fragment) throws ProcessingException {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("BEGIN setContextFragment name=" + contextName + ", path=" + path + ", fragment=" + (fragment == null ? "null" : XMLUtils.serializeNode((Node)fragment, (Properties)XMLUtils.createPropertiesForXML((boolean)false))));
        }
        if (contextName == null) {
            throw new ProcessingException("SessionManager.setContextFragment: Name is required");
        }
        if (path == null) {
            throw new ProcessingException("SessionManager.setContextFragment: Path is required");
        }
        if (fragment == null) {
            throw new ProcessingException("SessionManager.setContextFragment: Fragment is required");
        }
        SessionContext context = this.contextManager.getContext(contextName);
        if (context == null) {
            throw new ProcessingException("SessionManager.setContextFragment: Context '" + contextName + "' not found.");
        }
        context.setXML(path, fragment);
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("END setContextFragment");
        }
    }

    public void appendContextFragment(String contextName, String path, DocumentFragment fragment) throws ProcessingException {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("BEGIN appendContextFragment name=" + contextName + ", path=" + path + ", fragment=" + (fragment == null ? "null" : XMLUtils.serializeNode((Node)fragment, (Properties)XMLUtils.createPropertiesForXML((boolean)false))));
        }
        if (contextName == null) {
            throw new ProcessingException("SessionManager.appendContextFragment: Name is required");
        }
        if (path == null) {
            throw new ProcessingException("SessionManager.appendContextFragment: Path is required");
        }
        if (fragment == null) {
            throw new ProcessingException("SessionManager.appendContextFragment: Fragment is required");
        }
        SessionContext context = this.contextManager.getContext(contextName);
        if (context == null) {
            throw new ProcessingException("SessionManager.appendContextFragment: Context '" + contextName + "' not found.");
        }
        context.appendXML(path, fragment);
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("END appendContextFragment");
        }
    }

    public void mergeContextFragment(String contextName, String path, DocumentFragment fragment) throws ProcessingException {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("BEGIN mergeContextFragment name=" + contextName + ", path=" + path + ", fragment=" + (fragment == null ? "null" : XMLUtils.serializeNode((Node)fragment, (Properties)XMLUtils.createPropertiesForXML((boolean)false))));
        }
        if (contextName == null) {
            throw new ProcessingException("SessionManager.mergeContextFragment: Name is required");
        }
        if (path == null) {
            throw new ProcessingException("SessionManager.mergeContextFragment: Path is required");
        }
        if (fragment == null) {
            throw new ProcessingException("SessionManager.mergeContextFragment: Fragment is required");
        }
        SessionContext context = this.contextManager.getContext(contextName);
        if (context == null) {
            throw new ProcessingException("SessionManager.mergeContextFragment: Context '" + contextName + "' not found.");
        }
        Node contextNode = context.getSingleNode(path);
        if (contextNode == null) {
            context.setXML(path, fragment);
        } else {
            this.importNode(contextNode, fragment, false);
            context.setNode(path, contextNode);
        }
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("END mergeContextFragment");
        }
    }

    public void removeContextFragment(String contextName, String path) throws ProcessingException {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("BEGIN removeContextFragment name=" + contextName + ", path=" + path);
        }
        if (contextName == null) {
            throw new ProcessingException("SessionManager.removeContextFragment: Name is required");
        }
        if (path == null) {
            throw new ProcessingException("SessionManager.removeContextFragment: Path is required");
        }
        SessionContext context = this.contextManager.getContext(contextName);
        if (context == null) {
            throw new ProcessingException("SessionManager.removeContextFragment: Context '" + contextName + "' not found.");
        }
        context.removeXML(path);
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("END removeContextFragment");
        }
    }

    private void importNode(Node profile, Node delta, boolean preserve) {
        NodeList profileChilds = null;
        NodeList deltaChilds = delta.getChildNodes();
        Node currentDelta = null;
        Node currentProfile = null;
        int len = deltaChilds.getLength();
        for (int i = 0; i < len; ++i) {
            currentDelta = deltaChilds.item(i);
            if (currentDelta.getNodeType() != 1) continue;
            profileChilds = profile.getChildNodes();
            int l = profileChilds.getLength();
            int m = 0;
            boolean found = false;
            while (!found && m < l) {
                currentProfile = profileChilds.item(m);
                if (currentProfile.getNodeType() == 1 && currentProfile.getNodeName().equals(currentDelta.getNodeName())) {
                    found = DOMUtil.compareAttributes((Element)((Element)currentProfile), (Element)((Element)currentDelta));
                }
                if (found) continue;
                ++m;
            }
            if (found) {
                int index;
                if (preserve && ((Element)currentDelta).hasAttributeNS("http://apache.org/cocoon/session/1.0", "preserve") && ((Element)currentDelta).getAttributeNS("http://apache.org/cocoon/session/1.0", "preserve").equalsIgnoreCase("true")) {
                    profile.replaceChild(profile.getOwnerDocument().importNode(currentDelta, true), currentProfile);
                    continue;
                }
                if (!currentDelta.hasChildNodes()) continue;
                currentDelta.normalize();
                currentProfile.normalize();
                this.importNode(currentProfile, currentDelta, preserve);
                NodeList childs = currentProfile.getChildNodes();
                int max = childs.getLength();
                for (index = max - 1; index >= 0; --index) {
                    if (childs.item(index).getNodeType() != 3) continue;
                    currentProfile.removeChild(childs.item(index));
                }
                childs = currentDelta.getChildNodes();
                max = childs.getLength();
                for (index = 0; index < max; ++index) {
                    if (childs.item(index).getNodeType() != 3) continue;
                    currentProfile.appendChild(currentProfile.getOwnerDocument().createTextNode(childs.item(index).getNodeValue()));
                }
                continue;
            }
            profile.appendChild(profile.getOwnerDocument().importNode(currentDelta, true));
        }
    }

    public void contextualize(Context context) throws ContextException {
        this.context = context;
    }
}

